/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import androidx.fragment.app.Fragment;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.dynamic.IFragmentWrapper;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;

@KeepForSdk
public final class SupportFragmentWrapper
extends IFragmentWrapper.Stub {
    private Fragment mFragment;

    @KeepForSdk
    public static SupportFragmentWrapper wrap(Fragment fragment) {
        if (fragment != null) {
            return new SupportFragmentWrapper(fragment);
        }
        return null;
    }

    private SupportFragmentWrapper(Fragment fragment) {
        this.mFragment = fragment;
    }

    @Override
    public final IObjectWrapper zzad() {
        return ObjectWrapper.wrap(this.mFragment.getActivity());
    }

    @Override
    public final Bundle getArguments() {
        return this.mFragment.getArguments();
    }

    @Override
    public final int getId() {
        return this.mFragment.getId();
    }

    @Override
    public final IFragmentWrapper zzae() {
        return SupportFragmentWrapper.wrap(this.mFragment.getParentFragment());
    }

    @Override
    public final IObjectWrapper zzaf() {
        return ObjectWrapper.wrap(this.mFragment.getResources());
    }

    @Override
    public final boolean getRetainInstance() {
        return this.mFragment.getRetainInstance();
    }

    @Override
    public final String getTag() {
        return this.mFragment.getTag();
    }

    @Override
    public final IFragmentWrapper zzag() {
        return SupportFragmentWrapper.wrap(this.mFragment.getTargetFragment());
    }

    @Override
    public final int getTargetRequestCode() {
        return this.mFragment.getTargetRequestCode();
    }

    @Override
    public final boolean getUserVisibleHint() {
        return this.mFragment.getUserVisibleHint();
    }

    @Override
    public final IObjectWrapper zzah() {
        return ObjectWrapper.wrap(this.mFragment.getView());
    }

    @Override
    public final boolean isAdded() {
        return this.mFragment.isAdded();
    }

    @Override
    public final boolean isDetached() {
        return this.mFragment.isDetached();
    }

    @Override
    public final boolean isHidden() {
        return this.mFragment.isHidden();
    }

    @Override
    public final boolean isInLayout() {
        return this.mFragment.isInLayout();
    }

    @Override
    public final boolean isRemoving() {
        return this.mFragment.isRemoving();
    }

    @Override
    public final boolean isResumed() {
        return this.mFragment.isResumed();
    }

    @Override
    public final boolean isVisible() {
        return this.mFragment.isVisible();
    }

    @Override
    public final void zza(IObjectWrapper iObjectWrapper) {
        View view = (View)ObjectWrapper.unwrap(iObjectWrapper);
        this.mFragment.registerForContextMenu(view);
    }

    @Override
    public final void setHasOptionsMenu(boolean bl) {
        this.mFragment.setHasOptionsMenu(bl);
    }

    @Override
    public final void setMenuVisibility(boolean bl) {
        this.mFragment.setMenuVisibility(bl);
    }

    @Override
    public final void setRetainInstance(boolean bl) {
        this.mFragment.setRetainInstance(bl);
    }

    @Override
    public final void setUserVisibleHint(boolean bl) {
        this.mFragment.setUserVisibleHint(bl);
    }

    @Override
    public final void startActivity(Intent intent) {
        this.mFragment.startActivity(intent);
    }

    @Override
    public final void startActivityForResult(Intent intent, int n) {
        this.mFragment.startActivityForResult(intent, n);
    }

    @Override
    public final void zzb(IObjectWrapper iObjectWrapper) {
        View view = (View)ObjectWrapper.unwrap(iObjectWrapper);
        this.mFragment.unregisterForContextMenu(view);
    }
}

