/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzb;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;

@SafeParcelable.Class(creator="StatusCreator")
@KeepForSdk
public final class Status
extends AbstractSafeParcelable
implements Result,
ReflectedParcelable {
    @VisibleForTesting
    @KeepForSdk
    @ShowFirstParty
    public static final Status RESULT_SUCCESS = new Status(0);
    @KeepForSdk
    @ShowFirstParty
    public static final Status RESULT_INTERRUPTED = new Status(14);
    @KeepForSdk
    @ShowFirstParty
    public static final Status RESULT_INTERNAL_ERROR = new Status(8);
    @KeepForSdk
    @ShowFirstParty
    public static final Status RESULT_TIMEOUT = new Status(15);
    @KeepForSdk
    public static final Status RESULT_CANCELED = new Status(16);
    @ShowFirstParty
    private static final Status zzbd = new Status(17);
    @KeepForSdk
    public static final Status RESULT_DEAD_CLIENT = new Status(18);
    public static final Parcelable.Creator<Status> CREATOR = new zzb();
    @SafeParcelable.VersionField(id=1000)
    private final int zzq;
    @SafeParcelable.Field(id=1, getter="getStatusCode")
    private final int zzr;
    @SafeParcelable.Field(id=2, getter="getStatusMessage")
    @Nullable
    private final String zzt;
    @SafeParcelable.Field(id=3, getter="getPendingIntent")
    @Nullable
    private final PendingIntent zzs;

    @SafeParcelable.Constructor
    @KeepForSdk
    Status(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) int n2, @SafeParcelable.Param(id=2) @Nullable String string2, @SafeParcelable.Param(id=3) @Nullable PendingIntent pendingIntent) {
        this.zzq = n;
        this.zzr = n2;
        this.zzt = string2;
        this.zzs = pendingIntent;
    }

    @KeepForSdk
    public Status(int n) {
        this(n, null);
    }

    @KeepForSdk
    public Status(int n, @Nullable String string2) {
        this(1, n, string2, null);
    }

    @KeepForSdk
    public Status(int n, @Nullable String string2, @Nullable PendingIntent pendingIntent) {
        this(1, n, string2, pendingIntent);
    }

    public final void startResolutionForResult(Activity activity, int n) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.zzs.getIntentSender(), n, null, 0, 0, 0);
    }

    @Nullable
    public final String getStatusMessage() {
        return this.zzt;
    }

    @VisibleForTesting
    public final boolean hasResolution() {
        return this.zzs != null;
    }

    public final boolean isSuccess() {
        return this.zzr <= 0;
    }

    public final boolean isCanceled() {
        return this.zzr == 16;
    }

    public final boolean isInterrupted() {
        return this.zzr == 14;
    }

    public final int getStatusCode() {
        return this.zzr;
    }

    public final PendingIntent getResolution() {
        return this.zzs;
    }

    public final int hashCode() {
        return Objects.hashCode(this.zzq, this.zzr, this.zzt, this.zzs);
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Status)) {
            return false;
        }
        Status status = (Status)object;
        return this.zzq == status.zzq && this.zzr == status.zzr && Objects.equal(this.zzt, status.zzt) && Objects.equal(this.zzs, status.zzs);
    }

    public final String zzg() {
        if (this.zzt != null) {
            return this.zzt;
        }
        return CommonStatusCodes.getStatusCodeString(this.zzr);
    }

    public final String toString() {
        return Objects.toStringHelper(this).add("statusCode", this.zzg()).add("resolution", this.zzs).toString();
    }

    @KeepForSdk
    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Status status = this;
        int n2 = SafeParcelWriter.beginObjectHeader(parcel2);
        SafeParcelWriter.writeInt(parcel2, 1, status.getStatusCode());
        SafeParcelWriter.writeString(parcel2, 2, status.getStatusMessage(), false);
        SafeParcelWriter.writeParcelable(parcel2, 3, (Parcelable)status.zzs, n, false);
        SafeParcelWriter.writeInt(parcel2, 1000, status.zzq);
        SafeParcelWriter.finishObjectHeader(parcel2, n2);
    }

    @Override
    @KeepForSdk
    public final Status getStatus() {
        return this;
    }
}

