/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.wrappers;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AppOpsManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.Binder;
import android.os.Process;
import android.support.v4.content.PermissionChecker;
import android.support.v4.util.Pair;
import android.util.Log;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.wrappers.InstantApps;

public class PackageManagerWrapper {
    private final Context zzjp;

    public PackageManagerWrapper(Context context) {
        this.zzjp = context;
    }

    public ApplicationInfo getApplicationInfo(String string2, int n) throws PackageManager.NameNotFoundException {
        return this.zzjp.getPackageManager().getApplicationInfo(string2, n);
    }

    public PackageInfo getPackageInfo(String string2, int n) throws PackageManager.NameNotFoundException {
        return this.zzjp.getPackageManager().getPackageInfo(string2, n);
    }

    public String[] getPackagesForUid(int n) {
        return this.zzjp.getPackageManager().getPackagesForUid(n);
    }

    public void checkPackage(int n, String string2) {
        if (!this.uidHasPackageName(n, string2)) {
            throw new SecurityException(new StringBuilder(39 + String.valueOf(string2).length()).append("Package ").append(string2).append(" does not belong to ").append(n).toString());
        }
    }

    @TargetApi(value=19)
    public boolean uidHasPackageName(int n, String string2) {
        if (PlatformVersion.isAtLeastKitKat()) {
            try {
                ((AppOpsManager)this.zzjp.getSystemService("appops")).checkPackage(n, string2);
                return true;
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        String[] stringArray = this.zzjp.getPackageManager().getPackagesForUid(n);
        if (string2 != null && stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public int checkPermission(String string2, int n, int n2) {
        return this.zzjp.checkPermission(string2, n, n2);
    }

    @Deprecated
    public int checkPermission(String string2, int n, int n2, String string3) {
        return this.checkPermission(string2, n, n2);
    }

    public int checkPermissionAndAppOps(String string2, int n, int n2, String string3) {
        return PermissionChecker.checkPermission((Context)this.zzjp, (String)string2, (int)n, (int)n2, (String)string3);
    }

    public int checkCallingPermission(String string2) {
        return this.zzjp.checkCallingPermission(string2);
    }

    public int checkCallingPermissionAndAppOps(String string2, String string3) {
        return PermissionChecker.checkCallingPermission((Context)this.zzjp, (String)string2, (String)string3);
    }

    public int checkCallingOrSelfPermission(String string2) {
        return this.zzjp.checkCallingOrSelfPermission(string2);
    }

    public int checkCallingOrSelfPermissionAndAppOps(String string2) {
        return PermissionChecker.checkCallingOrSelfPermission((Context)this.zzjp, (String)string2);
    }

    @Deprecated
    public int checkCallingPermission(String string2, String string3) {
        return this.checkPermission(string2, string3);
    }

    public int checkPermission(String string2, String string3) {
        return this.zzjp.getPackageManager().checkPermission(string2, string3);
    }

    public String getCallingPackage(Activity activity) {
        ComponentName componentName = activity.getCallingActivity();
        if (componentName == null) {
            return null;
        }
        String string2 = componentName.getPackageName();
        if (string2 == null) {
            String string3 = String.valueOf(componentName);
            Log.e((String)"PackageManagerWrapper", (String)new StringBuilder(54 + String.valueOf(string3).length()).append("getCallingPackage(): Couldn't get a package name from ").append(string3).toString());
            return null;
        }
        return string2;
    }

    public ComponentName getCallingActivity(Activity activity) {
        return activity.getCallingActivity();
    }

    public CharSequence getApplicationLabel(String string2) throws PackageManager.NameNotFoundException {
        return this.zzjp.getPackageManager().getApplicationLabel(this.zzjp.getPackageManager().getApplicationInfo(string2, 0));
    }

    public Pair<CharSequence, Drawable> getApplicationLabelAndIcon(String string2) throws PackageManager.NameNotFoundException {
        ApplicationInfo applicationInfo = this.zzjp.getPackageManager().getApplicationInfo(string2, 0);
        return Pair.create((Object)this.zzjp.getPackageManager().getApplicationLabel(applicationInfo), (Object)this.zzjp.getPackageManager().getApplicationIcon(applicationInfo));
    }

    public boolean isCallerInstantApp() {
        String string2;
        if (Binder.getCallingUid() == Process.myUid()) {
            return InstantApps.isInstantApp(this.zzjp);
        }
        if (PlatformVersion.isAtLeastO() && (string2 = this.zzjp.getPackageManager().getNameForUid(Binder.getCallingUid())) != null) {
            String string3 = string2;
            return this.zzjp.getPackageManager().isInstantApp(string3);
        }
        return false;
    }

    public boolean isInstantAppUid(int n) {
        return false;
    }

    public void checkCallerIsNotInstantApp() {
        if (this.isCallerInstantApp()) {
            throw new SecurityException("This operation is not supported for instant apps.");
        }
    }

    public boolean allowApiAccess(String string2, int n) {
        return true;
    }

    protected Context getContext() {
        return this.zzjp;
    }
}

