/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.internal.stable.zzk;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Set;
import javax.annotation.Nullable;

public final class DbUtils {
    private DbUtils() {
    }

    public static void clearDatabase(SQLiteDatabase sQLiteDatabase) {
        DbUtils.zza(sQLiteDatabase, "table", "sqlite_sequence", "android_metadata");
        DbUtils.zza(sQLiteDatabase, "trigger", new String[0]);
        DbUtils.zza(sQLiteDatabase, "view", new String[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void zza(SQLiteDatabase sQLiteDatabase, String string2, String ... stringArray) {
        Preconditions.checkArgument("table".equals(string2) || "view".equals(string2) || "trigger".equals(string2));
        Cursor cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "type == ?", new String[]{string2}, null, null, null);
        Throwable throwable = null;
        try {
            Set<String> set = CollectionUtils.setOf(stringArray);
            while (cursor.moveToNext()) {
                String string3 = cursor.getString(0);
                if (set.contains(string3)) continue;
                sQLiteDatabase.execSQL(new StringBuilder(8 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("DROP ").append(string2).append(" '").append(string3).append("'").toString());
            }
            if (cursor == null) return;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (cursor == null) throw throwable4;
                if (throwable != null) {
                    try {
                        cursor.close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        zzk.zza(throwable, throwable5);
                    }
                    throw throwable4;
                } else {
                    cursor.close();
                }
                throw throwable4;
            }
        }
        cursor.close();
        return;
    }

    @Nullable
    public static Integer getIntegerFromCursor(Cursor cursor, int n, @Nullable Integer n2) {
        if (n < 0 || cursor.isNull(n)) {
            return n2;
        }
        return cursor.getInt(n);
    }

    @Nullable
    public static Integer getIntegerFromCursor(Cursor cursor, int n) {
        return DbUtils.getIntegerFromCursor(cursor, n, null);
    }

    @Nullable
    public static Long getLongFromCursor(Cursor cursor, int n, @Nullable Long l) {
        if (n < 0 || cursor.isNull(n)) {
            return l;
        }
        return cursor.getLong(n);
    }

    @Nullable
    public static Long getLongFromCursor(Cursor cursor, int n) {
        return DbUtils.getLongFromCursor(cursor, n, null);
    }

    @Nullable
    public static String getStringFromCursor(Cursor cursor, int n, @Nullable String string2) {
        if (n < 0 || cursor.isNull(n)) {
            return string2;
        }
        return cursor.getString(n);
    }

    @Nullable
    public static String getStringFromCursor(Cursor cursor, int n) {
        return DbUtils.getStringFromCursor(cursor, n, null);
    }

    public static void putIntegerIntoContentValues(ContentValues contentValues, String string2, @Nullable Integer n) {
        if (n != null) {
            contentValues.put(string2, n);
            return;
        }
        contentValues.putNull(string2);
    }

    public static void putLongIntoContentValues(ContentValues contentValues, String string2, @Nullable Long l) {
        if (l != null) {
            contentValues.put(string2, l);
            return;
        }
        contentValues.putNull(string2);
    }

    public static void putStringIntoContentValues(ContentValues contentValues, String string2, @Nullable String string3) {
        if (string3 != null) {
            contentValues.put(string2, string3);
            return;
        }
        contentValues.putNull(string2);
    }

    public static long getDatabaseSize(Context context, String string2) {
        try {
            File file = context.getDatabasePath(string2);
            if (file != null) {
                return file.length();
            }
        }
        catch (SecurityException securityException) {
            String string3 = String.valueOf(string2);
            Log.w((String)"DbUtils", (String)(string3.length() != 0 ? "Failed to get db size for ".concat(string3) : new String("Failed to get db size for ")));
        }
        return 0L;
    }

    public static long countCurrentRowBytes(Cursor cursor, Charset charset) {
        long l = 0L;
        block5: for (int i = 0; i < cursor.getColumnCount(); ++i) {
            switch (cursor.getType(i)) {
                case 4: {
                    l += (long)cursor.getBlob(i).length;
                    continue block5;
                }
                case 3: {
                    l += (long)cursor.getString(i).getBytes(charset).length;
                    continue block5;
                }
                case 0: 
                case 1: 
                case 2: {
                    l += 4L;
                }
            }
        }
        return l;
    }

    public static long countCurrentRowBytes(Cursor cursor) {
        return DbUtils.countCurrentRowBytes(cursor, Charset.forName("UTF-8"));
    }
}

