/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.database.CharArrayBuffer;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.text.TextUtils;
import com.google.android.gms.common.util.IOUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class DataUtils {
    public DataUtils() {
    }

    public static void copyStringToBuffer(String string2, CharArrayBuffer charArrayBuffer) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            charArrayBuffer.sizeCopied = 0;
        } else if (charArrayBuffer.data == null || charArrayBuffer.data.length < string2.length()) {
            charArrayBuffer.data = string2.toCharArray();
        } else {
            string2.getChars(0, string2.length(), charArrayBuffer.data, 0);
        }
        charArrayBuffer.sizeCopied = string2.length();
    }

    @VisibleForTesting
    public static byte[] loadImageBytes(Resources resources, int n) {
        try {
            return IOUtils.readInputStreamFully(resources.openRawResource(n));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static byte[] loadImageBytes(AssetManager assetManager, String string2) {
        try {
            return IOUtils.readInputStreamFully(assetManager.open(string2));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static byte[] loadImageBytes(BitmapDrawable bitmapDrawable) {
        return DataUtils.loadImageBytes(bitmapDrawable.getBitmap());
    }

    public static byte[] loadImageBytes(Bitmap bitmap) {
        return DataUtils.loadImageBytes(bitmap, 100);
    }

    public static byte[] loadImageBytes(Bitmap bitmap, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, n, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

