/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.HashMap;
import javax.annotation.concurrent.GuardedBy;

final class zzh
extends GmsClientSupervisor
implements Handler.Callback {
    @GuardedBy(value="mConnectionStatus")
    private final HashMap<GmsClientSupervisor.ConnectionStatusConfig, zzi> zztr = new HashMap();
    private final Context zzau;
    private final Handler mHandler;
    private final ConnectionTracker zzts;
    private final long zztt;
    private final long zztu;

    zzh(Context context) {
        this.zzau = context.getApplicationContext();
        this.mHandler = new Handler(context.getMainLooper(), (Handler.Callback)this);
        this.zzts = ConnectionTracker.getInstance();
        this.zztt = 5000L;
        this.zztu = 300000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean bindService(GmsClientSupervisor.ConnectionStatusConfig connectionStatusConfig, ServiceConnection serviceConnection, String string2) {
        Preconditions.checkNotNull(serviceConnection, "ServiceConnection must not be null");
        HashMap<GmsClientSupervisor.ConnectionStatusConfig, zzi> hashMap = this.zztr;
        synchronized (hashMap) {
            zzi zzi2 = this.zztr.get(connectionStatusConfig);
            if (zzi2 == null) {
                zzi2 = new zzi(this, connectionStatusConfig);
                zzi2.zza(serviceConnection, string2);
                zzi2.zzj(string2);
                this.zztr.put(connectionStatusConfig, zzi2);
            } else {
                this.mHandler.removeMessages(0, (Object)connectionStatusConfig);
                if (zzi2.zza(serviceConnection)) {
                    String string3 = String.valueOf(connectionStatusConfig);
                    throw new IllegalStateException(new StringBuilder(81 + String.valueOf(string3).length()).append("Trying to bind a GmsServiceConnection that was already connected before.  config=").append(string3).toString());
                }
                zzi2.zza(serviceConnection, string2);
                switch (zzi2.getState()) {
                    case 1: {
                        serviceConnection.onServiceConnected(zzi2.getComponentName(), zzi2.getBinder());
                        break;
                    }
                    case 2: {
                        zzi2.zzj(string2);
                    }
                }
            }
            return zzi2.isBound();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void unbindService(GmsClientSupervisor.ConnectionStatusConfig connectionStatusConfig, ServiceConnection serviceConnection, String string2) {
        Preconditions.checkNotNull(serviceConnection, "ServiceConnection must not be null");
        HashMap<GmsClientSupervisor.ConnectionStatusConfig, zzi> hashMap = this.zztr;
        synchronized (hashMap) {
            zzi zzi2 = this.zztr.get(connectionStatusConfig);
            if (zzi2 == null) {
                String string3 = String.valueOf(connectionStatusConfig);
                throw new IllegalStateException(new StringBuilder(50 + String.valueOf(string3).length()).append("Nonexistent connection status for service config: ").append(string3).toString());
            }
            if (!zzi2.zza(serviceConnection)) {
                String string4 = String.valueOf(connectionStatusConfig);
                throw new IllegalStateException(new StringBuilder(76 + String.valueOf(string4).length()).append("Trying to unbind a GmsServiceConnection  that was not bound before.  config=").append(string4).toString());
            }
            zzi2.zzb(serviceConnection, string2);
            if (zzi2.zzcv()) {
                Message message = this.mHandler.obtainMessage(0, (Object)connectionStatusConfig);
                this.mHandler.sendMessageDelayed(message, this.zztt);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean handleMessage(Message message) {
        switch (message.what) {
            case 0: {
                HashMap<GmsClientSupervisor.ConnectionStatusConfig, zzi> hashMap = this.zztr;
                synchronized (hashMap) {
                    GmsClientSupervisor.ConnectionStatusConfig connectionStatusConfig = (GmsClientSupervisor.ConnectionStatusConfig)message.obj;
                    zzi zzi2 = this.zztr.get(connectionStatusConfig);
                    if (zzi2 != null && zzi2.zzcv()) {
                        if (zzi2.isBound()) {
                            zzi2.zzk("GmsClientSupervisor");
                        }
                        this.zztr.remove(connectionStatusConfig);
                    }
                }
                return true;
            }
            case 1: {
                HashMap<GmsClientSupervisor.ConnectionStatusConfig, zzi> hashMap = this.zztr;
                synchronized (hashMap) {
                    GmsClientSupervisor.ConnectionStatusConfig connectionStatusConfig = (GmsClientSupervisor.ConnectionStatusConfig)message.obj;
                    zzi zzi3 = this.zztr.get(connectionStatusConfig);
                    if (zzi3 != null && zzi3.getState() == 3) {
                        String string2 = String.valueOf(connectionStatusConfig);
                        Log.wtf((String)"GmsClientSupervisor", (String)new StringBuilder(47 + String.valueOf(string2).length()).append("Timeout waiting for ServiceConnection callback ").append(string2).toString(), (Throwable)new Exception());
                        string2 = zzi3.getComponentName();
                        if (string2 == null) {
                            string2 = connectionStatusConfig.getComponentName();
                        }
                        if (string2 == null) {
                            string2 = new ComponentName(connectionStatusConfig.getPackage(), "unknown");
                        }
                        zzi3.onServiceDisconnected((ComponentName)string2);
                    }
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public final void resetForTesting() {
        HashMap<GmsClientSupervisor.ConnectionStatusConfig, zzi> hashMap = this.zztr;
        synchronized (hashMap) {
            for (zzi zzi2 : this.zztr.values()) {
                this.mHandler.removeMessages(0, (Object)zzi.zza(zzi2));
                if (!zzi2.isBound()) continue;
                zzi2.zzk("GmsClientSupervisor");
            }
            this.zztr.clear();
            return;
        }
    }

    static /* synthetic */ HashMap zza(zzh zzh2) {
        return zzh2.zztr;
    }

    static /* synthetic */ Handler zzb(zzh zzh2) {
        return zzh2.mHandler;
    }

    static /* synthetic */ Context zzc(zzh zzh2) {
        return zzh2.zzau;
    }

    static /* synthetic */ ConnectionTracker zzd(zzh zzh2) {
        return zzh2.zzts;
    }

    static /* synthetic */ long zze(zzh zzh2) {
        return zzh2.zztu;
    }
}

