/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.support.v4.util.LruCache;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zze;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ExpirableLruCache<K, V> {
    public static int TIME_UNSET = -1;
    private final Object mLock = new Object();
    private final LruCache<K, V> zzsn;
    private final long zzso;
    private final long zzsp;
    private HashMap<K, Long> zzsq;
    private HashMap<K, Long> zzsr;

    public ExpirableLruCache(int n, long l, long l2, TimeUnit timeUnit) {
        this.zzso = TimeUnit.NANOSECONDS.convert(l, timeUnit);
        this.zzsp = TimeUnit.NANOSECONDS.convert(l2, timeUnit);
        Preconditions.checkArgument(this.zzct() || this.zzcu(), "ExpirableLruCache has both access and write expiration negative");
        this.zzsn = new zze(this, n);
        if (this.zzct()) {
            this.zzsq = new HashMap();
        }
        if (this.zzcu()) {
            this.zzsr = new HashMap();
        }
    }

    protected int sizeOf(K k, V v) {
        return 1;
    }

    protected V create(K k) {
        return null;
    }

    protected void entryRemoved(boolean bl, K k, V v, V v2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K k, V v) {
        if (this.zzcu()) {
            long l = System.nanoTime();
            Object object = this.mLock;
            synchronized (object) {
                this.zzsr.put(k, l);
            }
        }
        return (V)this.zzsn.put(k, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K k) {
        Object object;
        Object object2 = this.mLock;
        synchronized (object2) {
            if (this.zza(k)) {
                this.zzsn.remove(k);
            }
            if ((object = this.zzsn.get(k)) != null && this.zzso > 0L) {
                long l = System.nanoTime();
                this.zzsq.put(k, l);
            }
        }
        return (V)object;
    }

    public V remove(K k) {
        return (V)this.zzsn.remove(k);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExpired() {
        for (Object k : this.zzsn.snapshot().keySet()) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.zza(k)) {
                    this.zzsn.remove(k);
                }
            }
        }
    }

    public Map<K, V> snapshot() {
        this.removeExpired();
        return this.zzsn.snapshot();
    }

    public void evictAll() {
        this.zzsn.evictAll();
    }

    private final boolean zza(K k) {
        long l = System.nanoTime();
        if (this.zzct() && this.zzsq.containsKey(k) && l - this.zzsq.get(k) > this.zzso) {
            return true;
        }
        return this.zzcu() && this.zzsr.containsKey(k) && l - this.zzsr.get(k) > this.zzsp;
    }

    private final boolean zzct() {
        return this.zzso >= 0L;
    }

    private final boolean zzcu() {
        return this.zzsp >= 0L;
    }

    static /* synthetic */ Object zza(ExpirableLruCache expirableLruCache) {
        return expirableLruCache.mLock;
    }

    static /* synthetic */ boolean zzb(ExpirableLruCache expirableLruCache) {
        return expirableLruCache.zzct();
    }

    static /* synthetic */ HashMap zzc(ExpirableLruCache expirableLruCache) {
        return expirableLruCache.zzsq;
    }

    static /* synthetic */ boolean zzd(ExpirableLruCache expirableLruCache) {
        return expirableLruCache.zzcu();
    }

    static /* synthetic */ HashMap zze(ExpirableLruCache expirableLruCache) {
        return expirableLruCache.zzsr;
    }
}

