/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zzag;
import com.google.android.gms.common.internal.zzah;
import com.google.android.gms.common.internal.zzam;
import com.google.android.gms.common.internal.zzan;
import com.google.android.gms.common.internal.zzay;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.internal.zzn;
import com.google.android.gms.common.internal.zzo;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zze;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzd<T extends IInterface> {
    private int zzfvj;
    private long zzfvk;
    private long zzfvl;
    private int zzfvm;
    private long zzfvn;
    private zzam zzfvo;
    private final Context mContext;
    private final Looper zzakm;
    private final zzag zzfvp;
    private final zze zzfni;
    final Handler mHandler;
    private final Object mLock = new Object();
    private final Object zzfvq = new Object();
    private zzay zzfvr;
    protected zzj zzfvs;
    private T zzfvt;
    private final ArrayList<zzi<?>> zzfvu = new ArrayList();
    private zzl zzfvv;
    private int zzfvw = 1;
    private final zzf zzfvx;
    private final zzg zzfvy;
    private final int zzfvz;
    private final String zzfwa;
    private ConnectionResult zzfwb = null;
    private boolean zzfwc = false;
    protected AtomicInteger zzfwd = new AtomicInteger(0);
    private static String[] zzfwe = new String[]{"service_esmobile", "service_googleme"};

    protected zzd(Context context, Looper looper, int n, zzf zzf2, zzg zzg2, String string2) {
        this(context, looper, zzag.zzcl(context), zze.zzafm(), n, zzbq.checkNotNull(zzf2), zzbq.checkNotNull(zzg2), null);
    }

    protected zzd(Context context, Looper looper, zzag zzag2, zze zze2, int n, zzf zzf2, zzg zzg2, String string2) {
        this.mContext = zzbq.checkNotNull(context, "Context must not be null");
        this.zzakm = zzbq.checkNotNull(looper, "Looper must not be null");
        this.zzfvp = zzbq.checkNotNull(zzag2, "Supervisor must not be null");
        this.zzfni = zzbq.checkNotNull(zze2, "API availability must not be null");
        this.mHandler = new zzh(this, looper);
        this.zzfvz = n;
        this.zzfvx = zzf2;
        this.zzfvy = zzg2;
        this.zzfwa = string2;
    }

    @NonNull
    protected abstract String zzhf();

    protected String zzajv() {
        return "com.google.android.gms";
    }

    @NonNull
    protected abstract String zzhg();

    @Nullable
    private final String zzajw() {
        if (this.zzfwa == null) {
            return this.mContext.getClass().getName();
        }
        return this.zzfwa;
    }

    @Nullable
    protected abstract T zzd(IBinder var1);

    @CallSuper
    protected void zza(@NonNull T t) {
        this.zzfvl = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionSuspended(int n) {
        this.zzfvj = n;
        this.zzfvk = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionFailed(ConnectionResult connectionResult) {
        this.zzfvm = connectionResult.getErrorCode();
        this.zzfvn = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(int n, T t) {
        zzbq.checkArgument(n == 4 == (t != null));
        Object object = this.mLock;
        synchronized (object) {
            this.zzfvw = n;
            this.zzfvt = t;
            switch (n) {
                case 2: 
                case 3: {
                    String string2;
                    zzd zzd2 = this;
                    if (zzd2.zzfvv != null && zzd2.zzfvo != null) {
                        String string3 = zzd2.zzfvo.zzalc();
                        string2 = zzd2.zzfvo.getPackageName();
                        Log.e((String)"GmsClient", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Calling connect() while still connected, missing disconnect() for ").append(string3).append(" on ").append(string2).toString());
                        zzd2.zzfvp.zza(zzd2.zzfvo.zzalc(), zzd2.zzfvo.getPackageName(), zzd2.zzfvo.zzaky(), zzd2.zzfvv, zzd2.zzajw());
                        zzd2.zzfwd.incrementAndGet();
                    }
                    zzd2.zzfvv = new zzl(zzd2, zzd2.zzfwd.get());
                    zzd zzd3 = zzd2;
                    zzd2.zzfvo = new zzam(zzd3.zzajv(), zzd3.zzhf(), false, 129);
                    String string4 = zzd2.zzajw();
                    zzl zzl2 = zzd2.zzfvv;
                    int n2 = zzd2.zzfvo.zzaky();
                    String string5 = zzd2.zzfvo.getPackageName();
                    String string6 = zzd2.zzfvo.zzalc();
                    if (zzd2.zzfvp.zza(new zzah(string6, string5, n2), (ServiceConnection)zzl2, string4)) break;
                    string2 = zzd2.zzfvo.zzalc();
                    String string7 = zzd2.zzfvo.getPackageName();
                    Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string7).length()).append("unable to connect to service: ").append(string2).append(" on ").append(string7).toString());
                    zzd2.zza(16, null, zzd2.zzfwd.get());
                    break;
                }
                case 4: {
                    this.zza(t);
                    break;
                }
                case 1: {
                    zzd zzd4 = this;
                    if (zzd4.zzfvv == null) break;
                    zzd4.zzfvp.zza(zzd4.zzhf(), zzd4.zzajv(), 129, zzd4.zzfvv, zzd4.zzajw());
                    zzd4.zzfvv = null;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(int n, int n2, T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzfvw != n) {
                return false;
            }
            this.zza(n2, t);
            return true;
        }
    }

    public final void zzajx() {
        int n = this.zzfni.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            this.zza(1, null);
            this.zza(new zzm(this), n, null);
            return;
        }
        this.zza(new zzm(this));
    }

    public void zza(@NonNull zzj zzj2) {
        this.zzfvs = zzbq.checkNotNull(zzj2, "Connection progress callbacks cannot be null.");
        this.zza(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnected() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzfvw == 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnecting() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzfvw == 2 || this.zzfvw == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zzajy() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzfvw == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.zzfwd.incrementAndGet();
        Object object = this.zzfvu;
        synchronized (object) {
            int n = this.zzfvu.size();
            for (int i = 0; i < n; ++i) {
                this.zzfvu.get(i).removeListener();
            }
            this.zzfvu.clear();
        }
        object = this.zzfvq;
        synchronized (object) {
            this.zzfvr = null;
        }
        this.zza(1, null);
    }

    public final void zzce(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, this.zzfwd.get(), n));
    }

    private final void zzcf(int n) {
        int n2;
        if (this.zzajy()) {
            n2 = 5;
            this.zzfwc = true;
        } else {
            n2 = 4;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(n2, this.zzfwd.get(), 16));
    }

    protected final void zza(@NonNull zzj zzj2, int n, @Nullable PendingIntent pendingIntent) {
        this.zzfvs = zzbq.checkNotNull(zzj2, "Connection progress callbacks cannot be null.");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzfwd.get(), n, (Object)pendingIntent));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.zzakm;
    }

    public Account getAccount() {
        return null;
    }

    public zzc[] zzajz() {
        return new zzc[0];
    }

    protected Bundle zzaae() {
        return new Bundle();
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzn(this, n, iBinder, bundle)));
    }

    protected final void zza(int n, @Nullable Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, n2, -1, (Object)new zzo(this, n, null)));
    }

    protected final void zzaka() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    public Bundle zzaew() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T zzakb() throws DeadObjectException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzfvw == 5) {
                throw new DeadObjectException();
            }
            this.zzaka();
            zzbq.zza(this.zzfvt != null, (Object)"Client is connected but service is null");
            return this.zzfvt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(zzan zzan2, Set<Scope> set) {
        Bundle bundle = this.zzaae();
        Object object = this.mContext.getPackageName();
        Object object2 = new zzz(this.zzfvz);
        new zzz(this.zzfvz).zzfwz = object;
        object = bundle;
        v0.zzfxc = object;
        zzz zzz2 = object2;
        if (set != null) {
            object = set;
            zzz2.zzfxb = object.toArray(new Scope[object.size()]);
        }
        if (this.zzaam()) {
            object2 = this;
            object = ((zzd)object2).getAccount() != null ? ((zzd)object2).getAccount() : new Account("<<default account>>", "com.google");
            object2 = zzz2;
            zzz2.zzfxd = object;
            object = zzan2;
            if (object != null) {
                ((zzz)object2).zzfxa = object.asBinder();
            }
        } else if (this.zzakc()) {
            zzz2.zzfxd = object = this.getAccount();
        }
        object = this.zzajz();
        zzz2.zzfxe = object;
        try {
            Object object3 = this.zzfvq;
            synchronized (object3) {
                if (this.zzfvr != null) {
                    this.zzfvr.zza(new zzk(this, this.zzfwd.get()), zzz2);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
                return;
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)deadObjectException);
            this.zzce(1);
            return;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (RemoteException | RuntimeException throwable) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)throwable);
            this.zza(8, null, null, this.zzfwd.get());
            return;
        }
    }

    public boolean zzaam() {
        return false;
    }

    public void zza(@NonNull zzp zzp2) {
        zzp2.zzait();
    }

    public boolean zzakc() {
        return false;
    }

    public boolean zzafu() {
        return true;
    }

    public boolean zzaaw() {
        return false;
    }

    public Intent getSignInIntent() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    protected Set<Scope> zzakd() {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3;
        long l;
        zzay zzay2;
        T t;
        int n;
        Object object = this.mLock;
        synchronized (object) {
            n = this.zzfvw;
            t = this.zzfvt;
        }
        object = this.zzfvq;
        synchronized (object) {
            zzay2 = this.zzfvr;
        }
        printWriter.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                printWriter.print("REMOTE_CONNECTING");
                break;
            }
            case 3: {
                printWriter.print("LOCAL_CONNECTING");
                break;
            }
            case 4: {
                printWriter.print("CONNECTED");
                break;
            }
            case 5: {
                printWriter.print("DISCONNECTING");
                break;
            }
            case 1: {
                printWriter.print("DISCONNECTED");
                break;
            }
            default: {
                printWriter.print("UNKNOWN");
            }
        }
        printWriter.append(" mService=");
        if (t == null) {
            printWriter.append("null");
        } else {
            printWriter.append(this.zzhg()).append("@").append(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        printWriter.append(" mServiceBroker=");
        if (zzay2 == null) {
            printWriter.println("null");
        } else {
            printWriter.append("IGmsServiceBroker@").println(Integer.toHexString(System.identityHashCode(zzay2.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.zzfvl > 0L) {
            l = this.zzfvl;
            string3 = ((DateFormat)object).format(new Date(this.zzfvl));
            printWriter.append(string2).append("lastConnectedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzfvk > 0L) {
            printWriter.append(string2).append("lastSuspendedCause=");
            switch (this.zzfvj) {
                case 1: {
                    printWriter.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 2: {
                    printWriter.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    printWriter.append(String.valueOf(this.zzfvj));
                }
            }
            l = this.zzfvk;
            string3 = ((DateFormat)object).format(new Date(this.zzfvk));
            printWriter.append(" lastSuspendedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzfvn > 0L) {
            printWriter.append(string2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.zzfvm));
            l = this.zzfvn;
            string3 = ((DateFormat)object).format(new Date(this.zzfvn));
            printWriter.append(" lastFailedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IBinder zzafv() {
        Object object = this.zzfvq;
        synchronized (object) {
            if (this.zzfvr == null) {
                return null;
            }
            return this.zzfvr.asBinder();
        }
    }

    private final boolean zzake() {
        if (this.zzfwc) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzhg())) {
            return false;
        }
        if (TextUtils.isEmpty(null)) {
            return false;
        }
        try {
            Class.forName(this.zzhg());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    static /* synthetic */ void zza(zzd zzd2, int n) {
        zzd2.zzcf(16);
    }

    static /* synthetic */ Object zza(zzd zzd2) {
        return zzd2.zzfvq;
    }

    static /* synthetic */ zzay zza(zzd zzd2, zzay zzay2) {
        zzd2.zzfvr = zzay2;
        return zzd2.zzfvr;
    }

    static /* synthetic */ ConnectionResult zza(zzd zzd2, ConnectionResult connectionResult) {
        zzd2.zzfwb = connectionResult;
        return zzd2.zzfwb;
    }

    static /* synthetic */ boolean zzb(zzd zzd2) {
        return zzd2.zzake();
    }

    static /* synthetic */ boolean zzc(zzd zzd2) {
        return zzd2.zzfwc;
    }

    static /* synthetic */ void zza(zzd zzd2, int n, IInterface iInterface) {
        zzd2.zza(n, null);
    }

    static /* synthetic */ ConnectionResult zzd(zzd zzd2) {
        return zzd2.zzfwb;
    }

    static /* synthetic */ zzf zze(zzd zzd2) {
        return zzd2.zzfvx;
    }

    static /* synthetic */ boolean zza(zzd zzd2, int n, int n2, IInterface iInterface) {
        return zzd2.zza(n, n2, iInterface);
    }

    static /* synthetic */ ArrayList zzf(zzd zzd2) {
        return zzd2.zzfvu;
    }

    static /* synthetic */ zzg zzg(zzd zzd2) {
        return zzd2.zzfvy;
    }
}

