/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzbyj;
import com.google.android.gms.internal.zzbym;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzbyc {
    private final ByteBuffer zzcwB;

    private zzbyc(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzbyc(ByteBuffer byteBuffer) {
        this.zzcwB = byteBuffer;
        this.zzcwB.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzbyc zzah(byte[] byArray) {
        return zzbyc.zzc(byArray, 0, byArray.length);
    }

    public static zzbyc zzc(byte[] byArray, int n, int n2) {
        return new zzbyc(byArray, n, n2);
    }

    public void zza(int n, double d) throws IOException {
        this.zzN(n, 1);
        this.zzn(d);
    }

    public void zzc(int n, float f) throws IOException {
        this.zzN(n, 5);
        this.zzk(f);
    }

    public void zza(int n, long l) throws IOException {
        this.zzN(n, 0);
        this.zzbl(l);
    }

    public void zzb(int n, long l) throws IOException {
        this.zzN(n, 0);
        this.zzbm(l);
    }

    public void zzJ(int n, int n2) throws IOException {
        this.zzN(n, 0);
        this.zzrj(n2);
    }

    public void zzc(int n, long l) throws IOException {
        this.zzN(n, 1);
        this.zzbn(l);
    }

    public void zzg(int n, boolean bl) throws IOException {
        this.zzN(n, 0);
        this.zzbr(bl);
    }

    public void zzq(int n, String string2) throws IOException {
        this.zzN(n, 2);
        this.zzkt(string2);
    }

    public void zza(int n, zzbyj zzbyj2) throws IOException {
        this.zzN(n, 2);
        this.zzc(zzbyj2);
    }

    public void zzb(int n, byte[] byArray) throws IOException {
        this.zzN(n, 2);
        this.zzai(byArray);
    }

    public void zzK(int n, int n2) throws IOException {
        this.zzN(n, 0);
        this.zzrk(n2);
    }

    public void zzd(int n, long l) throws IOException {
        this.zzN(n, 0);
        this.zzbo(l);
    }

    public void zzn(double d) throws IOException {
        this.zzbu(Double.doubleToLongBits(d));
    }

    public void zzk(float f) throws IOException {
        this.zzrr(Float.floatToIntBits(f));
    }

    public void zzbl(long l) throws IOException {
        this.zzbs(l);
    }

    public void zzbm(long l) throws IOException {
        this.zzbs(l);
    }

    public void zzrj(int n) throws IOException {
        if (n >= 0) {
            this.zzrp(n);
        } else {
            this.zzbs(n);
        }
    }

    public void zzbn(long l) throws IOException {
        this.zzbu(l);
    }

    public void zzbr(boolean bl) throws IOException {
        this.zzrn(bl ? 1 : 0);
    }

    public void zzkt(String string2) throws IOException {
        try {
            int n = zzbyc.zzrq(string2.length());
            int n2 = zzbyc.zzrq(string2.length() * 3);
            if (n == n2) {
                int n3 = this.zzcwB.position();
                if (this.zzcwB.remaining() < n) {
                    throw new zza(n3 + n, this.zzcwB.limit());
                }
                this.zzcwB.position(n3 + n);
                zzbyc.zza((CharSequence)string2, this.zzcwB);
                int n4 = this.zzcwB.position();
                this.zzcwB.position(n3);
                this.zzrp(n4 - n3 - n);
                this.zzcwB.position(n4);
            } else {
                this.zzrp(zzbyc.zzb(string2));
                zzbyc.zza((CharSequence)string2, this.zzcwB);
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            zza zza2 = new zza(this.zzcwB.position(), this.zzcwB.limit());
            zza2.initCause(bufferOverflowException);
            throw zza2;
        }
    }

    private static int zzb(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                n3 += zzbyc.zza(charSequence, n);
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static int zza(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
                continue;
            }
            n3 += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int n4 = Character.codePointAt(charSequence, i);
            if (n4 < 65536) {
                int n5 = i;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n5).toString());
            }
            ++i;
        }
        return n3;
    }

    private static void zza(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n = zzbyc.zza(charSequence, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                byteBuffer.position(n - byteBuffer.arrayOffset());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        } else {
            zzbyc.zzb(charSequence, byteBuffer);
        }
    }

    private static void zzb(CharSequence charSequence, ByteBuffer byteBuffer) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            int n2;
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 < '\u0080') {
                byteBuffer.put((byte)c2);
                continue;
            }
            if (c2 < '\u0800') {
                byteBuffer.put((byte)(0x3C0 | c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (c2 < '\ud800' || '\udfff' < c2) {
                byteBuffer.put((byte)(0x1E0 | c2 >>> 12));
                byteBuffer.put((byte)(0x80 | 0x3F & c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (i + 1 == charSequence.length() || !Character.isSurrogatePair(c2, c = charSequence.charAt(++i))) {
                n2 = i - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n2).toString());
            }
            n2 = Character.toCodePoint(c2, c);
            byteBuffer.put((byte)(0xF0 | n2 >>> 18));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 12));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 6));
            byteBuffer.put((byte)(0x80 | 0x3F & n2));
        }
    }

    private static int zza(CharSequence charSequence, byte[] byArray, int n, int n2) {
        char c;
        int n3;
        int n4 = charSequence.length();
        int n5 = n + n2;
        for (n3 = 0; n3 < n4 && n3 + n < n5 && (c = charSequence.charAt(n3)) < '\u0080'; ++n3) {
            byArray[n + n3] = (byte)c;
        }
        if (n3 == n4) {
            return n + n4;
        }
        int n6 = n + n3;
        while (n3 < n4) {
            int n7;
            char c2;
            c = charSequence.charAt(n3);
            if (c < '\u0080' && n6 < n5) {
                byArray[n6++] = (byte)c;
            } else if (c < '\u0800' && n6 <= n5 - 2) {
                byArray[n6++] = (byte)(0x3C0 | c >>> 6);
                byArray[n6++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && n6 <= n5 - 3) {
                byArray[n6++] = (byte)(0x1E0 | c >>> 12);
                byArray[n6++] = (byte)(0x80 | 0x3F & c >>> 6);
                byArray[n6++] = (byte)(0x80 | 0x3F & c);
            } else if (n6 <= n5 - 4) {
                if (n3 + 1 == charSequence.length() || !Character.isSurrogatePair(c, c2 = charSequence.charAt(++n3))) {
                    n7 = n3 - 1;
                    throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                }
                n7 = Character.toCodePoint(c, c2);
                byArray[n6++] = (byte)(0xF0 | n7 >>> 18);
                byArray[n6++] = (byte)(0x80 | 0x3F & n7 >>> 12);
                byArray[n6++] = (byte)(0x80 | 0x3F & n7 >>> 6);
                byArray[n6++] = (byte)(0x80 | 0x3F & n7);
            } else {
                c2 = c;
                n7 = n6;
                throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c2).append(" at index ").append(n7).toString());
            }
            ++n3;
        }
        return n6;
    }

    public void zzb(zzbyj zzbyj2) throws IOException {
        zzbyj2.zza(this);
    }

    public void zzc(zzbyj zzbyj2) throws IOException {
        this.zzrp(zzbyj2.zzafA());
        zzbyj2.zza(this);
    }

    public void zzai(byte[] byArray) throws IOException {
        this.zzrp(byArray.length);
        this.zzak(byArray);
    }

    public void zzrk(int n) throws IOException {
        this.zzrp(zzbyc.zzrs(n));
    }

    public void zzbo(long l) throws IOException {
        this.zzbs(zzbyc.zzbv(l));
    }

    public static int zzb(int n, double d) {
        return zzbyc.zzro(n) + 8;
    }

    public static int zzd(int n, float f) {
        return zzbyc.zzro(n) + 4;
    }

    public static int zze(int n, long l) {
        return zzbyc.zzro(n) + zzbyc.zzbp(l);
    }

    public static int zzf(int n, long l) {
        return zzbyc.zzro(n) + zzbyc.zzbq(l);
    }

    public static int zzL(int n, int n2) {
        return zzbyc.zzro(n) + zzbyc.zzrl(n2);
    }

    public static int zzg(int n, long l) {
        return zzbyc.zzro(n) + 8;
    }

    public static int zzh(int n, boolean bl) {
        return zzbyc.zzro(n) + 1;
    }

    public static int zzr(int n, String string2) {
        return zzbyc.zzro(n) + zzbyc.zzku(string2);
    }

    public static int zzb(int n, zzbyj zzbyj2) {
        return zzbyc.zzro(n) * 2 + zzbyc.zzd(zzbyj2);
    }

    public static int zzc(int n, zzbyj zzbyj2) {
        return zzbyc.zzro(n) + zzbyc.zze(zzbyj2);
    }

    public static int zzc(int n, byte[] byArray) {
        return zzbyc.zzro(n) + zzbyc.zzaj(byArray);
    }

    public static int zzM(int n, int n2) {
        return zzbyc.zzro(n) + zzbyc.zzrm(n2);
    }

    public static int zzh(int n, long l) {
        return zzbyc.zzro(n) + zzbyc.zzbr(l);
    }

    public static int zzbp(long l) {
        return zzbyc.zzbt(l);
    }

    public static int zzbq(long l) {
        return zzbyc.zzbt(l);
    }

    public static int zzrl(int n) {
        if (n >= 0) {
            return zzbyc.zzrq(n);
        }
        return 10;
    }

    public static int zzku(String string2) {
        int n = zzbyc.zzb(string2);
        return zzbyc.zzrq(n) + n;
    }

    public static int zzd(zzbyj zzbyj2) {
        return zzbyj2.zzafB();
    }

    public static int zze(zzbyj zzbyj2) {
        int n = zzbyj2.zzafB();
        return zzbyc.zzrq(n) + n;
    }

    public static int zzaj(byte[] byArray) {
        return zzbyc.zzrq(byArray.length) + byArray.length;
    }

    public static int zzrm(int n) {
        return zzbyc.zzrq(zzbyc.zzrs(n));
    }

    public static int zzbr(long l) {
        return zzbyc.zzbt(zzbyc.zzbv(l));
    }

    public int zzafn() {
        return this.zzcwB.remaining();
    }

    public void zzafo() {
        if (this.zzafn() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public void zzc(byte by) throws IOException {
        if (!this.zzcwB.hasRemaining()) {
            throw new zza(this.zzcwB.position(), this.zzcwB.limit());
        }
        this.zzcwB.put(by);
    }

    public void zzrn(int n) throws IOException {
        this.zzc((byte)n);
    }

    public void zzak(byte[] byArray) throws IOException {
        this.zzd(byArray, 0, byArray.length);
    }

    public void zzd(byte[] byArray, int n, int n2) throws IOException {
        if (this.zzcwB.remaining() < n2) {
            throw new zza(this.zzcwB.position(), this.zzcwB.limit());
        }
        this.zzcwB.put(byArray, n, n2);
    }

    public void zzN(int n, int n2) throws IOException {
        this.zzrp(zzbym.zzO(n, n2));
    }

    public static int zzro(int n) {
        return zzbyc.zzrq(zzbym.zzO(n, 0));
    }

    public void zzrp(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzrn(n);
                return;
            }
            this.zzrn(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzrq(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void zzbs(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzrn((int)l);
                return;
            }
            this.zzrn((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int zzbt(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public void zzrr(int n) throws IOException {
        if (this.zzcwB.remaining() < 4) {
            throw new zza(this.zzcwB.position(), this.zzcwB.limit());
        }
        this.zzcwB.putInt(n);
    }

    public void zzbu(long l) throws IOException {
        if (this.zzcwB.remaining() < 8) {
            throw new zza(this.zzcwB.position(), this.zzcwB.limit());
        }
        this.zzcwB.putLong(l);
    }

    public static int zzrs(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long zzbv(long l) {
        return l << 1 ^ l >> 63;
    }

    public static class zza
    extends IOException {
        zza(int n, int n2) {
            super(new StringBuilder(108).append("CodedOutputStream was writing to a flat byte array and ran out of space (pos ").append(n).append(" limit ").append(n2).append(").").toString());
        }
    }
}

