/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Dialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.MainThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.internal.zzqe;
import com.google.android.gms.internal.zzqj;
import com.google.android.gms.internal.zzqk;

public abstract class zzpn
extends zzqj
implements DialogInterface.OnCancelListener {
    protected boolean mStarted;
    protected boolean sL;
    private ConnectionResult sM;
    private int sN = -1;
    private final Handler sO = new Handler(Looper.getMainLooper());
    protected final GoogleApiAvailability sh;

    protected zzpn(zzqk zzqk2) {
        this(zzqk2, GoogleApiAvailability.getInstance());
    }

    zzpn(zzqk zzqk2, GoogleApiAvailability googleApiAvailability) {
        super(zzqk2);
        this.sh = googleApiAvailability;
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zza(new ConnectionResult(13, null), this.sN);
        this.zzaot();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null) {
            this.sL = bundle.getBoolean("resolving_error", false);
            if (this.sL) {
                this.sN = bundle.getInt("failed_client_id", -1);
                this.sM = new ConnectionResult(bundle.getInt("failed_status"), (PendingIntent)bundle.getParcelable("failed_resolution"));
            }
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("resolving_error", this.sL);
        if (this.sL) {
            bundle.putInt("failed_client_id", this.sN);
            bundle.putInt("failed_status", this.sM.getErrorCode());
            bundle.putParcelable("failed_resolution", (Parcelable)this.sM.getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        this.mStarted = true;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        boolean bl = false;
        switch (n) {
            case 2: {
                int n3 = this.sh.isGooglePlayServicesAvailable((Context)this.getActivity());
                if (n3 == 0) {
                    bl = true;
                }
                if (this.sM.getErrorCode() != 18 || n3 != 18) break;
                return;
            }
            case 1: {
                if (n2 == -1) {
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                int n4 = 13;
                if (intent != null) {
                    n4 = intent.getIntExtra("<<ResolutionFailureErrorDetail>>", 13);
                }
                this.sM = new ConnectionResult(n4, null);
            }
        }
        if (bl) {
            this.zzaot();
        } else {
            this.zza(this.sM, this.sN);
        }
    }

    public void onStop() {
        super.onStop();
        this.mStarted = false;
    }

    protected abstract void zza(ConnectionResult var1, int var2);

    protected abstract void zzaoo();

    protected void zzaot() {
        this.sN = -1;
        this.sL = false;
        this.sM = null;
        this.zzaoo();
    }

    public void zzb(ConnectionResult connectionResult, int n) {
        if (!this.sL) {
            this.sL = true;
            this.sN = n;
            this.sM = connectionResult;
            this.sO.post((Runnable)new zza());
        }
    }

    private class zza
    implements Runnable {
        private zza() {
        }

        @Override
        @MainThread
        public void run() {
            if (!zzpn.this.mStarted) {
                return;
            }
            if (zzpn.this.sM.hasResolution()) {
                zzpn.this.vm.startActivityForResult(GoogleApiActivity.zzb((Context)zzpn.this.getActivity(), zzpn.this.sM.getResolution(), zzpn.this.sN, false), 1);
            } else if (zzpn.this.sh.isUserResolvableError(zzpn.this.sM.getErrorCode())) {
                zzpn.this.sh.zza(zzpn.this.getActivity(), zzpn.this.vm, zzpn.this.sM.getErrorCode(), 2, zzpn.this);
            } else if (zzpn.this.sM.getErrorCode() == 18) {
                final Dialog dialog = zzpn.this.sh.zza(zzpn.this.getActivity(), zzpn.this);
                zzpn.this.sh.zza(zzpn.this.getActivity().getApplicationContext(), new zzqe.zza(){

                    @Override
                    public void zzaou() {
                        zzpn.this.zzaot();
                        if (dialog.isShowing()) {
                            dialog.dismiss();
                        }
                    }
                });
            } else {
                zzpn.this.zza(zzpn.this.sM, zzpn.this.sN);
            }
        }
    }
}

