/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzpo;
import com.google.android.gms.internal.zzqq;
import com.google.android.gms.internal.zzqu;

public final class PendingResults {
    public static PendingResult<Status> immediatePendingResult(Status status) {
        zzab.zzb((Object)status, (Object)"Result must not be null");
        zzqu zzqu2 = new zzqu(Looper.getMainLooper());
        zzqu2.zzc(status);
        return zzqu2;
    }

    public static PendingResult<Status> zza(Status status, GoogleApiClient googleApiClient) {
        zzab.zzb((Object)status, (Object)"Result must not be null");
        zzqu zzqu2 = new zzqu(googleApiClient);
        zzqu2.zzc(status);
        return zzqu2;
    }

    public static <R extends Result> PendingResult<R> zza(R r, GoogleApiClient googleApiClient) {
        zzab.zzb(r, (Object)"Result must not be null");
        zzab.zzb((!r.getStatus().isSuccess() ? 1 : 0) != 0, (Object)"Status code must not be SUCCESS");
        zzb<R> zzb2 = new zzb<R>(googleApiClient, r);
        zzb2.zzc(r);
        return zzb2;
    }

    public static <R extends Result> OptionalPendingResult<R> immediatePendingResult(R r) {
        zzab.zzb(r, (Object)"Result must not be null");
        zzc<R> zzc2 = new zzc<R>(null);
        zzc2.zzc(r);
        return new zzqq(zzc2);
    }

    public static <R extends Result> OptionalPendingResult<R> zzb(R r, GoogleApiClient googleApiClient) {
        zzab.zzb(r, (Object)"Result must not be null");
        zzc<R> zzc2 = new zzc<R>(googleApiClient);
        zzc2.zzc(r);
        return new zzqq(zzc2);
    }

    public static PendingResult<Status> canceledPendingResult() {
        zzqu zzqu2 = new zzqu(Looper.getMainLooper());
        zzqu2.cancel();
        return zzqu2;
    }

    public static <R extends Result> PendingResult<R> canceledPendingResult(R r) {
        zzab.zzb(r, (Object)"Result must not be null");
        zzab.zzb((r.getStatus().getStatusCode() == 16 ? 1 : 0) != 0, (Object)"Status code must be CommonStatusCodes.CANCELED");
        zza<R> zza2 = new zza<R>(r);
        zza2.cancel();
        return zza2;
    }

    private PendingResults() {
    }

    private static final class zza<R extends Result>
    extends zzpo<R> {
        private final R sl;

        public zza(R r) {
            super(Looper.getMainLooper());
            this.sl = r;
        }

        @Override
        protected R zzc(Status status) {
            if (status.getStatusCode() != this.sl.getStatus().getStatusCode()) {
                throw new UnsupportedOperationException("Creating failed results is not supported");
            }
            return this.sl;
        }
    }

    private static final class zzb<R extends Result>
    extends zzpo<R> {
        private final R sm;

        public zzb(GoogleApiClient googleApiClient, R r) {
            super(googleApiClient);
            this.sm = r;
        }

        @Override
        protected R zzc(Status status) {
            return this.sm;
        }
    }

    private static final class zzc<R extends Result>
    extends zzpo<R> {
        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        @Override
        protected R zzc(Status status) {
            throw new UnsupportedOperationException("Creating failed results is not supported");
        }
    }
}

