/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.app.Fragment;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import com.google.android.gms.R;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.common.zze;

public final class GooglePlayServicesUtil
extends zze {
    public static final String GMS_ERROR_DIALOG = "GooglePlayServicesErrorDialog";
    @Deprecated
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = zze.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    @Deprecated
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    public static final String GOOGLE_PLAY_STORE_PACKAGE = "com.android.vending";

    private GooglePlayServicesUtil() {
    }

    @Deprecated
    public static Dialog getErrorDialog(int n, Activity activity, int n2) {
        return GooglePlayServicesUtil.getErrorDialog(n, activity, n2, null);
    }

    @Deprecated
    public static Dialog getErrorDialog(int n, Activity activity, int n2, DialogInterface.OnCancelListener onCancelListener) {
        if (GooglePlayServicesUtil.zzc((Context)activity, n)) {
            n = 18;
        }
        return GoogleApiAvailability.getInstance().getErrorDialog(activity, n, n2, onCancelListener);
    }

    @Deprecated
    public static boolean showErrorDialogFragment(int n, Activity activity, int n2, DialogInterface.OnCancelListener onCancelListener) {
        return GooglePlayServicesUtil.showErrorDialogFragment(n, activity, null, n2, onCancelListener);
    }

    public static boolean showErrorDialogFragment(int n, Activity activity, Fragment fragment, int n2, DialogInterface.OnCancelListener onCancelListener) {
        if (GooglePlayServicesUtil.zzc((Context)activity, n)) {
            n = 18;
        }
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        if (fragment == null) {
            return googleApiAvailability.showErrorDialogFragment(activity, n, n2, onCancelListener);
        }
        Intent intent = GoogleApiAvailability.getInstance().zza((Context)activity, n, "d");
        Dialog dialog = googleApiAvailability.zza((Context)activity, n, com.google.android.gms.common.internal.zzi.zza(fragment, intent, n2), onCancelListener);
        if (dialog == null) {
            return false;
        }
        googleApiAvailability.zza(activity, dialog, GMS_ERROR_DIALOG, onCancelListener);
        return true;
    }

    @Deprecated
    public static void showErrorNotification(int n, Context context) {
        if (zzi.zzck((Context)context) && n == 2) {
            n = 42;
        }
        if (GooglePlayServicesUtil.zzc(context, n) || GooglePlayServicesUtil.zzd(context, n)) {
            GooglePlayServicesUtil.zzbr(context);
        } else {
            GooglePlayServicesUtil.zza(n, context);
        }
    }

    static void zza(int n, Context context, PendingIntent pendingIntent) {
        GooglePlayServicesUtil.zza(n, context, null, pendingIntent);
    }

    private static void zzbr(Context context) {
        zza zza2 = new zza(context);
        zza2.sendMessageDelayed(zza2.obtainMessage(1), 120000L);
    }

    private static void zza(int n, Context context) {
        GooglePlayServicesUtil.zza(n, context, null);
    }

    private static void zza(int n, Context context, String string2) {
        PendingIntent pendingIntent = GoogleApiAvailability.getInstance().zza(context, n, 0, "n");
        GooglePlayServicesUtil.zza(n, context, string2, pendingIntent);
    }

    @TargetApi(value=20)
    private static void zza(int n, Context context, String string2, PendingIntent pendingIntent) {
        int n2;
        Notification notification;
        String string3;
        String string4;
        Resources resources = context.getResources();
        String string5 = GooglePlayServicesUtil.zzbv((Context)context);
        String string6 = zzh.zzg(context, n);
        if (string6 == null) {
            string6 = resources.getString(R.string.common_google_play_services_notification_ticker);
        }
        String string7 = zzh.zzd(context, n, string5);
        if (zzi.zzck((Context)context)) {
            zzab.zzbn((boolean)zzs.zzavr());
            string4 = string6;
            string3 = new Notification.Builder(context).setSmallIcon(R.drawable.common_ic_googleplayservices).setPriority(2).setAutoCancel(true).setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string7).length()).append(string4).append(" ").append(string7).toString())).addAction(R.drawable.common_full_open_on_phone, (CharSequence)resources.getString(R.string.common_open_on_phone), pendingIntent);
            notification = string3.build();
        } else {
            string3 = resources.getString(R.string.common_google_play_services_notification_ticker);
            if (zzs.zzavn()) {
                string4 = new Notification.Builder(context).setSmallIcon(17301642).setContentTitle((CharSequence)string6).setContentText((CharSequence)string7).setContentIntent(pendingIntent).setTicker((CharSequence)string3).setAutoCancel(true);
                if (zzs.zzavv()) {
                    string4.setLocalOnly(true);
                }
                if (zzs.zzavr()) {
                    string4.setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)string7));
                    notification = string4.build();
                } else {
                    notification = string4.getNotification();
                }
                if (Build.VERSION.SDK_INT == 19) {
                    notification.extras.putBoolean("android.support.localOnly", true);
                }
            } else {
                string4 = new NotificationCompat.Builder(context).setSmallIcon(17301642).setTicker((CharSequence)string3).setWhen(System.currentTimeMillis()).setAutoCancel(true).setContentIntent(pendingIntent).setContentTitle((CharSequence)string6).setContentText((CharSequence)string7);
                notification = string4.build();
            }
        }
        if (GooglePlayServicesUtil.zzfe((int)n)) {
            n2 = 10436;
            rv.set(false);
        } else {
            n2 = 39789;
        }
        string4 = (NotificationManager)context.getSystemService("notification");
        if (string2 != null) {
            string4.notify(string2, n2, notification);
        } else {
            string4.notify(n2, notification);
        }
    }

    @Deprecated
    public static boolean showErrorDialogFragment(int n, Activity activity, int n2) {
        return GooglePlayServicesUtil.showErrorDialogFragment(n, activity, n2, null);
    }

    @Deprecated
    public static String getErrorString(int n) {
        return zze.getErrorString((int)n);
    }

    @Deprecated
    public static int isGooglePlayServicesAvailable(Context context) {
        return zze.isGooglePlayServicesAvailable((Context)context);
    }

    @Deprecated
    public static Intent zzfd(int n) {
        return zze.zzfd((int)n);
    }

    @Deprecated
    public static PendingIntent getErrorPendingIntent(int n, Context context, int n2) {
        return zze.getErrorPendingIntent((int)n, (Context)context, (int)n2);
    }

    @Deprecated
    public static boolean isUserRecoverableError(int n) {
        return zze.isUserRecoverableError((int)n);
    }

    @Deprecated
    public static String getOpenSourceSoftwareLicenseInfo(Context context) {
        return zze.getOpenSourceSoftwareLicenseInfo((Context)context);
    }

    public static Resources getRemoteResource(Context context) {
        return zze.getRemoteResource((Context)context);
    }

    public static Context getRemoteContext(Context context) {
        return zze.getRemoteContext((Context)context);
    }

    @Deprecated
    public static boolean zzc(Context context, int n) {
        return zze.zzc((Context)context, (int)n);
    }

    @Deprecated
    public static boolean zzd(Context context, int n) {
        return zze.zzd((Context)context, (int)n);
    }

    private static class zza
    extends Handler {
        private final Context zzaql;

        zza(Context context) {
            super(Looper.myLooper() == null ? Looper.getMainLooper() : Looper.myLooper());
            this.zzaql = context.getApplicationContext();
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.zzaql);
                    if (!GooglePlayServicesUtil.isUserRecoverableError(n)) break;
                    GooglePlayServicesUtil.zza(n, this.zzaql);
                    break;
                }
                default: {
                    int n = message.what;
                    Log.w((String)"GooglePlayServicesUtil", (String)new StringBuilder(50).append("Don't know how to handle this message: ").append(n).toString());
                }
            }
        }
    }
}

