/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.widget.ProgressBar;
import com.google.android.gms.R;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.ErrorDialogFragment;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.SupportErrorDialogFragment;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzqe;
import com.google.android.gms.internal.zzqk;
import com.google.android.gms.internal.zzqp;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;

public class GoogleApiAvailability
extends zzc {
    private static final GoogleApiAvailability re = new GoogleApiAvailability();
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = zzc.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";

    public static GoogleApiAvailability getInstance() {
        return re;
    }

    GoogleApiAvailability() {
    }

    @MainThread
    public Task<Void> makeGooglePlayServicesAvailable(Activity activity) {
        zzab.zzhi((String)"makeGooglePlayServicesAvailable must be called from the main thread");
        int n = this.isGooglePlayServicesAvailable((Context)activity);
        if (n == 0) {
            return Tasks.forResult(null);
        }
        zzqp zzqp2 = zzqp.zzu(activity);
        zzqp2.zzk(new ConnectionResult(n, null));
        return zzqp2.getTask();
    }

    public Dialog getErrorDialog(Activity activity, int n, int n2) {
        return this.getErrorDialog(activity, n, n2, null);
    }

    public Dialog getErrorDialog(Activity activity, int n, int n2, DialogInterface.OnCancelListener onCancelListener) {
        Intent intent = this.zza((Context)activity, n, "d");
        return this.zza((Context)activity, n, zzi.zza(activity, intent, n2), onCancelListener);
    }

    public boolean showErrorDialogFragment(Activity activity, int n, int n2) {
        return this.showErrorDialogFragment(activity, n, n2, null);
    }

    public boolean zza(Activity activity, @NonNull zzqk zzqk2, int n, int n2, DialogInterface.OnCancelListener onCancelListener) {
        Intent intent = this.zza((Context)activity, n, "d");
        Dialog dialog = this.zza((Context)activity, n, zzi.zza(zzqk2, intent, n2), onCancelListener);
        if (dialog == null) {
            return false;
        }
        this.zza(activity, dialog, "GooglePlayServicesErrorDialog", onCancelListener);
        return true;
    }

    public boolean showErrorDialogFragment(Activity activity, int n, int n2, DialogInterface.OnCancelListener onCancelListener) {
        Dialog dialog = this.getErrorDialog(activity, n, n2, onCancelListener);
        if (dialog == null) {
            return false;
        }
        this.zza(activity, dialog, "GooglePlayServicesErrorDialog", onCancelListener);
        return true;
    }

    public void showErrorNotification(Context context, int n) {
        if (n == 6) {
            Log.e((String)"GoogleApiAvailability", (String)"showErrorNotification(context, errorCode) is called for RESOLUTION_REQUIRED when showErrorNotification(context, result) should be called");
        }
        if (this.isUserResolvableError(n)) {
            GooglePlayServicesUtil.showErrorNotification(n, context);
        }
    }

    public void showErrorNotification(Context context, ConnectionResult connectionResult) {
        PendingIntent pendingIntent = this.getErrorResolutionPendingIntent(context, connectionResult);
        if (pendingIntent != null) {
            GooglePlayServicesUtil.zza(connectionResult.getErrorCode(), context, pendingIntent);
        }
    }

    public void zza(Context context, ConnectionResult connectionResult, int n) {
        PendingIntent pendingIntent = this.getErrorResolutionPendingIntent(context, connectionResult);
        if (pendingIntent != null) {
            GooglePlayServicesUtil.zza(connectionResult.getErrorCode(), context, GoogleApiActivity.zza(context, pendingIntent, n));
        }
    }

    public Dialog zza(Activity activity, DialogInterface.OnCancelListener onCancelListener) {
        ProgressBar progressBar = new ProgressBar((Context)activity, null, 16842874);
        progressBar.setIndeterminate(true);
        progressBar.setVisibility(0);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setView((View)progressBar);
        String string2 = GooglePlayServicesUtil.zzbv((Context)activity);
        builder.setMessage((CharSequence)activity.getResources().getString(R.string.common_google_play_services_updating_text, new Object[]{string2}));
        builder.setTitle(R.string.common_google_play_services_updating_title);
        builder.setPositiveButton((CharSequence)"", null);
        AlertDialog alertDialog = builder.create();
        this.zza(activity, (Dialog)alertDialog, "GooglePlayServicesUpdatingDialog", onCancelListener);
        return alertDialog;
    }

    @Nullable
    public zzqe zza(Context context, zzqe.zza zza2) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
        intentFilter.addDataScheme("package");
        zzqe zzqe2 = new zzqe(zza2);
        context.registerReceiver((BroadcastReceiver)zzqe2, intentFilter);
        zzqe2.setContext(context);
        if (!this.zzl(context, GOOGLE_PLAY_SERVICES_PACKAGE)) {
            zza2.zzaou();
            zzqe2.unregister();
            return null;
        }
        return zzqe2;
    }

    public int isGooglePlayServicesAvailable(Context context) {
        return super.isGooglePlayServicesAvailable(context);
    }

    public final boolean isUserResolvableError(int n) {
        return super.isUserResolvableError(n);
    }

    @Deprecated
    @Nullable
    public Intent zzfc(int n) {
        return super.zzfc(n);
    }

    @Nullable
    public Intent zza(Context context, int n, @Nullable String string2) {
        return super.zza(context, n, string2);
    }

    @Nullable
    public PendingIntent getErrorResolutionPendingIntent(Context context, int n, int n2) {
        return super.getErrorResolutionPendingIntent(context, n, n2);
    }

    @Nullable
    public PendingIntent getErrorResolutionPendingIntent(Context context, ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            return connectionResult.getResolution();
        }
        int n = connectionResult.getErrorCode();
        if (com.google.android.gms.common.util.zzi.zzck((Context)context) && n == 2) {
            n = 42;
        }
        return this.getErrorResolutionPendingIntent(context, n, 0);
    }

    @Nullable
    public PendingIntent zza(Context context, int n, int n2, @Nullable String string2) {
        return super.zza(context, n, n2, string2);
    }

    @Nullable
    public String getOpenSourceSoftwareLicenseInfo(Context context) {
        return super.getOpenSourceSoftwareLicenseInfo(context);
    }

    public int zzbn(Context context) {
        return super.zzbn(context);
    }

    public boolean zzc(Context context, int n) {
        return super.zzc(context, n);
    }

    public final String getErrorString(int n) {
        return super.getErrorString(n);
    }

    @TargetApi(value=14)
    Dialog zza(Context context, int n, zzi zzi2, DialogInterface.OnCancelListener onCancelListener) {
        String string2;
        String string3;
        Object object;
        if (n == 0) {
            return null;
        }
        if (com.google.android.gms.common.util.zzi.zzck((Context)context) && n == 2) {
            n = 42;
        }
        AlertDialog.Builder builder = null;
        if (zzs.zzavq()) {
            object = new TypedValue();
            context.getTheme().resolveAttribute(16843529, object, true);
            string3 = context.getResources().getResourceEntryName(object.resourceId);
            if ("Theme.Dialog.Alert".equals(string3)) {
                builder = new AlertDialog.Builder(context, 5);
            }
        }
        if (builder == null) {
            builder = new AlertDialog.Builder(context);
        }
        object = zze.zzbv((Context)context);
        builder.setMessage((CharSequence)zzh.zzc(context, n, (String)object));
        if (onCancelListener != null) {
            builder.setOnCancelListener(onCancelListener);
        }
        if ((string3 = zzh.zzh(context, n)) != null) {
            builder.setPositiveButton((CharSequence)string3, (DialogInterface.OnClickListener)zzi2);
        }
        if ((string2 = zzh.zzf(context, n)) != null) {
            builder.setTitle((CharSequence)string2);
        }
        return builder.create();
    }

    @TargetApi(value=11)
    void zza(Activity activity, Dialog dialog, String string2, DialogInterface.OnCancelListener onCancelListener) {
        boolean bl;
        try {
            bl = activity instanceof FragmentActivity;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            bl = false;
        }
        if (bl) {
            FragmentManager fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            SupportErrorDialogFragment supportErrorDialogFragment = SupportErrorDialogFragment.newInstance(dialog, onCancelListener);
            supportErrorDialogFragment.show(fragmentManager, string2);
        } else if (zzs.zzavn()) {
            android.app.FragmentManager fragmentManager = activity.getFragmentManager();
            ErrorDialogFragment errorDialogFragment = ErrorDialogFragment.newInstance(dialog, onCancelListener);
            errorDialogFragment.show(fragmentManager, string2);
        } else {
            throw new RuntimeException("This Activity does not support Fragments.");
        }
    }
}

