/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.auth.api.signin.internal.zzk;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.internal.zznr;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zznw;
import com.google.android.gms.internal.zznx;
import com.google.android.gms.internal.zzoh;
import com.google.android.gms.internal.zzol;
import com.google.android.gms.internal.zzoo;
import com.google.android.gms.internal.zzop;
import com.google.android.gms.internal.zzou;
import com.google.android.gms.internal.zzov;
import com.google.android.gms.internal.zzpa;
import com.google.android.gms.internal.zzpb;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzpf;
import com.google.android.gms.internal.zzpl;
import com.google.android.gms.internal.zztv;
import com.google.android.gms.internal.zztw;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public final class zzof
extends GoogleApiClient
implements zzoo.zza {
    private final Lock zzamw;
    private final zzl zzanf;
    private zzoo zzang = null;
    private final int zzall;
    private final Context mContext;
    private final Looper zzakW;
    final Queue<zznt.zza<?, ?>> zzanh = new LinkedList();
    private volatile boolean zzani;
    private long zzanj = 120000L;
    private long zzank = 5000L;
    private final zza zzanl;
    private final GoogleApiAvailability zzaln;
    zzol zzanm;
    final Map<Api.zzc<?>, Api.zze> zzann;
    Set<Scope> zzano = new HashSet<Scope>();
    final zzg zzamS;
    final Map<Api<?>, Integer> zzamT;
    final Api.zza<? extends zztv, zztw> zzalo;
    private final zzov zzanp = new zzov();
    private final ArrayList<zznw> zzanq;
    private Integer zzanr = null;
    Set<zzpe> zzans = null;
    final zzpf zzant;
    private final zzl.zza zzanu = new zzl.zza(){

        @Override
        public boolean isConnected() {
            return zzof.this.isConnected();
        }

        @Override
        public Bundle zzqr() {
            return null;
        }
    };

    public zzof(Context context, Lock lock, Looper looper, zzg zzg2, GoogleApiAvailability googleApiAvailability, Api.zza<? extends zztv, zztw> zza2, Map<Api<?>, Integer> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.zzc<?>, Api.zze> map2, int n, int n2, ArrayList<zznw> arrayList) {
        this.mContext = context;
        this.zzamw = lock;
        this.zzanf = new zzl(looper, this.zzanu);
        this.zzakW = looper;
        this.zzanl = new zza(looper);
        this.zzaln = googleApiAvailability;
        this.zzall = n;
        if (this.zzall >= 0) {
            this.zzanr = n2;
        }
        this.zzamT = map;
        this.zzann = map2;
        this.zzanq = arrayList;
        this.zzant = new zzpf(this.zzann);
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.zzanf.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.zzanf.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.zzamS = zzg2;
        this.zzalo = zza2;
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zznt.zza<R, A>> T zzc(@NonNull T t) {
        zzaa.zzb((t.zzre() != null ? 1 : 0) != 0, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        String string2 = t.zzrl() != null ? t.zzrl().getName() : "the API";
        zzaa.zzb((boolean)this.zzann.containsKey(t.zzre()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.zzamw.lock();
        try {
            if (this.zzang == null) {
                this.zzanh.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.zzang.zzc(t);
            return (T)string2;
        }
        finally {
            this.zzamw.unlock();
        }
    }

    @Override
    public <A extends Api.zzb, T extends zznt.zza<? extends Result, A>> T zzd(@NonNull T t) {
        zzaa.zzb((t.zzre() != null ? 1 : 0) != 0, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        Object object = t.zzrl() != null ? t.zzrl().getName() : "the API";
        zzaa.zzb((boolean)this.zzann.containsKey(t.zzre()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.zzamw.lock();
        try {
            if (this.zzang == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.zzsf()) {
                this.zzanh.add(t);
                while (!this.zzanh.isEmpty()) {
                    object = this.zzanh.remove();
                    this.zzant.zzg(object);
                    ((zznt.zza)object).zzx(Status.zzaly);
                }
                object = t;
                return (T)object;
            }
            object = this.zzang.zzd(t);
            return (T)object;
        }
        finally {
            this.zzamw.unlock();
        }
    }

    @Override
    public <L> zzou<L> zzs(@NonNull L l) {
        this.zzamw.lock();
        try {
            zzou<L> zzou2 = this.zzanp.zza(l, this.zzakW);
            return zzou2;
        }
        finally {
            this.zzamw.unlock();
        }
    }

    @Override
    @NonNull
    public <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        Api.zze zze2 = this.zzann.get(zzc2);
        zzaa.zzb((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    <C extends Api.zze> C zzb(Api.zzc<?> zzc2) {
        Api.zze zze2 = this.zzann.get(zzc2);
        zzaa.zzb((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    @Override
    public boolean zza(@NonNull Api<?> api) {
        return this.zzann.containsKey(api.zzre());
    }

    @Override
    public boolean hasConnectedApi(@NonNull Api<?> api) {
        Api.zze zze2 = this.zzann.get(api.zzre());
        return zze2 != null && zze2.isConnected();
    }

    @Override
    @NonNull
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        this.zzamw.lock();
        try {
            if (!this.isConnected() && !this.zzsf()) {
                throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
            }
            if (this.zzann.containsKey(api.zzre())) {
                ConnectionResult connectionResult = this.zzang.getConnectionResult(api);
                if (connectionResult == null) {
                    if (this.zzsf()) {
                        ConnectionResult connectionResult2 = ConnectionResult.zzakj;
                        return connectionResult2;
                    }
                    Log.i((String)"GoogleApiClientImpl", (String)this.zzsl());
                    Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.getName()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                    ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                    return connectionResult3;
                }
                ConnectionResult connectionResult4 = connectionResult;
                return connectionResult4;
            }
            throw new IllegalArgumentException(String.valueOf(api.getName()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.zzamw.unlock();
        }
    }

    @Override
    public void connect() {
        this.zzamw.lock();
        try {
            if (this.zzall >= 0) {
                zzaa.zza((this.zzanr != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzanr == null) {
                this.zzanr = zzof.zza(this.zzann.values(), false);
            } else if (this.zzanr == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.connect(this.zzanr);
        }
        finally {
            this.zzamw.unlock();
        }
    }

    @Override
    public void connect(int n) {
        this.zzamw.lock();
        try {
            zzaa.zzb((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zzbJ(n);
            this.zzsg();
        }
        finally {
            this.zzamw.unlock();
        }
    }

    @Override
    public ConnectionResult blockingConnect() {
        zzaa.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.zzamw.lock();
        try {
            if (this.zzall >= 0) {
                zzaa.zza((this.zzanr != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzanr == null) {
                this.zzanr = zzof.zza(this.zzann.values(), false);
            } else if (this.zzanr == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzbJ(this.zzanr);
            this.zzanf.zztJ();
            ConnectionResult connectionResult = this.zzang.blockingConnect();
            return connectionResult;
        }
        finally {
            this.zzamw.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        zzaa.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        zzaa.zzb((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.zzamw.lock();
        try {
            if (this.zzanr == null) {
                this.zzanr = zzof.zza(this.zzann.values(), false);
            } else if (this.zzanr == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzbJ(this.zzanr);
            this.zzanf.zztJ();
            ConnectionResult connectionResult = this.zzang.blockingConnect(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.zzamw.unlock();
        }
    }

    @Override
    public void disconnect() {
        this.zzamw.lock();
        try {
            this.zzant.release();
            if (this.zzang != null) {
                this.zzang.disconnect();
            }
            this.zzanp.release();
            for (zznt.zza zza2 : this.zzanh) {
                zza2.zza((zzpf.zzb)null);
                zza2.cancel();
            }
            this.zzanh.clear();
            if (this.zzang == null) {
                return;
            }
            this.zzsj();
            this.zzanf.zztI();
        }
        finally {
            this.zzamw.unlock();
        }
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    @Override
    public PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzaa.zza((boolean)this.isConnected(), (Object)"GoogleApiClient is not connected yet.");
        zzaa.zza((this.zzanr != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        final zzpb zzpb2 = new zzpb(this);
        if (this.zzann.containsKey(zzpl.zzaaz)) {
            this.zza(this, zzpb2, false);
        } else {
            final AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

                @Override
                public void onConnected(Bundle bundle) {
                    zzof.this.zza((GoogleApiClient)atomicReference.get(), zzpb2, true);
                }

                @Override
                public void onConnectionSuspended(int n) {
                }
            };
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

                @Override
                public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
                    zzpb2.zzb(new Status(8));
                }
            };
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzpl.API).addConnectionCallbacks(connectionCallbacks).addOnConnectionFailedListener(onConnectionFailedListener).setHandler(this.zzanl).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzpb2;
    }

    private void zza(final GoogleApiClient googleApiClient, final zzpb zzpb2, final boolean bl) {
        zzpl.zzasx.zzf(googleApiClient).setResultCallback(new ResultCallback<Status>(){

            public void zzo(@NonNull Status status) {
                zzk.zzab(zzof.this.mContext).zzpE();
                if (status.isSuccess() && zzof.this.isConnected()) {
                    zzof.this.reconnect();
                }
                zzpb2.zzb(status);
                if (bl) {
                    googleApiClient.disconnect();
                }
            }

            public /* synthetic */ void onResult(@NonNull Result result) {
                this.zzo((Status)result);
            }
        });
    }

    @Override
    public void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        this.zzb(new zzop((Activity)fragmentActivity));
    }

    private void zzb(@NonNull zzop zzop2) {
        if (this.zzall < 0) {
            throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
        }
        zznr.zza(zzop2).zzbG(this.zzall);
    }

    @Override
    public boolean isConnected() {
        return this.zzang != null && this.zzang.isConnected();
    }

    @Override
    public boolean isConnecting() {
        return this.zzang != null && this.zzang.isConnecting();
    }

    boolean zzsf() {
        return this.zzani;
    }

    private void zzbJ(int n) {
        if (this.zzanr == null) {
            this.zzanr = n;
        } else if (this.zzanr != n) {
            String string2 = String.valueOf(zzof.zzbK(n));
            String string3 = String.valueOf(zzof.zzbK(this.zzanr));
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.zzang != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.zze zze2 : this.zzann.values()) {
            if (zze2.zzpd()) {
                bl = true;
            }
            if (!zze2.zzps()) continue;
            bl2 = true;
        }
        switch (this.zzanr) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                this.zzang = zznx.zza(this.mContext, this, this.zzamw, this.zzakW, this.zzaln, this.zzann, this.zzamS, this.zzamT, this.zzalo, this.zzanq);
                return;
            }
        }
        this.zzang = new zzoh(this.mContext, this, this.zzamw, this.zzakW, this.zzaln, this.zzann, this.zzamS, this.zzamT, this.zzalo, this.zzanq, this);
    }

    private void zzsg() {
        this.zzanf.zztJ();
        this.zzang.connect();
    }

    private void resume() {
        this.zzamw.lock();
        try {
            if (this.zzsf()) {
                this.zzsg();
            }
        }
        finally {
            this.zzamw.unlock();
        }
    }

    private void zzsh() {
        this.zzamw.lock();
        try {
            boolean bl = this.zzsj();
            if (bl) {
                this.zzsg();
            }
        }
        finally {
            this.zzamw.unlock();
        }
    }

    void zzsi() {
        if (this.zzsf()) {
            return;
        }
        this.zzani = true;
        if (this.zzanm == null) {
            this.zzanm = this.zzaln.zza(this.mContext.getApplicationContext(), new zzb(this));
        }
        this.zzanl.sendMessageDelayed(this.zzanl.obtainMessage(1), this.zzanj);
        this.zzanl.sendMessageDelayed(this.zzanl.obtainMessage(2), this.zzank);
    }

    boolean zzsj() {
        if (!this.zzsf()) {
            return false;
        }
        this.zzani = false;
        this.zzanl.removeMessages(2);
        this.zzanl.removeMessages(1);
        if (this.zzanm != null) {
            this.zzanm.unregister();
            this.zzanm = null;
        }
        return true;
    }

    @Override
    public void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzanf.registerConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zzanf.isConnectionCallbacksRegistered(connectionCallbacks);
    }

    @Override
    public void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzanf.unregisterConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzanf.registerConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zzanf.isConnectionFailedListenerRegistered(onConnectionFailedListener);
    }

    @Override
    public void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzanf.unregisterConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public void zzk(Bundle bundle) {
        while (!this.zzanh.isEmpty()) {
            this.zzd(this.zzanh.remove());
        }
        this.zzanf.zzm(bundle);
    }

    @Override
    public void zzd(ConnectionResult connectionResult) {
        if (!this.zzaln.zzc(this.mContext, connectionResult.getErrorCode())) {
            this.zzsj();
        }
        if (!this.zzsf()) {
            this.zzanf.zzm(connectionResult);
            this.zzanf.zztI();
        }
    }

    @Override
    public void zzc(int n, boolean bl) {
        if (n == 1 && !bl) {
            this.zzsi();
        }
        this.zzant.zzsL();
        this.zzanf.zzcc(n);
        this.zzanf.zztI();
        if (n == 2) {
            this.zzsg();
        }
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public Looper getLooper() {
        return this.zzakW;
    }

    @Override
    public boolean zza(zzpa zzpa2) {
        return this.zzang != null && this.zzang.zza(zzpa2);
    }

    @Override
    public void zzrr() {
        if (this.zzang != null) {
            this.zzang.zzrr();
        }
    }

    @Override
    public void zza(zzpe zzpe2) {
        this.zzamw.lock();
        try {
            if (this.zzans == null) {
                this.zzans = new HashSet<zzpe>();
            }
            this.zzans.add(zzpe2);
        }
        finally {
            this.zzamw.unlock();
        }
    }

    @Override
    public void zzb(zzpe zzpe2) {
        this.zzamw.lock();
        try {
            if (this.zzans == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.zzans.remove(zzpe2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zzsk()) {
                this.zzang.zzrN();
            }
        }
        finally {
            this.zzamw.unlock();
        }
    }

    boolean zzsk() {
        this.zzamw.lock();
        try {
            if (this.zzans == null) {
                boolean bl = false;
                return false;
            }
            boolean bl = !this.zzans.isEmpty();
            return bl;
        }
        finally {
            this.zzamw.unlock();
        }
    }

    String zzsl() {
        StringWriter stringWriter = new StringWriter();
        this.dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.mContext);
        printWriter.append(string2).append("mResuming=").print(this.zzani);
        printWriter.append(" mWorkQueue.size()=").print(this.zzanh.size());
        this.zzant.dump(printWriter);
        if (this.zzang != null) {
            this.zzang.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public int getSessionId() {
        return System.identityHashCode(this);
    }

    public static int zza(Iterable<Api.zze> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.zze zze2 : iterable) {
            if (zze2.zzpd()) {
                bl2 = true;
            }
            if (!zze2.zzps()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    static String zzbK(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    final class zza
    extends Handler {
        zza(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    zzof.this.zzsh();
                    break;
                }
                case 2: {
                    zzof.this.resume();
                    break;
                }
                default: {
                    int n = message.what;
                    Log.w((String)"GoogleApiClientImpl", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                }
            }
        }
    }

    static class zzb
    extends zzol.zza {
        private WeakReference<zzof> zzanz;

        zzb(zzof zzof2) {
            this.zzanz = new WeakReference<zzof>(zzof2);
        }

        @Override
        public void zzrG() {
            zzof zzof2 = (zzof)this.zzanz.get();
            if (zzof2 == null) {
                return;
            }
            zzof2.resume();
        }
    }
}

