/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import com.google.android.gms.common.api.BatchResult;
import com.google.android.gms.common.api.BatchResultToken;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zznv;
import java.util.ArrayList;
import java.util.List;

public final class Batch
extends zznv<BatchResult> {
    private int zzakL;
    private boolean zzakM;
    private boolean zzakN;
    private final PendingResult<?>[] zzakO;
    private final Object zzpp = new Object();

    private Batch(List<PendingResult<?>> list, GoogleApiClient googleApiClient) {
        super(googleApiClient);
        this.zzakL = list.size();
        this.zzakO = new PendingResult[this.zzakL];
        if (list.isEmpty()) {
            this.zzb(new BatchResult(Status.zzalw, this.zzakO));
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            PendingResult<?> pendingResult = list.get(i);
            this.zzakO[i] = pendingResult;
            pendingResult.zza(new PendingResult.zza(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void zzt(Status status) {
                    Object object = Batch.this.zzpp;
                    synchronized (object) {
                        if (Batch.this.isCanceled()) {
                            return;
                        }
                        if (status.isCanceled()) {
                            Batch.this.zzakN = true;
                        } else if (!status.isSuccess()) {
                            Batch.this.zzakM = true;
                        }
                        Batch.this.zzakL--;
                        if (Batch.this.zzakL == 0) {
                            if (Batch.this.zzakN) {
                                Batch.super.cancel();
                            } else {
                                Status status2 = Batch.this.zzakM ? new Status(13) : Status.zzalw;
                                Batch.this.zzb(new BatchResult(status2, Batch.this.zzakO));
                            }
                        }
                    }
                }
            });
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        for (PendingResult<?> pendingResult : this.zzakO) {
            pendingResult.cancel();
        }
    }

    public BatchResult createFailedResult(Status status) {
        return new BatchResult(status, this.zzakO);
    }

    @Override
    public /* synthetic */ Result zzc(Status status) {
        return this.createFailedResult(status);
    }

    public static final class Builder {
        private List<PendingResult<?>> zzakQ = new ArrayList();
        private GoogleApiClient zzaeN;

        public Builder(GoogleApiClient googleApiClient) {
            this.zzaeN = googleApiClient;
        }

        public <R extends Result> BatchResultToken<R> add(PendingResult<R> pendingResult) {
            BatchResultToken batchResultToken = new BatchResultToken(this.zzakQ.size());
            this.zzakQ.add(pendingResult);
            return batchResultToken;
        }

        public Batch build() {
            return new Batch(this.zzakQ, this.zzaeN);
        }
    }
}

