/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.BinderThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zzog;
import com.google.android.gms.internal.zzoh;
import com.google.android.gms.internal.zzoi;
import com.google.android.gms.internal.zztv;
import com.google.android.gms.internal.zztw;
import com.google.android.gms.signin.internal.SignInResponse;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;

public class zzod
implements zzog {
    private final zzoh zzamB;
    private final Lock zzamw;
    private final Context mContext;
    private final com.google.android.gms.common.zzc zzamE;
    private ConnectionResult zzamF;
    private int zzamG;
    private int zzamH = 0;
    private int zzamI;
    private final Bundle zzamJ = new Bundle();
    private final Set<Api.zzc> zzamK = new HashSet<Api.zzc>();
    private zztv zzamL;
    private int zzamM;
    private boolean zzamN;
    private boolean zzamO;
    private zzq zzamP;
    private boolean zzamQ;
    private boolean zzamR;
    private final zzg zzamS;
    private final Map<Api<?>, Integer> zzamT;
    private final Api.zza<? extends zztv, zztw> zzalo;
    private ArrayList<Future<?>> zzamU = new ArrayList();

    public zzod(zzoh zzoh2, zzg zzg2, Map<Api<?>, Integer> map, com.google.android.gms.common.zzc zzc2, Api.zza<? extends zztv, zztw> zza2, Lock lock, Context context) {
        this.zzamB = zzoh2;
        this.zzamS = zzg2;
        this.zzamT = map;
        this.zzamE = zzc2;
        this.zzalo = zza2;
        this.zzamw = lock;
        this.mContext = context;
    }

    @Override
    public void begin() {
        this.zzamB.zzanC.clear();
        this.zzamN = false;
        this.zzamF = null;
        this.zzamH = 0;
        this.zzamM = 2;
        this.zzamO = false;
        this.zzamQ = false;
        boolean bl = false;
        HashMap<Api.zze, zza> hashMap = new HashMap<Api.zze, zza>();
        for (Api<?> api : this.zzamT.keySet()) {
            Api.zze zze2 = this.zzamB.zzann.get(api.zzre());
            int n = this.zzamT.get(api);
            bl |= api.zzrb().getPriority() == 1;
            if (zze2.zzpd()) {
                this.zzamN = true;
                if (n < this.zzamM) {
                    this.zzamM = n;
                }
                if (n != 0) {
                    this.zzamK.add(api.zzre());
                }
            }
            hashMap.put(zze2, new zza(this, api, n));
        }
        if (bl) {
            this.zzamN = false;
        }
        if (this.zzamN) {
            this.zzamS.zzc(this.zzamB.zzamm.getSessionId());
            zze zze3 = new zze();
            this.zzamL = this.zzalo.zza(this.mContext, this.zzamB.zzamm.getLooper(), this.zzamS, this.zzamS.zztB(), zze3, zze3);
        }
        this.zzamI = this.zzamB.zzann.size();
        this.zzamU.add(zzoi.zzsp().submit(new zzb(hashMap)));
    }

    private boolean zzrY() {
        --this.zzamI;
        if (this.zzamI > 0) {
            return false;
        }
        if (this.zzamI < 0) {
            Log.i((String)"GoogleApiClientConnecting", (String)this.zzamB.zzamm.zzsl());
            Log.wtf((String)"GoogleApiClientConnecting", (String)"GoogleApiClient received too many callbacks for the given step. Clients may be in an unexpected state; GoogleApiClient will now disconnect.", (Throwable)new Exception());
            this.zzg(new ConnectionResult(8, null));
            return false;
        }
        if (this.zzamF != null) {
            this.zzamB.zzanF = this.zzamG;
            this.zzg(this.zzamF);
            return false;
        }
        return true;
    }

    private void zza(SignInResponse signInResponse) {
        if (!this.zzbH(0)) {
            return;
        }
        ConnectionResult connectionResult = signInResponse.zztR();
        if (connectionResult.isSuccess()) {
            ResolveAccountResponse resolveAccountResponse = signInResponse.zzIY();
            ConnectionResult connectionResult2 = resolveAccountResponse.zztR();
            if (!connectionResult2.isSuccess()) {
                String string2 = String.valueOf(connectionResult2);
                Log.wtf((String)"GoogleApiClientConnecting", (String)new StringBuilder(48 + String.valueOf(string2).length()).append("Sign-in succeeded with resolve account failure: ").append(string2).toString(), (Throwable)new Exception());
                this.zzg(connectionResult2);
                return;
            }
            this.zzamO = true;
            this.zzamP = resolveAccountResponse.zztQ();
            this.zzamQ = resolveAccountResponse.zztS();
            this.zzamR = resolveAccountResponse.zztT();
            this.zzrZ();
        } else if (this.zzf(connectionResult)) {
            this.zzsc();
            this.zzrZ();
        } else {
            this.zzg(connectionResult);
        }
    }

    private void zzrZ() {
        if (this.zzamI != 0) {
            return;
        }
        if (!this.zzamN || this.zzamO) {
            this.zzsa();
        }
    }

    private void zzsa() {
        ArrayList<Api.zze> arrayList = new ArrayList<Api.zze>();
        this.zzamH = 1;
        this.zzamI = this.zzamB.zzann.size();
        for (Api.zzc<?> zzc2 : this.zzamB.zzann.keySet()) {
            if (this.zzamB.zzanC.containsKey(zzc2)) {
                if (!this.zzrY()) continue;
                this.zzsb();
                continue;
            }
            arrayList.add(this.zzamB.zzann.get(zzc2));
        }
        if (!arrayList.isEmpty()) {
            this.zzamU.add(zzoi.zzsp().submit(new zzc(arrayList)));
        }
    }

    @Override
    public void onConnected(Bundle bundle) {
        if (!this.zzbH(1)) {
            return;
        }
        if (bundle != null) {
            this.zzamJ.putAll(bundle);
        }
        if (this.zzrY()) {
            this.zzsb();
        }
    }

    @Override
    public void zza(ConnectionResult connectionResult, Api<?> api, int n) {
        if (!this.zzbH(1)) {
            return;
        }
        this.zzb(connectionResult, api, n);
        if (this.zzrY()) {
            this.zzsb();
        }
    }

    private void zzsb() {
        this.zzamB.zzsn();
        zzoi.zzsp().execute(new Runnable(){

            @Override
            public void run() {
                zzod.this.zzamE.zzag(zzod.this.mContext);
            }
        });
        if (this.zzamL != null) {
            if (this.zzamQ) {
                this.zzamL.zza(this.zzamP, this.zzamR);
            }
            this.zzah(false);
        }
        for (Api.zzc<?> zzc2 : this.zzamB.zzanC.keySet()) {
            Api.zze zze2 = this.zzamB.zzann.get(zzc2);
            zze2.disconnect();
        }
        Bundle bundle = this.zzamJ.isEmpty() ? null : this.zzamJ;
        this.zzamB.zzanG.zzk(bundle);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zznt.zza<R, A>> T zzc(T t) {
        this.zzamB.zzamm.zzanh.add(t);
        return t;
    }

    @Override
    public <A extends Api.zzb, T extends zznt.zza<? extends Result, A>> T zzd(T t) {
        throw new IllegalStateException("GoogleApiClient is not connected yet.");
    }

    @Override
    public void connect() {
    }

    @Override
    public boolean disconnect() {
        this.zzsd();
        this.zzah(true);
        this.zzamB.zzi(null);
        return true;
    }

    @Override
    public void onConnectionSuspended(int n) {
        this.zzg(new ConnectionResult(8, null));
    }

    private void zzb(ConnectionResult connectionResult, Api<?> api, int n) {
        int n2;
        if (n != 2 && this.zza(n2 = api.zzrb().getPriority(), n, connectionResult)) {
            this.zzamF = connectionResult;
            this.zzamG = n2;
        }
        this.zzamB.zzanC.put(api.zzre(), connectionResult);
    }

    private boolean zza(int n, int n2, ConnectionResult connectionResult) {
        if (n2 == 1 && !this.zze(connectionResult)) {
            return false;
        }
        return this.zzamF == null || n < this.zzamG;
    }

    private boolean zze(ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            return true;
        }
        return this.zzamE.zzbB(connectionResult.getErrorCode()) != null;
    }

    private void zzsc() {
        this.zzamN = false;
        this.zzamB.zzamm.zzano = Collections.emptySet();
        for (Api.zzc zzc2 : this.zzamK) {
            if (this.zzamB.zzanC.containsKey(zzc2)) continue;
            this.zzamB.zzanC.put(zzc2, new ConnectionResult(17, null));
        }
    }

    private boolean zzf(ConnectionResult connectionResult) {
        return this.zzamM == 2 || this.zzamM == 1 && !connectionResult.hasResolution();
    }

    private void zzg(ConnectionResult connectionResult) {
        this.zzsd();
        this.zzah(!connectionResult.hasResolution());
        this.zzamB.zzi(connectionResult);
        this.zzamB.zzanG.zzd(connectionResult);
    }

    private void zzah(boolean bl) {
        if (this.zzamL != null) {
            if (this.zzamL.isConnected() && bl) {
                this.zzamL.zzIP();
            }
            this.zzamL.disconnect();
            this.zzamP = null;
        }
    }

    private void zzsd() {
        for (Future<?> future : this.zzamU) {
            future.cancel(true);
        }
        this.zzamU.clear();
    }

    private Set<Scope> zzse() {
        if (this.zzamS == null) {
            return Collections.emptySet();
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzamS.zztv());
        Map<Api<?>, zzg.zza> map = this.zzamS.zztx();
        for (Api<?> api : map.keySet()) {
            if (this.zzamB.zzanC.containsKey(api.zzre())) continue;
            hashSet.addAll(map.get(api).zzacF);
        }
        return hashSet;
    }

    private boolean zzbH(int n) {
        if (this.zzamH != n) {
            Log.i((String)"GoogleApiClientConnecting", (String)this.zzamB.zzamm.zzsl());
            String string2 = String.valueOf(this.zzbI(this.zzamH));
            String string3 = String.valueOf(this.zzbI(n));
            Log.wtf((String)"GoogleApiClientConnecting", (String)new StringBuilder(70 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("GoogleApiClient connecting is in step ").append(string2).append(" but received callback for step ").append(string3).toString(), (Throwable)new Exception());
            this.zzg(new ConnectionResult(8, null));
            return false;
        }
        return true;
    }

    private String zzbI(int n) {
        switch (n) {
            case 0: {
                return "STEP_SERVICE_BINDINGS_AND_SIGN_IN";
            }
            case 1: {
                return "STEP_GETTING_REMOTE_SERVICE";
            }
        }
        return "UNKNOWN";
    }

    private static class zzd
    extends com.google.android.gms.signin.internal.zzb {
        private final WeakReference<zzod> zzamW;

        zzd(zzod zzod2) {
            this.zzamW = new WeakReference<zzod>(zzod2);
        }

        @Override
        @BinderThread
        public void zzb(final SignInResponse signInResponse) {
            final zzod zzod2 = (zzod)this.zzamW.get();
            if (zzod2 == null) {
                return;
            }
            zzod2.zzamB.zza(new zzoh.zza(zzod2){

                @Override
                public void zzrX() {
                    zzod2.zza(signInResponse);
                }
            });
        }
    }

    private static class zza
    implements zzd.zzf {
        private final WeakReference<zzod> zzamW;
        private final Api<?> zzakT;
        private final int zzamk;

        public zza(zzod zzod2, Api<?> api, int n) {
            this.zzamW = new WeakReference<zzod>(zzod2);
            this.zzakT = api;
            this.zzamk = n;
        }

        public void zzh(@NonNull ConnectionResult connectionResult) {
            zzod zzod2 = (zzod)this.zzamW.get();
            if (zzod2 == null) {
                return;
            }
            zzaa.zza((Looper.myLooper() == ((zzod)zzod2).zzamB.zzamm.getLooper() ? 1 : 0) != 0, (Object)"onReportServiceBinding must be called on the GoogleApiClient handler thread");
            zzod2.zzamw.lock();
            try {
                if (!zzod2.zzbH(0)) {
                    return;
                }
                if (!connectionResult.isSuccess()) {
                    zzod2.zzb(connectionResult, this.zzakT, this.zzamk);
                }
                if (zzod2.zzrY()) {
                    zzod2.zzrZ();
                }
            }
            finally {
                zzod2.zzamw.unlock();
            }
        }
    }

    private class zze
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private zze() {
        }

        @Override
        public void onConnected(Bundle bundle) {
            zzod.this.zzamL.zza(new zzd(zzod.this));
        }

        @Override
        public void onConnectionSuspended(int n) {
        }

        @Override
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            zzod.this.zzamw.lock();
            try {
                if (zzod.this.zzf(connectionResult)) {
                    zzod.this.zzsc();
                    zzod.this.zzrZ();
                } else {
                    zzod.this.zzg(connectionResult);
                }
            }
            finally {
                zzod.this.zzamw.unlock();
            }
        }
    }

    private class zzc
    extends zzf {
        private final ArrayList<Api.zze> zzanb;

        public zzc(ArrayList<Api.zze> arrayList) {
            this.zzanb = arrayList;
        }

        @Override
        @WorkerThread
        public void zzrX() {
            ((zzod)zzod.this).zzamB.zzamm.zzano = zzod.this.zzse();
            for (Api.zze zze2 : this.zzanb) {
                zze2.zza(zzod.this.zzamP, ((zzod)zzod.this).zzamB.zzamm.zzano);
            }
        }
    }

    private class zzb
    extends zzf {
        private final Map<Api.zze, zza> zzamX;

        public zzb(Map<Api.zze, zza> map) {
            this.zzamX = map;
        }

        @Override
        @WorkerThread
        public void zzrX() {
            int n;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = true;
            for (Api.zze object : this.zzamX.keySet()) {
                if (object.zzrg()) {
                    bl2 = true;
                    if (this.zzamX.get(object).zzamk != 0) continue;
                    bl = true;
                    break;
                }
                bl3 = false;
            }
            int n2 = n = bl2 ? zzod.this.zzamE.isGooglePlayServicesAvailable(zzod.this.mContext) : 0;
            if (n != 0 && (bl || bl3)) {
                final ConnectionResult connectionResult = new ConnectionResult(n, null);
                zzod.this.zzamB.zza(new zzoh.zza(zzod.this){

                    @Override
                    public void zzrX() {
                        zzod.this.zzg(connectionResult);
                    }
                });
                return;
            }
            if (zzod.this.zzamN) {
                zzod.this.zzamL.connect();
            }
            for (Api.zze zze2 : this.zzamX.keySet()) {
                final zzd.zzf zzf2 = this.zzamX.get(zze2);
                if (zze2.zzrg() && n != 0) {
                    zzod.this.zzamB.zza(new zzoh.zza(zzod.this){

                        @Override
                        public void zzrX() {
                            zzf2.zzh(new ConnectionResult(16, null));
                        }
                    });
                    continue;
                }
                zze2.zza(zzf2);
            }
        }
    }

    private abstract class zzf
    implements Runnable {
        private zzf() {
        }

        @Override
        @WorkerThread
        public void run() {
            zzod.this.zzamw.lock();
            try {
                if (Thread.interrupted()) {
                    return;
                }
                this.zzrX();
            }
            catch (RuntimeException runtimeException) {
                zzod.this.zzamB.zza(runtimeException);
            }
            finally {
                zzod.this.zzamw.unlock();
            }
        }

        @WorkerThread
        protected abstract void zzrX();
    }
}

