/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Pair;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zznq;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zzoj;
import com.google.android.gms.internal.zzok;
import com.google.android.gms.internal.zzov;
import com.google.android.gms.internal.zzpd;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzc<O extends Api.ApiOptions> {
    private final Context mContext;
    private final zzov zzakS;
    private final Api<O> zzakT;
    private final O zzakU;
    private final zznq<O> zzakV;
    private final Looper zzakW;
    private final int mId;
    private final zzoj zzakX;
    private final GoogleApiClient zzakY;
    private final AtomicBoolean zzakZ = new AtomicBoolean(false);
    private final AtomicInteger zzala = new AtomicInteger(0);

    public zzc(@NonNull Context context, Api<O> api, O o, Looper looper) {
        zzaa.zzb((Object)context, (Object)"Null context is not permitted.");
        zzaa.zzb(api, (Object)"Api must not be null.");
        zzaa.zzb((Object)looper, (Object)"Looper must not be null.");
        this.mContext = context.getApplicationContext();
        this.zzakT = api;
        this.zzakU = o;
        this.zzakW = looper;
        this.zzakS = new zzov();
        this.zzakV = new zznq<O>(this.zzakT, this.zzakU);
        this.zzakY = new zzok(this);
        Pair<zzoj, Integer> pair = zzoj.zza(this.mContext, this);
        this.zzakX = (zzoj)pair.first;
        this.mId = (Integer)pair.second;
    }

    public zzc(@NonNull Context context, Api<O> api, O o) {
        this(context, api, o, Looper.myLooper() != null ? Looper.myLooper() : Looper.getMainLooper());
    }

    public void release() {
        if (this.zzakZ.getAndSet(true)) {
            return;
        }
        this.zzakS.release();
        this.zzakX.zzd(this.mId, this.zzala.get() > 0);
    }

    private <A extends Api.zzb, T extends zznt.zza<? extends Result, A>> T zza(int n, @NonNull T t) {
        t.zzrI();
        this.zzakX.zza(this, n, t);
        return t;
    }

    private <TResult, A extends Api.zzb> Task<TResult> zza(int n, @NonNull zzpd<A, TResult> zzpd2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzakX.zza(this, n, zzpd2, taskCompletionSource);
        return taskCompletionSource.getTask();
    }

    public <A extends Api.zzb, T extends zznt.zza<? extends Result, A>> T zza(@NonNull T t) {
        return this.zza(0, t);
    }

    public <TResult, A extends Api.zzb> Task<TResult> zza(zzpd<A, TResult> zzpd2) {
        return this.zza(0, zzpd2);
    }

    public <A extends Api.zzb, T extends zznt.zza<? extends Result, A>> T zzb(@NonNull T t) {
        return this.zza(1, t);
    }

    public <TResult, A extends Api.zzb> Task<TResult> zzb(zzpd<A, TResult> zzpd2) {
        return this.zza(1, zzpd2);
    }

    public void zzrj() {
        this.zzala.incrementAndGet();
    }

    public void zzrk() {
        if (this.zzala.decrementAndGet() == 0 && this.zzakZ.get()) {
            this.zzakX.zzd(this.mId, false);
        }
    }

    public Api<O> zzrl() {
        return this.zzakT;
    }

    public O zzrm() {
        return this.zzakU;
    }

    public zznq<O> zzrn() {
        return this.zzakV;
    }

    public int getInstanceId() {
        return this.mId;
    }

    public GoogleApiClient zzro() {
        return this.zzakY;
    }

    public Looper getLooper() {
        return this.zzakW;
    }

    public Context getApplicationContext() {
        return this.mContext;
    }
}

