/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.internal.zze;
import com.google.android.gms.auth.api.signin.zzb;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInOptions
extends AbstractSafeParcelable
implements Api.ApiOptions.Optional {
    public static final Scope zzacw = new Scope("profile");
    public static final Scope zzacx = new Scope("email");
    public static final Scope zzacy = new Scope("openid");
    public static final GoogleSignInOptions DEFAULT_SIGN_IN = new Builder().requestId().requestProfile().build();
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR = new zzb();
    final int versionCode;
    private final ArrayList<Scope> zzacz;
    private Account zzZB;
    private boolean zzacA;
    private final boolean zzacB;
    private final boolean zzacC;
    private String zzacD;
    private String zzacE;
    private static Comparator<Scope> zzacv = new Comparator<Scope>(){

        public int zza(Scope scope, Scope scope2) {
            return scope.zzrw().compareTo(scope2.zzrw());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.zza((Scope)object, (Scope)object2);
        }
    };

    @Nullable
    public static GoogleSignInOptions zzco(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        Account account = null;
        String string3 = jSONObject.optString("accountName", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            account = new Account(string3, "com.google");
        }
        return new GoogleSignInOptions(hashSet, account, jSONObject.getBoolean("idTokenRequested"), jSONObject.getBoolean("serverAuthRequested"), jSONObject.getBoolean("forceCodeForRefreshToken"), jSONObject.optString("serverClientId", null), jSONObject.optString("hostedDomain", null));
    }

    GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3) {
        this.versionCode = n;
        this.zzacz = arrayList;
        this.zzZB = account;
        this.zzacA = bl;
        this.zzacB = bl2;
        this.zzacC = bl3;
        this.zzacD = string2;
        this.zzacE = string3;
    }

    private GoogleSignInOptions(Set<Scope> set, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3) {
        this(2, new ArrayList<Scope>(set), account, bl, bl2, bl3, string2, string3);
    }

    public ArrayList<Scope> zzpj() {
        return new ArrayList<Scope>(this.zzacz);
    }

    public Scope[] getScopeArray() {
        return this.zzacz.toArray(new Scope[this.zzacz.size()]);
    }

    public Account getAccount() {
        return this.zzZB;
    }

    public boolean zzpk() {
        return this.zzacA;
    }

    public boolean zzpl() {
        return this.zzacB;
    }

    public boolean zzpm() {
        return this.zzacC;
    }

    public String zzpn() {
        return this.zzacD;
    }

    public String zzpo() {
        return this.zzacE;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            GoogleSignInOptions googleSignInOptions = (GoogleSignInOptions)object;
            if (this.zzacz.size() != googleSignInOptions.zzpj().size() || !this.zzacz.containsAll(googleSignInOptions.zzpj())) {
                return false;
            }
            return (this.zzZB == null ? googleSignInOptions.getAccount() == null : this.zzZB.equals((Object)googleSignInOptions.getAccount())) && (TextUtils.isEmpty((CharSequence)this.zzacD) ? TextUtils.isEmpty((CharSequence)googleSignInOptions.zzpn()) : this.zzacD.equals(googleSignInOptions.zzpn())) && this.zzacC == googleSignInOptions.zzpm() && this.zzacA == googleSignInOptions.zzpk() && this.zzacB == googleSignInOptions.zzpl();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Scope scope : this.zzacz) {
            arrayList.add(scope.zzrw());
        }
        Collections.sort(arrayList);
        return new zze().zzq(arrayList).zzq(this.zzZB).zzq(this.zzacD).zzX(this.zzacC).zzX(this.zzacA).zzX(this.zzacB).zzpv();
    }

    public String zzpg() {
        return this.zzpi().toString();
    }

    private JSONObject zzpi() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zzacz, zzacv);
            for (Scope scope : this.zzacz) {
                jSONArray.put((Object)scope.zzrw());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            if (this.zzZB != null) {
                jSONObject.put("accountName", (Object)this.zzZB.name);
            }
            jSONObject.put("idTokenRequested", this.zzacA);
            jSONObject.put("forceCodeForRefreshToken", this.zzacC);
            jSONObject.put("serverAuthRequested", this.zzacB);
            if (!TextUtils.isEmpty((CharSequence)this.zzacD)) {
                jSONObject.put("serverClientId", (Object)this.zzacD);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzacE)) {
                jSONObject.put("hostedDomain", (Object)this.zzacE);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    public static final class Builder {
        private Set<Scope> zzacF = new HashSet<Scope>();
        private boolean zzacB;
        private boolean zzacC;
        private boolean zzacA;
        private String zzacD;
        private Account zzZB;
        private String zzacE;

        public Builder() {
        }

        public Builder(@NonNull GoogleSignInOptions googleSignInOptions) {
            zzaa.zzz((Object)googleSignInOptions);
            this.zzacF = new HashSet<Scope>(googleSignInOptions.zzacz);
            this.zzacB = googleSignInOptions.zzacB;
            this.zzacC = googleSignInOptions.zzacC;
            this.zzacA = googleSignInOptions.zzacA;
            this.zzacD = googleSignInOptions.zzacD;
            this.zzZB = googleSignInOptions.zzZB;
            this.zzacE = googleSignInOptions.zzacE;
        }

        public Builder requestId() {
            this.zzacF.add(zzacy);
            return this;
        }

        public Builder requestEmail() {
            this.zzacF.add(zzacx);
            return this;
        }

        public Builder requestProfile() {
            this.zzacF.add(zzacw);
            return this;
        }

        public Builder requestScopes(Scope scope, Scope ... scopeArray) {
            this.zzacF.add(scope);
            this.zzacF.addAll(Arrays.asList(scopeArray));
            return this;
        }

        public Builder requestIdToken(String string2) {
            this.zzacA = true;
            this.zzacD = this.zzcp(string2);
            return this;
        }

        public Builder requestServerAuthCode(String string2) {
            return this.requestServerAuthCode(string2, false);
        }

        public Builder requestServerAuthCode(String string2, boolean bl) {
            this.zzacB = true;
            this.zzacD = this.zzcp(string2);
            this.zzacC = bl;
            return this;
        }

        public Builder setAccountName(String string2) {
            this.zzZB = new Account(zzaa.zzdl((String)string2), "com.google");
            return this;
        }

        public Builder setHostedDomain(String string2) {
            this.zzacE = zzaa.zzdl((String)string2);
            return this;
        }

        public GoogleSignInOptions build() {
            if (this.zzacA && (this.zzZB == null || !this.zzacF.isEmpty())) {
                this.requestId();
            }
            return new GoogleSignInOptions(this.zzacF, this.zzZB, this.zzacA, this.zzacB, this.zzacC, this.zzacD, this.zzacE);
        }

        private String zzcp(String string2) {
            zzaa.zzdl((String)string2);
            zzaa.zzb((this.zzacD == null || this.zzacD.equals(string2) ? 1 : 0) != 0, (Object)"two different server client ids provided");
            return string2;
        }
    }
}

