/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzpe;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class zznv<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> zzalX = new ThreadLocal<Boolean>(){

        protected Boolean zzrK() {
            return false;
        }

        @Override
        protected /* synthetic */ Object initialValue() {
            return this.zzrK();
        }
    };
    private final Object zzalY = new Object();
    protected final zza<R> zzalZ;
    protected final WeakReference<GoogleApiClient> zzama;
    private final CountDownLatch zzqF = new CountDownLatch(1);
    private final ArrayList<PendingResult.zza> zzamb = new ArrayList();
    private ResultCallback<? super R> zzamc;
    private R zzals;
    private zzb zzamd;
    private volatile boolean zzame;
    private boolean zzK;
    private boolean zzamf;
    private zzr zzamg;
    private volatile zzpe<R> zzamh;
    private boolean zzami = false;

    @Deprecated
    zznv() {
        this.zzalZ = new zza(Looper.getMainLooper());
        this.zzama = new WeakReference<Object>(null);
    }

    protected zznv(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.zzalZ = new zza(looper);
        this.zzama = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    protected zznv(Looper looper) {
        this.zzalZ = new zza(looper);
        this.zzama = new WeakReference<Object>(null);
    }

    public final boolean isReady() {
        return this.zzqF.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzaa.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread");
        zzaa.zza((!this.zzame ? 1 : 0) != 0, (Object)"Result has already been consumed");
        zzaa.zza((this.zzamh == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            this.zzqF.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzy(Status.zzalx);
        }
        zzaa.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        zzaa.zza((l <= 0L || Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread when time is greater than zero.");
        zzaa.zza((!this.zzame ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzaa.zza((this.zzamh == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            boolean bl = this.zzqF.await(l, timeUnit);
            if (!bl) {
                this.zzy(Status.zzalz);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzy(Status.zzalx);
        }
        zzaa.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback) {
        Object object = this.zzalY;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzamc = null;
                return;
            }
            zzaa.zza((!this.zzame ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzaa.zza((this.zzamh == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzalZ.zza(resultCallback, (R)this.get());
            } else {
                this.zzamc = resultCallback;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        Object object = this.zzalY;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzamc = null;
                return;
            }
            zzaa.zza((!this.zzame ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzaa.zza((this.zzamh == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzalZ.zza(resultCallback, (R)this.get());
            } else {
                this.zzamc = resultCallback;
                this.zzalZ.zza(this, timeUnit.toMillis(l));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(PendingResult.zza zza2) {
        zzaa.zza((!this.zzame ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzaa.zzb((zza2 != null ? 1 : 0) != 0, (Object)"Callback cannot be null.");
        Object object = this.zzalY;
        synchronized (object) {
            if (this.isReady()) {
                zza2.zzt(this.zzals.getStatus());
            } else {
                this.zzamb.add(zza2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.zzalY;
        synchronized (object) {
            if (this.zzK || this.zzame) {
                return;
            }
            if (this.zzamg != null) {
                try {
                    this.zzamg.cancel();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            zznv.zzd(this.zzals);
            this.zzK = true;
            this.zzc(this.zzc(Status.zzalA));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzrH() {
        Object object = this.zzalY;
        synchronized (object) {
            GoogleApiClient googleApiClient = (GoogleApiClient)this.zzama.get();
            if (googleApiClient == null || !this.zzami) {
                this.cancel();
            }
            return this.isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zzalY;
        synchronized (object) {
            return this.zzK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> resultTransform) {
        zzaa.zza((!this.zzame ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Object object = this.zzalY;
        synchronized (object) {
            zzaa.zza((this.zzamh == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzaa.zza((this.zzamc == null ? 1 : 0) != 0, (Object)"Cannot call then() if callbacks are set.");
            this.zzami = true;
            this.zzamh = new zzpe(this.zzama);
            TransformedResult<? extends S> transformedResult = this.zzamh.then(resultTransform);
            if (this.isReady()) {
                this.zzalZ.zza(this.zzamh, this.get());
            } else {
                this.zzamc = this.zzamh;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(R r) {
        Object object = this.zzalY;
        synchronized (object) {
            if (this.zzamf || this.zzK || this.isReady() && this.zzrJ()) {
                zznv.zzd(r);
                return;
            }
            zzaa.zza((!this.isReady() ? 1 : 0) != 0, (Object)"Results have already been set");
            zzaa.zza((!this.zzame ? 1 : 0) != 0, (Object)"Result has already been consumed");
            this.zzc(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzy(Status status) {
        Object object = this.zzalY;
        synchronized (object) {
            if (!this.isReady()) {
                this.zzb(this.zzc(status));
                this.zzamf = true;
            }
        }
    }

    protected abstract R zzc(Status var1);

    protected void zzrE() {
    }

    @Override
    public Integer zzrv() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zza(zzr zzr2) {
        Object object = this.zzalY;
        synchronized (object) {
            this.zzamg = zzr2;
        }
    }

    public void zzrI() {
        this.zzami = this.zzami || zzalX.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R get() {
        R r;
        Object object = this.zzalY;
        synchronized (object) {
            zzaa.zza((!this.zzame ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzaa.zza((boolean)this.isReady(), (Object)"Result is not ready.");
            r = this.zzals;
            this.zzals = null;
            this.zzamc = null;
            this.zzame = true;
        }
        this.zzrE();
        return r;
    }

    boolean zzrJ() {
        return false;
    }

    private void zzc(R r) {
        this.zzals = r;
        this.zzamg = null;
        this.zzqF.countDown();
        Status status = this.zzals.getStatus();
        if (this.zzK) {
            this.zzamc = null;
        } else if (this.zzamc == null) {
            if (this.zzals instanceof Releasable) {
                this.zzamd = new zzb();
            }
        } else {
            this.zzalZ.zzrL();
            this.zzalZ.zza(this.zzamc, (R)this.get());
        }
        for (PendingResult.zza zza2 : this.zzamb) {
            zza2.zzt(status);
        }
        this.zzamb.clear();
    }

    public static void zzd(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"BasePendingResult", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    private final class zzb {
        private zzb() {
        }

        protected void finalize() throws Throwable {
            zznv.zzd(zznv.this.zzals);
            super.finalize();
        }
    }

    public static class zza<R extends Result>
    extends Handler {
        public zza() {
            this(Looper.getMainLooper());
        }

        public zza(Looper looper) {
            super(looper);
        }

        public void zza(ResultCallback<? super R> resultCallback, R r) {
            this.sendMessage(this.obtainMessage(1, new Pair(resultCallback, r)));
        }

        public void zza(zznv<R> zznv2, long l) {
            this.sendMessageDelayed(this.obtainMessage(2, zznv2), l);
        }

        public void zzrL() {
            this.removeMessages(2);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    Pair pair = (Pair)message.obj;
                    this.zzb((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    zznv zznv2 = (zznv)message.obj;
                    zznv2.zzy(Status.zzalz);
                    return;
                }
            }
            int n = message.what;
            Log.wtf((String)"BasePendingResult", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }

        protected void zzb(ResultCallback<? super R> resultCallback, R r) {
            try {
                resultCallback.onResult(r);
            }
            catch (RuntimeException runtimeException) {
                zznv.zzd(r);
                throw runtimeException;
            }
        }
    }
}

