/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

public final class Size {
    private final int zznQ;
    private final int zznR;

    public Size(int width, int height) {
        this.zznQ = width;
        this.zznR = height;
    }

    public int getWidth() {
        return this.zznQ;
    }

    public int getHeight() {
        return this.zznR;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Size) {
            Size size = (Size)obj;
            return this.zznQ == size.zznQ && this.zznR == size.zznR;
        }
        return false;
    }

    public String toString() {
        return this.zznQ + "x" + this.zznR;
    }

    private static NumberFormatException zzch(String string2) {
        throw new NumberFormatException("Invalid Size: \"" + string2 + "\"");
    }

    public static Size parseSize(String string2) throws NumberFormatException {
        if (string2 == null) {
            throw new IllegalArgumentException("string must not be null");
        }
        int n = string2.indexOf(42);
        if (n < 0) {
            n = string2.indexOf(120);
        }
        if (n < 0) {
            throw Size.zzch(string2);
        }
        try {
            return new Size(Integer.parseInt(string2.substring(0, n)), Integer.parseInt(string2.substring(n + 1)));
        }
        catch (NumberFormatException numberFormatException) {
            throw Size.zzch(string2);
        }
    }

    public int hashCode() {
        return this.zznR ^ (this.zznQ << 16 | this.zznQ >>> 16);
    }
}

