/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import com.google.android.gms.common.api.BatchResult;
import com.google.android.gms.common.api.BatchResultToken;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzb;
import java.util.ArrayList;
import java.util.List;

public final class Batch
extends zzb<BatchResult> {
    private int zzYP;
    private boolean zzYQ;
    private boolean zzYR;
    private final PendingResult<?>[] zzYS;
    private final Object zzpc = new Object();

    private Batch(List<PendingResult<?>> pendingResultList, Looper looper) {
        super(new zzb.zza(looper));
        this.zzYP = pendingResultList.size();
        this.zzYS = new PendingResult[this.zzYP];
        for (int i = 0; i < pendingResultList.size(); ++i) {
            PendingResult<?> pendingResult = pendingResultList.get(i);
            this.zzYS[i] = pendingResult;
            pendingResult.addBatchCallback(new PendingResult.BatchCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(Status status) {
                    Object object = Batch.this.zzpc;
                    synchronized (object) {
                        if (Batch.this.isCanceled()) {
                            return;
                        }
                        if (status.isCanceled()) {
                            Batch.this.zzYR = true;
                        } else if (!status.isSuccess()) {
                            Batch.this.zzYQ = true;
                        }
                        Batch.this.zzYP--;
                        if (Batch.this.zzYP == 0) {
                            if (Batch.this.zzYR) {
                                Batch.super.cancel();
                            } else {
                                Status status2 = Batch.this.zzYQ ? new Status(13) : Status.zzaaD;
                                Batch.this.zza(new BatchResult(status2, Batch.this.zzYS));
                            }
                        }
                    }
                }
            });
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        for (PendingResult<?> pendingResult : this.zzYS) {
            pendingResult.cancel();
        }
    }

    public BatchResult createFailedResult(Status status) {
        return new BatchResult(status, this.zzYS);
    }

    @Override
    public /* synthetic */ Result zzb(Status status) {
        return this.createFailedResult(status);
    }

    public static final class Builder {
        private List<PendingResult<?>> zzYU = new ArrayList();
        private Looper zzYV;

        public Builder(GoogleApiClient googleApiClient) {
            this.zzYV = googleApiClient.getLooper();
        }

        public <R extends Result> BatchResultToken<R> add(PendingResult<R> pendingResult) {
            BatchResultToken batchResultToken = new BatchResultToken(this.zzYU.size());
            this.zzYU.add(pendingResult);
            return batchResultToken;
        }

        public Batch build() {
            return new Batch(this.zzYU, this.zzYV);
        }
    }
}

