/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Parcelable;
import android.os.Process;
import android.util.Log;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.internal.zzki;
import com.google.android.gms.internal.zzlm;
import com.google.android.gms.internal.zzlp;
import com.google.android.gms.internal.zzlq;
import com.google.android.gms.internal.zzlr;
import com.google.android.gms.internal.zzmf;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class zzlo {
    private static final Object zzQc = new Object();
    private static zzlo zzRr;
    private final List<String> zzRs;
    private final List<String> zzRt;
    private final List<String> zzRu;
    private final List<String> zzRv;
    private static final ComponentName zzRw;
    private zzlr zzRx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzlo zzka() {
        Object object = zzQc;
        synchronized (object) {
            if (zzRr == null) {
                zzRr = new zzlo();
            }
        }
        return zzRr;
    }

    private zzlo() {
        if (this.getLogLevel() == zzlq.zzRF) {
            this.zzRs = Collections.EMPTY_LIST;
            this.zzRt = Collections.EMPTY_LIST;
            this.zzRu = Collections.EMPTY_LIST;
            this.zzRv = Collections.EMPTY_LIST;
            return;
        }
        String string2 = zzlp.zza.zzRA.get();
        this.zzRs = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzlp.zza.zzRB.get();
        this.zzRt = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzlp.zza.zzRC.get();
        this.zzRu = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzlp.zza.zzRD.get();
        this.zzRv = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        this.zzRx = new zzlr(1024, zzlp.zza.zzRE.get());
    }

    public boolean zza(Context context, String string2, Intent intent, ServiceConnection serviceConnection, int n) {
        this.zza(context, serviceConnection, string2, intent, "BIND");
        return context.bindService(intent, serviceConnection, n);
    }

    public boolean zza(Context context, Intent intent, ServiceConnection serviceConnection, int n) {
        return this.zza(context, context.getClass().getName(), intent, serviceConnection, n);
    }

    public void zza(Context context, ServiceConnection serviceConnection) {
        this.zza(context, serviceConnection, null, null, "UNBIND");
        context.unbindService(serviceConnection);
    }

    public void zza(Context context, ServiceConnection serviceConnection, String string2, Intent intent) {
        this.zza(context, serviceConnection, string2, intent, "CONNECT");
    }

    public void zzb(Context context, ServiceConnection serviceConnection) {
        this.zza(context, serviceConnection, null, null, "DISCONNECT");
    }

    private void zza(Context context, ServiceConnection serviceConnection, String string2, Intent intent, String string3) {
        zzlm zzlm2;
        if (!zze.zzPq) {
            return;
        }
        long l = this.zzb(serviceConnection);
        if (!this.zza(context, string2, intent, l, string3)) {
            return;
        }
        long l2 = System.currentTimeMillis();
        String string4 = zzmf.zzl(3, 5);
        if (string3.equals("UNBIND") || string3.equals("DISCONNECT")) {
            zzlm2 = new zzlm(l2, string3, null, null, null, null, string4, l);
        } else {
            ServiceInfo serviceInfo = zzlo.zzb(context, intent);
            zzlm2 = new zzlm(l2, string3, zzmf.zzR(context), string2, serviceInfo.processName, serviceInfo.name, string4, l);
        }
        context.startService(new Intent().setComponent(zzRw).putExtra("com.google.android.gms.common.stats.EXTRA_LOG_EVENT", (Parcelable)zzlm2));
    }

    private boolean zza(Context context, String string2, Intent intent, long l, String string3) {
        int n = this.getLogLevel();
        if (n == zzlq.zzRF || this.zzRx == null) {
            return false;
        }
        if (string3 == "DISCONNECT" || string3 == "UNBIND") {
            return this.zzRx.zzr(l);
        }
        ServiceInfo serviceInfo = zzlo.zzb(context, intent);
        if (serviceInfo == null) {
            return false;
        }
        String string4 = zzmf.zzR(context);
        String string5 = serviceInfo.processName;
        String string6 = serviceInfo.name;
        if (this.zzRs.contains(string4) || this.zzRt.contains(string2) || this.zzRu.contains(string5) || this.zzRv.contains(string6) || string5.equals(string4) && (n & zzlq.zzRJ) != 0) {
            return false;
        }
        this.zzRx.zza(l);
        return true;
    }

    private static ServiceInfo zzb(Context context, Intent intent) {
        List list = context.getPackageManager().queryIntentServices(intent, 128);
        if (list == null || list.size() == 0) {
            Log.w((String)"ConnectionTracker", (String)("There are no handler of this intent: " + intent.toUri(0)));
            return null;
        }
        if (list.size() > 1) {
            Log.w((String)"ConnectionTracker", (String)("There are multiple handlers for this intent: " + intent.toUri(0)));
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                ResolveInfo resolveInfo = (ResolveInfo)iterator.next();
                Log.w((String)"ConnectionTracker", (String)resolveInfo.serviceInfo.name);
                return null;
            }
        }
        return ((ResolveInfo)list.get((int)0)).serviceInfo;
    }

    private long zzb(ServiceConnection serviceConnection) {
        return (long)Process.myPid() << 32 | (long)System.identityHashCode(serviceConnection);
    }

    private int getLogLevel() {
        try {
            return zze.zzPq && zzki.isInitialized() && zzki.zzis() == Process.myUid() ? zzlp.zza.zzRz.get() : zzlq.zzRF;
        }
        catch (SecurityException securityException) {
            return zzlq.zzRF;
        }
    }

    static {
        zzRw = new ComponentName("com.google.android.gms", "com.google.android.gms.common.stats.GmsCoreStatsService");
    }
}

