/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import java.util.LinkedHashMap;
import java.util.Map;

public class zzkv<K, V> {
    private final LinkedHashMap<K, V> zzQA;
    private int size;
    private int zzQB;
    private int zzQC;
    private int zzQD;
    private int zzQE;
    private int zzQF;
    private int zzQG;

    public zzkv(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.zzQB = n;
        this.zzQA = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(K key) {
        Object object;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        zzkv<K, V> zzkv2 = this;
        synchronized (zzkv2) {
            object = this.zzQA.get(key);
            if (object != null) {
                ++this.zzQF;
                return object;
            }
            ++this.zzQG;
        }
        zzkv2 = this.create(key);
        if (zzkv2 == null) {
            return null;
        }
        zzkv zzkv3 = this;
        synchronized (zzkv3) {
            ++this.zzQD;
            object = this.zzQA.put(key, zzkv2);
            if (object != null) {
                this.zzQA.put(key, object);
            } else {
                this.size += this.zzc(key, zzkv2);
            }
        }
        if (object != null) {
            this.entryRemoved(false, key, zzkv2, object);
            return object;
        }
        this.trimToSize(this.zzQB);
        return (V)zzkv2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V put(K key, V value) {
        V v;
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        zzkv zzkv2 = this;
        synchronized (zzkv2) {
            ++this.zzQC;
            this.size += this.zzc(key, value);
            v = this.zzQA.put(key, value);
            if (v != null) {
                this.size -= this.zzc(key, v);
            }
        }
        if (v != null) {
            this.entryRemoved(false, key, v, value);
        }
        this.trimToSize(this.zzQB);
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize(int maxSize) {
        while (true) {
            V v;
            K k;
            zzkv zzkv2 = this;
            synchronized (zzkv2) {
                if (this.size < 0 || this.zzQA.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= maxSize || this.zzQA.isEmpty()) {
                    break;
                }
                Map.Entry<K, V> entry = this.zzQA.entrySet().iterator().next();
                k = entry.getKey();
                v = entry.getValue();
                this.zzQA.remove(k);
                this.size -= this.zzc(k, v);
                ++this.zzQE;
            }
            this.entryRemoved(true, k, v, null);
        }
    }

    protected void entryRemoved(boolean evicted, K key, V oldValue, V newValue) {
    }

    protected V create(K key) {
        return null;
    }

    private int zzc(K k, V v) {
        int n = this.sizeOf(k, v);
        if (n < 0) {
            throw new IllegalStateException("Negative size: " + k + "=" + v);
        }
        return n;
    }

    protected int sizeOf(K key, V value) {
        return 1;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    public final synchronized int size() {
        return this.size;
    }

    public final synchronized String toString() {
        int n = this.zzQF + this.zzQG;
        int n2 = n != 0 ? 100 * this.zzQF / n : 0;
        return String.format("LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.zzQB, this.zzQF, this.zzQG, n2);
    }
}

