/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.zzme;

public final class zzkj
extends Drawable
implements Drawable.Callback {
    private int zzOM = 0;
    private long zzON;
    private int mFrom;
    private int zzOO;
    private int zzOP = 255;
    private int zzOQ;
    private int zzOR = 0;
    private boolean zzOF = true;
    private boolean zzOS;
    private zzb zzOT;
    private Drawable zzOU;
    private Drawable zzOV;
    private boolean zzOW;
    private boolean zzOX;
    private boolean zzOY;
    private int zzOZ;

    public zzkj(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zza.zzPa;
        }
        this.zzOU = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zzOT.zzPd |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zza.zzPa;
        }
        this.zzOV = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zzOT.zzPd |= drawable3.getChangingConfigurations();
    }

    zzkj(zzb zzb2) {
        this.zzOT = new zzb(zzb2);
    }

    public void invalidateDrawable(Drawable who) {
        Drawable.Callback callback;
        if (zzme.zzkd() && (callback = this.getCallback()) != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback;
        if (zzme.zzkd() && (callback = this.getCallback()) != null) {
            callback.scheduleDrawable((Drawable)this, what, when);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback;
        if (zzme.zzkd() && (callback = this.getCallback()) != null) {
            callback.unscheduleDrawable((Drawable)this, what);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zzOT.zzPc | this.zzOT.zzPd;
    }

    public void setAlpha(int alpha) {
        if (this.zzOR == this.zzOP) {
            this.zzOR = alpha;
        }
        this.zzOP = alpha;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter cf) {
        this.zzOU.setColorFilter(cf);
        this.zzOV.setColorFilter(cf);
    }

    public int getIntrinsicWidth() {
        return Math.max(this.zzOU.getIntrinsicWidth(), this.zzOV.getIntrinsicWidth());
    }

    public int getIntrinsicHeight() {
        return Math.max(this.zzOU.getIntrinsicHeight(), this.zzOV.getIntrinsicHeight());
    }

    protected void onBoundsChange(Rect bounds) {
        this.zzOU.setBounds(bounds);
        this.zzOV.setBounds(bounds);
    }

    public Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zzOT.zzPc = this.getChangingConfigurations();
            return this.zzOT;
        }
        return null;
    }

    public int getOpacity() {
        if (!this.zzOY) {
            this.zzOZ = Drawable.resolveOpacity((int)this.zzOU.getOpacity(), (int)this.zzOV.getOpacity());
            this.zzOY = true;
        }
        return this.zzOZ;
    }

    public boolean canConstantState() {
        if (!this.zzOW) {
            this.zzOX = this.zzOU.getConstantState() != null && this.zzOV.getConstantState() != null;
            this.zzOW = true;
        }
        return this.zzOX;
    }

    public Drawable mutate() {
        if (!this.zzOS && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zzOU.mutate();
            this.zzOV.mutate();
            this.zzOS = true;
        }
        return this;
    }

    public Drawable zziI() {
        return this.zzOV;
    }

    public void startTransition(int durationMillis) {
        this.mFrom = 0;
        this.zzOO = this.zzOP;
        this.zzOR = 0;
        this.zzOQ = durationMillis;
        this.zzOM = 1;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zzOM) {
            case 1: {
                this.zzON = SystemClock.uptimeMillis();
                bl = false;
                this.zzOM = 2;
                break;
            }
            case 2: {
                if (this.zzON < 0L) break;
                float f = (float)(SystemClock.uptimeMillis() - this.zzON) / (float)this.zzOQ;
                boolean bl2 = bl = f >= 1.0f;
                if (bl) {
                    this.zzOM = 0;
                }
                f = Math.min(f, 1.0f);
                this.zzOR = (int)((float)this.mFrom + (float)(this.zzOO - this.mFrom) * f);
            }
        }
        int n = this.zzOR;
        boolean bl3 = this.zzOF;
        Drawable drawable2 = this.zzOU;
        Drawable drawable3 = this.zzOV;
        if (bl) {
            if (!bl3 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zzOP) {
                drawable3.setAlpha(this.zzOP);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl3) {
            drawable2.setAlpha(this.zzOP - n);
        }
        drawable2.draw(canvas);
        if (bl3) {
            drawable2.setAlpha(this.zzOP);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zzOP);
        }
        this.invalidateSelf();
    }

    private static final class com.google.android.gms.internal.zzkj$zza
    extends Drawable {
        private static final com.google.android.gms.internal.zzkj$zza zzPa = new com.google.android.gms.internal.zzkj$zza();
        private static final zza zzPb = new zza();

        private com.google.android.gms.internal.zzkj$zza() {
        }

        public void draw(Canvas canvas) {
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf) {
        }

        public int getOpacity() {
            return -2;
        }

        public Drawable.ConstantState getConstantState() {
            return zzPb;
        }

        private static final class zza
        extends Drawable.ConstantState {
            private zza() {
            }

            public Drawable newDrawable() {
                return zzPa;
            }

            public int getChangingConfigurations() {
                return 0;
            }
        }
    }

    static final class zzb
    extends Drawable.ConstantState {
        int zzPc;
        int zzPd;

        zzb(zzb zzb2) {
            if (zzb2 != null) {
                this.zzPc = zzb2.zzPc;
                this.zzPd = zzb2.zzPd;
            }
        }

        public Drawable newDrawable() {
            return new zzkj(this);
        }

        public int getChangingConfigurations() {
            return this.zzPc;
        }
    }
}

