/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

final class zzn
extends zzm
implements Handler.Callback {
    private final HashMap<zza, zzb> zzQe = new HashMap();
    private final Context zznk;
    private final Handler mHandler;
    private final zzlo zzQf;
    private final long zzQg;

    zzn(Context context) {
        this.zznk = context.getApplicationContext();
        this.mHandler = new Handler(context.getMainLooper(), (Handler.Callback)this);
        this.zzQf = zzlo.zzka();
        this.zzQg = 5000L;
    }

    @Override
    public boolean zza(String string2, ServiceConnection serviceConnection, String string3) {
        return this.zza(new zza(string2), serviceConnection, string3);
    }

    @Override
    public boolean zza(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        return this.zza(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzx.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.zzQe;
        synchronized (hashMap) {
            zzb zzb2 = this.zzQe.get(zza2);
            if (zzb2 == null) {
                zzb2 = new zzb(zza2);
                zzb2.zza(serviceConnection, string2);
                zzb2.zzbh(string2);
                this.zzQe.put(zza2, zzb2);
            } else {
                this.mHandler.removeMessages(0, (Object)zzb2);
                if (zzb2.zza(serviceConnection)) {
                    throw new IllegalStateException("Trying to bind a GmsServiceConnection that was already connected before.  config=" + zza2);
                }
                zzb2.zza(serviceConnection, string2);
                switch (zzb2.getState()) {
                    case 1: {
                        serviceConnection.onServiceConnected(zzb2.getComponentName(), zzb2.getBinder());
                        break;
                    }
                    case 2: {
                        zzb2.zzbh(string2);
                    }
                }
            }
            return zzb2.isBound();
        }
    }

    @Override
    public void zzb(String string2, ServiceConnection serviceConnection, String string3) {
        this.zzb(new zza(string2), serviceConnection, string3);
    }

    @Override
    public void zzb(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        this.zzb(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzx.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.zzQe;
        synchronized (hashMap) {
            zzb zzb2 = this.zzQe.get(zza2);
            if (zzb2 == null) {
                throw new IllegalStateException("Nonexistent connection status for service config: " + zza2);
            }
            if (!zzb2.zza(serviceConnection)) {
                Log.e((String)"GmsClientSupervisor", (String)("Trying to unbind a GmsServiceConnection that was not bound before. config=" + zza2));
                return;
            }
            zzb2.zzb(serviceConnection, string2);
            if (zzb2.zzjk()) {
                Message message = this.mHandler.obtainMessage(0, (Object)zzb2);
                this.mHandler.sendMessageDelayed(message, this.zzQg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                zzb zzb2 = (zzb)msg.obj;
                HashMap<zza, zzb> hashMap = this.zzQe;
                synchronized (hashMap) {
                    if (zzb2.zzjk()) {
                        if (zzb2.isBound()) {
                            zzb2.zzbi("GmsClientSupervisor");
                        }
                        this.zzQe.remove(zzb2.zzQl);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static final class zza {
        private final String zzrc;
        private final ComponentName zzQh;

        public zza(String string2) {
            this.zzrc = zzx.zzbn(string2);
            this.zzQh = null;
        }

        public zza(ComponentName componentName) {
            this.zzrc = null;
            this.zzQh = zzx.zzl(componentName);
        }

        public String toString() {
            return this.zzrc == null ? this.zzQh.flattenToString() : this.zzrc;
        }

        public Intent zzjj() {
            Intent intent = this.zzrc != null ? new Intent(this.zzrc).setPackage("com.google.android.gms") : new Intent().setComponent(this.zzQh);
            return intent;
        }

        public int hashCode() {
            return zzw.hashCode(this.zzrc, this.zzQh);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)o;
            return zzw.equal(this.zzrc, zza2.zzrc) && zzw.equal(this.zzQh, zza2.zzQh);
        }
    }

    private final class zzb {
        private final zza zzQi;
        private final Set<ServiceConnection> zzQj;
        private int mState;
        private boolean zzQk;
        private IBinder zzPp;
        private final com.google.android.gms.common.internal.zzn$zza zzQl;
        private ComponentName zzQh;

        public zzb(com.google.android.gms.common.internal.zzn$zza zza2) {
            this.zzQl = zza2;
            this.zzQi = new zza();
            this.zzQj = new HashSet<ServiceConnection>();
            this.mState = 2;
        }

        public void zzbh(String string2) {
            this.zzQk = zzn.this.zzQf.zza(zzn.this.zznk, string2, this.zzQl.zzjj(), this.zzQi, 129);
            if (this.zzQk) {
                this.mState = 3;
            } else {
                zzn.this.zzQf.zza(zzn.this.zznk, this.zzQi);
            }
        }

        public void zzbi(String string2) {
            zzn.this.zzQf.zza(zzn.this.zznk, this.zzQi);
            this.zzQk = false;
            this.mState = 2;
        }

        public void zza(ServiceConnection serviceConnection, String string2) {
            zzn.this.zzQf.zza(zzn.this.zznk, serviceConnection, string2, this.zzQl.zzjj());
            this.zzQj.add(serviceConnection);
        }

        public void zzb(ServiceConnection serviceConnection, String string2) {
            zzn.this.zzQf.zzb(zzn.this.zznk, serviceConnection);
            this.zzQj.remove(serviceConnection);
        }

        public boolean isBound() {
            return this.zzQk;
        }

        public int getState() {
            return this.mState;
        }

        public boolean zza(ServiceConnection serviceConnection) {
            return this.zzQj.contains(serviceConnection);
        }

        public boolean zzjk() {
            return this.zzQj.isEmpty();
        }

        public IBinder getBinder() {
            return this.zzPp;
        }

        public ComponentName getComponentName() {
            return this.zzQh;
        }

        public class zza
        implements ServiceConnection {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName component, IBinder binder) {
                HashMap hashMap = zzn.this.zzQe;
                synchronized (hashMap) {
                    zzb.this.zzPp = binder;
                    zzb.this.zzQh = component;
                    for (ServiceConnection serviceConnection : zzb.this.zzQj) {
                        serviceConnection.onServiceConnected(component, binder);
                    }
                    zzb.this.mState = 1;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceDisconnected(ComponentName component) {
                HashMap hashMap = zzn.this.zzQe;
                synchronized (hashMap) {
                    zzb.this.zzPp = null;
                    zzb.this.zzQh = component;
                    for (ServiceConnection serviceConnection : zzb.this.zzQj) {
                        serviceConnection.onServiceDisconnected(component);
                    }
                    zzb.this.mState = 2;
                }
            }
        }
    }
}

