/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzx;
import java.util.ArrayList;

public final class zzl
implements Handler.Callback {
    private final zza zzPX;
    private final ArrayList<GoogleApiClient.ConnectionCallbacks> zzPY = new ArrayList();
    final ArrayList<GoogleApiClient.ConnectionCallbacks> zzPZ = new ArrayList();
    private boolean zzQa = false;
    private final ArrayList<GoogleApiClient.OnConnectionFailedListener> zzQb = new ArrayList();
    private final Handler mHandler;

    public zzl(Looper looper, zza zza2) {
        this.zzPX = zza2;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzfe() {
        ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = this.zzPY;
        synchronized (arrayList) {
            this.zzj(this.zzPX.zzhp());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzj(Bundle bundle) {
        ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = this.zzPY;
        synchronized (arrayList) {
            zzx.zzN(!this.zzQa);
            this.mHandler.removeMessages(1);
            this.zzQa = true;
            zzx.zzN(this.zzPZ.size() == 0);
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList2 = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zzPY);
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList2) {
                if (!this.zzPX.zzin() || !this.zzPX.isConnected()) break;
                if (this.zzPZ.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnected(bundle);
            }
            this.zzPZ.clear();
            this.zzQa = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzaJ(int n) {
        this.mHandler.removeMessages(1);
        ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = this.zzPY;
        synchronized (arrayList) {
            this.zzQa = true;
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList2 = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zzPY);
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList2) {
                if (!this.zzPX.zzin()) break;
                if (!this.zzPY.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnectionSuspended(n);
            }
            this.zzPZ.clear();
            this.zzQa = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzg(ConnectionResult connectionResult) {
        this.mHandler.removeMessages(1);
        ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList = this.zzQb;
        synchronized (arrayList) {
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList2 = new ArrayList<GoogleApiClient.OnConnectionFailedListener>(this.zzQb);
            for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : arrayList2) {
                if (!this.zzPX.zzin()) {
                    return;
                }
                if (!this.zzQb.contains(onConnectionFailedListener)) continue;
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        zzx.zzl(listener);
        ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = this.zzPY;
        synchronized (arrayList) {
            if (this.zzPY.contains(listener)) {
                Log.w((String)"GmsClientEvents", (String)("registerConnectionCallbacks(): listener " + listener + " is already registered"));
            } else {
                this.zzPY.add(listener);
            }
        }
        if (this.zzPX.isConnected()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks listener) {
        zzx.zzl(listener);
        ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = this.zzPY;
        synchronized (arrayList) {
            return this.zzPY.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        zzx.zzl(listener);
        ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = this.zzPY;
        synchronized (arrayList) {
            boolean bl = this.zzPY.remove(listener);
            if (!bl) {
                Log.w((String)"GmsClientEvents", (String)("unregisterConnectionCallbacks(): listener " + listener + " not found"));
            } else if (this.zzQa) {
                this.zzPZ.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        zzx.zzl(listener);
        ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList = this.zzQb;
        synchronized (arrayList) {
            if (this.zzQb.contains(listener)) {
                Log.w((String)"GmsClientEvents", (String)("registerConnectionFailedListener(): listener " + listener + " is already registered"));
            } else {
                this.zzQb.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener listener) {
        zzx.zzl(listener);
        ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList = this.zzQb;
        synchronized (arrayList) {
            return this.zzQb.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        zzx.zzl(listener);
        ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList = this.zzQb;
        synchronized (arrayList) {
            boolean bl = this.zzQb.remove(listener);
            if (!bl) {
                Log.w((String)"GmsClientEvents", (String)("unregisterConnectionFailedListener(): listener " + listener + " not found"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message msg) {
        if (msg.what == 1) {
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)msg.obj;
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = this.zzPY;
            synchronized (arrayList) {
                if (this.zzPX.zzin() && this.zzPX.isConnected() && this.zzPY.contains(connectionCallbacks)) {
                    Bundle bundle = this.zzPX.zzhp();
                    connectionCallbacks.onConnected(bundle);
                }
            }
            return true;
        }
        Log.wtf((String)"GmsClientEvents", (String)"Don't know how to handle this message.");
        return false;
    }

    public static interface zza {
        public boolean zzin();

        public boolean isConnected();

        public Bundle zzhp();
    }
}

