/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import com.google.android.gms.common.api.AbstractPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzg;
import com.google.android.gms.common.internal.zzx;

public final class PendingResults {
    public static PendingResult<Status> immediatePendingResult(Status result) {
        zzx.zzb(result, (Object)"Result must not be null");
        zzg zzg2 = new zzg(Looper.getMainLooper());
        zzg2.setResult(result);
        return zzg2;
    }

    public static <R extends Result> PendingResult<R> immediatePendingResult(R result) {
        zzx.zzb(result, (Object)"Result must not be null");
        zzb<R> zzb2 = new zzb<R>();
        zzb2.setResult(result);
        return zzb2;
    }

    public static PendingResult<Status> canceledPendingResult() {
        zzg zzg2 = new zzg(Looper.getMainLooper());
        zzg2.cancel();
        return zzg2;
    }

    public static <R extends Result> PendingResult<R> canceledPendingResult(R result) {
        zzx.zzb(result, (Object)"Result must not be null");
        zzx.zzb(result.getStatus().getStatusCode() == 16, (Object)"Status code must be CommonStatusCodes.CANCELED");
        zza<R> zza2 = new zza<R>(result);
        zza2.cancel();
        return zza2;
    }

    private PendingResults() {
    }

    private static final class zza<R extends Result>
    extends AbstractPendingResult<R> {
        private final R zzNm;

        public zza(R r) {
            super(Looper.getMainLooper());
            this.zzNm = r;
        }

        @Override
        protected R createFailedResult(Status status) {
            if (status.getStatusCode() != this.zzNm.getStatus().getStatusCode()) {
                throw new UnsupportedOperationException("Creating failed results is not supported");
            }
            return this.zzNm;
        }
    }

    private static final class zzb<R extends Result>
    extends AbstractPendingResult<R> {
        public zzb() {
            super(Looper.getMainLooper());
        }

        @Override
        protected R createFailedResult(Status status) {
            throw new UnsupportedOperationException("Creating failed results is not supported");
        }
    }
}

