/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import com.google.android.gms.internal.c;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.ag;
import com.google.android.gms.tagmanager.bh;
import com.google.android.gms.tagmanager.br;
import com.google.android.gms.tagmanager.ce;
import com.google.android.gms.tagmanager.cr;
import com.google.android.gms.tagmanager.ct;
import com.google.android.gms.tagmanager.di;
import com.google.android.gms.tagmanager.s;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Container {
    private final Context mContext;
    private final String aqm;
    private final DataLayer aqn;
    private ct aqo;
    private Map<String, FunctionCallMacroCallback> aqp = new HashMap<String, FunctionCallMacroCallback>();
    private Map<String, FunctionCallTagCallback> aqq = new HashMap<String, FunctionCallTagCallback>();
    private volatile long aqr;
    private volatile String aqs = "";

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, cr.c resource) {
        this.mContext = context;
        this.aqn = dataLayer;
        this.aqm = containerId;
        this.aqr = lastRefreshTime;
        this.a(resource);
    }

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, c.j resource) {
        this.mContext = context;
        this.aqn = dataLayer;
        this.aqm = containerId;
        this.aqr = lastRefreshTime;
        this.a(resource.gs);
        if (resource.gr != null) {
            this.a(resource.gr);
        }
    }

    public String getContainerId() {
        return this.aqm;
    }

    public boolean getBoolean(String key) {
        ct ct2 = this.pk();
        if (ct2 == null) {
            bh.T("getBoolean called for closed container.");
            return di.qY();
        }
        try {
            return di.n(ct2.cT(key).getObject());
        }
        catch (Exception exception) {
            bh.T("Calling getBoolean() threw an exception: " + exception.getMessage() + " Returning default value.");
            return di.qY();
        }
    }

    public double getDouble(String key) {
        ct ct2 = this.pk();
        if (ct2 == null) {
            bh.T("getDouble called for closed container.");
            return di.qX();
        }
        try {
            return di.m(ct2.cT(key).getObject());
        }
        catch (Exception exception) {
            bh.T("Calling getDouble() threw an exception: " + exception.getMessage() + " Returning default value.");
            return di.qX();
        }
    }

    public long getLong(String key) {
        ct ct2 = this.pk();
        if (ct2 == null) {
            bh.T("getLong called for closed container.");
            return di.qW();
        }
        try {
            return di.l(ct2.cT(key).getObject());
        }
        catch (Exception exception) {
            bh.T("Calling getLong() threw an exception: " + exception.getMessage() + " Returning default value.");
            return di.qW();
        }
    }

    public String getString(String key) {
        ct ct2 = this.pk();
        if (ct2 == null) {
            bh.T("getString called for closed container.");
            return di.ra();
        }
        try {
            return di.j(ct2.cT(key).getObject());
        }
        catch (Exception exception) {
            bh.T("Calling getString() threw an exception: " + exception.getMessage() + " Returning default value.");
            return di.ra();
        }
    }

    public long getLastRefreshTime() {
        return this.aqr;
    }

    public boolean isDefault() {
        return this.getLastRefreshTime() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallMacroCallback(String customMacroName, FunctionCallMacroCallback customMacroCallback) {
        if (customMacroCallback == null) {
            throw new NullPointerException("Macro handler must be non-null");
        }
        Map<String, FunctionCallMacroCallback> map = this.aqp;
        synchronized (map) {
            this.aqp.put(customMacroName, customMacroCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallMacroCallback(String customMacroName) {
        Map<String, FunctionCallMacroCallback> map = this.aqp;
        synchronized (map) {
            this.aqp.remove(customMacroName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallMacroCallback cp(String string2) {
        Map<String, FunctionCallMacroCallback> map = this.aqp;
        synchronized (map) {
            return this.aqp.get(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallTagCallback(String customTagName, FunctionCallTagCallback customTagCallback) {
        if (customTagCallback == null) {
            throw new NullPointerException("Tag callback must be non-null");
        }
        Map<String, FunctionCallTagCallback> map = this.aqq;
        synchronized (map) {
            this.aqq.put(customTagName, customTagCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallTagCallback(String customTagName) {
        Map<String, FunctionCallTagCallback> map = this.aqq;
        synchronized (map) {
            this.aqq.remove(customTagName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallTagCallback cq(String string2) {
        Map<String, FunctionCallTagCallback> map = this.aqq;
        synchronized (map) {
            return this.aqq.get(string2);
        }
    }

    void cr(String string2) {
        this.pk().cr(string2);
    }

    String pj() {
        return this.aqs;
    }

    private void a(c.f f2) {
        if (f2 == null) {
            throw new NullPointerException();
        }
        cr.c c2 = null;
        try {
            c2 = cr.b(f2);
        }
        catch (cr.g g2) {
            bh.T("Not loading resource: " + f2 + " because it is invalid: " + g2.toString());
            return;
        }
        this.a(c2);
    }

    private void a(c.i[] iArray) {
        ArrayList<c.i> arrayList = new ArrayList<c.i>();
        for (c.i i2 : iArray) {
            arrayList.add(i2);
        }
        this.pk().l(arrayList);
    }

    private void a(cr.c c2) {
        this.aqs = c2.getVersion();
        ag ag2 = this.cs(this.aqs);
        ct ct2 = new ct(this.mContext, c2, this.aqn, new a(), new b(), ag2);
        this.a(ct2);
    }

    ag cs(String string2) {
        if (ce.qa().qb().equals((Object)ce.a.ass)) {
            // empty if block
        }
        return new br();
    }

    private synchronized void a(ct ct2) {
        this.aqo = ct2;
    }

    private synchronized ct pk() {
        return this.aqo;
    }

    void release() {
        this.aqo = null;
    }

    private class b
    implements s.a {
        private b() {
        }

        @Override
        public Object b(String string2, Map<String, Object> map) {
            FunctionCallTagCallback functionCallTagCallback = Container.this.cq(string2);
            if (functionCallTagCallback != null) {
                functionCallTagCallback.execute(string2, map);
            }
            return di.ra();
        }
    }

    private class a
    implements s.a {
        private a() {
        }

        @Override
        public Object b(String string2, Map<String, Object> map) {
            FunctionCallMacroCallback functionCallMacroCallback = Container.this.cp(string2);
            return functionCallMacroCallback == null ? null : functionCallMacroCallback.getValue(string2, map);
        }
    }

    public static interface FunctionCallTagCallback {
        public void execute(String var1, Map<String, Object> var2);
    }

    public static interface FunctionCallMacroCallback {
        public Object getValue(String var1, Map<String, Object> var2);
    }
}

