/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.internal.jm;
import com.google.android.gms.internal.jn;
import com.google.android.gms.internal.js;
import com.google.android.gms.internal.jt;
import com.google.android.gms.internal.jx;
import java.util.ArrayList;

public abstract class jl<T extends IInterface>
implements Api.a,
jm.b {
    private final Context mContext;
    private final Looper JF;
    final Handler mHandler;
    private final Object mH = new Object();
    private T MJ;
    private final ArrayList<b<?>> MK = new ArrayList();
    private f ML;
    private int MM = 1;
    private final String[] MN;
    boolean MO = false;
    private final jm JS;
    public static final String[] MP = new String[]{"service_esmobile", "service_googleme"};

    protected jl(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this.mContext = jx.i(context);
        this.JF = jx.b(looper, (Object)"Looper must not be null");
        this.JS = new jm(context, looper, this);
        this.mHandler = new a(looper);
        this.c(stringArray);
        this.MN = stringArray;
        this.registerConnectionCallbacks(jx.i(connectionCallbacks));
        this.registerConnectionFailedListener(jx.i(onConnectionFailedListener));
    }

    @Deprecated
    protected jl(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this(context, context.getMainLooper(), new c(connectionCallbacks), new g(onConnectionFailedListener), stringArray);
    }

    protected void c(String ... stringArray) {
    }

    protected abstract String bK();

    protected abstract String bL();

    protected abstract T l(IBinder var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(int n2, T t2) {
        jx.L(n2 == 3 == (t2 != null));
        Object object = this.mH;
        synchronized (object) {
            this.MM = n2;
            this.MJ = t2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(int n2, int n3, T t2) {
        Object object = this.mH;
        synchronized (object) {
            if (this.MM != n2) {
                return false;
            }
            this.a(n3, t2);
            return true;
        }
    }

    @Override
    public void connect() {
        this.MO = true;
        this.a(2, null);
        int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mContext);
        if (n2 != 0) {
            this.a(1, null);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)n2));
            return;
        }
        if (this.ML != null) {
            Log.e((String)"GmsClient", (String)("Calling connect() while still connected, missing disconnect() for " + this.bK()));
            jn.J(this.mContext).b(this.bK(), this.ML);
        }
        this.ML = new f();
        boolean bl2 = jn.J(this.mContext).a(this.bK(), this.ML);
        if (!bl2) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.bK()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)9));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.mH;
        synchronized (object) {
            return this.MM == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.mH;
        synchronized (object) {
            return this.MM == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.MO = false;
        ArrayList<b<?>> arrayList = this.MK;
        synchronized (arrayList) {
            int n2 = this.MK.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.MK.get(i2).hz();
            }
            this.MK.clear();
        }
        this.a(1, null);
        if (this.ML != null) {
            jn.J(this.mContext).b(this.bK(), this.ML);
            this.ML = null;
        }
    }

    public void aD(int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)n2));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.JF;
    }

    public final String[] hv() {
        return this.MN;
    }

    protected final void N(IBinder iBinder) {
        try {
            jt jt2 = jt.a.Q(iBinder);
            this.a(jt2, new e(this));
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"service died");
            this.aD(1);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"Remote exception occurred", (Throwable)remoteException);
        }
    }

    protected abstract void a(jt var1, e var2) throws RemoteException;

    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)new h(n2, iBinder, bundle)));
    }

    protected final void dS() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @Override
    public Bundle fX() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T hw() throws DeadObjectException {
        Object object = this.mH;
        synchronized (object) {
            if (this.MM == 4) {
                throw new DeadObjectException();
            }
            this.dS();
            jx.a(this.MJ != null, "Client is connected but service is null");
            return this.MJ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void a(b<?> b2) {
        ArrayList<b<?>> arrayList = this.MK;
        synchronized (arrayList) {
            this.MK.add(b2);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, b2));
    }

    @Override
    public boolean gN() {
        return this.MO;
    }

    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.JS.registerConnectionCallbacks(listener);
    }

    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.JS.registerConnectionFailedListener(listener);
    }

    @Deprecated
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.JS.registerConnectionCallbacks(new c(listener));
    }

    @Deprecated
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        return this.JS.isConnectionCallbacksRegistered(new c(listener));
    }

    @Deprecated
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.JS.unregisterConnectionCallbacks(new c(listener));
    }

    @Deprecated
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.JS.registerConnectionFailedListener(listener);
    }

    @Deprecated
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        return this.JS.isConnectionFailedListenerRegistered(listener);
    }

    @Deprecated
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.JS.unregisterConnectionFailedListener(listener);
    }

    public static final class e
    extends js.a {
        private jl MT;

        public e(jl jl2) {
            this.MT = jl2;
        }

        @Override
        public void b(int n2, IBinder iBinder, Bundle bundle) {
            jx.b("onPostInitComplete can be called only once per call to getServiceFromBroker", (Object)this.MT);
            this.MT.a(n2, iBinder, bundle);
            this.MT = null;
        }
    }

    protected final class h
    extends b<Boolean> {
        public final int statusCode;
        public final Bundle MV;
        public final IBinder MW;

        public h(int n2, IBinder iBinder, Bundle bundle) {
            super(true);
            this.statusCode = n2;
            this.MW = iBinder;
            this.MV = bundle;
        }

        protected void b(Boolean bl2) {
            if (bl2 == null) {
                jl.this.a(1, null);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    try {
                        Object t2;
                        String string = this.MW.getInterfaceDescriptor();
                        if (jl.this.bL().equals(string) && (t2 = jl.this.l(this.MW)) != null) {
                            jl.this.a(3, t2);
                            jl.this.JS.dU();
                            return;
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    jn.J(jl.this.mContext).b(jl.this.bK(), jl.this.ML);
                    jl.this.ML = null;
                    jl.this.a(1, null);
                    jl.this.JS.b(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    jl.this.a(1, null);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    PendingIntent pendingIntent = null;
                    if (this.MV != null) {
                        pendingIntent = (PendingIntent)this.MV.getParcelable("pendingIntent");
                    }
                    if (jl.this.ML != null) {
                        jn.J(jl.this.mContext).b(jl.this.bK(), jl.this.ML);
                        jl.this.ML = null;
                    }
                    jl.this.a(1, null);
                    jl.this.JS.b(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void hx() {
        }

        @Override
        protected /* synthetic */ void g(Object object) {
            this.b((Boolean)object);
        }
    }

    public static final class g
    implements GoogleApiClient.OnConnectionFailedListener {
        private final GooglePlayServicesClient.OnConnectionFailedListener MU;

        public g(GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.MU = onConnectionFailedListener;
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            this.MU.onConnectionFailed(result);
        }

        public boolean equals(Object other) {
            if (other instanceof g) {
                return this.MU.equals(((g)other).MU);
            }
            return this.MU.equals(other);
        }
    }

    public static final class c
    implements GoogleApiClient.ConnectionCallbacks {
        private final GooglePlayServicesClient.ConnectionCallbacks MS;

        public c(GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks) {
            this.MS = connectionCallbacks;
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            this.MS.onConnected(connectionHint);
        }

        @Override
        public void onConnectionSuspended(int cause) {
            this.MS.onDisconnected();
        }

        public boolean equals(Object other) {
            if (other instanceof c) {
                return this.MS.equals(((c)other).MS);
            }
            return this.MS.equals(other);
        }
    }

    public abstract class d<TListener>
    extends b<TListener> {
        private final DataHolder JG;

        public d(TListener TListener, DataHolder dataHolder) {
            super(TListener);
            this.JG = dataHolder;
        }

        @Override
        protected final void g(TListener TListener) {
            this.b(TListener, this.JG);
        }

        protected abstract void b(TListener var1, DataHolder var2);

        @Override
        protected void hx() {
            if (this.JG != null) {
                this.JG.close();
            }
        }
    }

    protected abstract class b<TListener> {
        private TListener mListener;
        private boolean MR;

        public b(TListener TListener) {
            this.mListener = TListener;
            this.MR = false;
        }

        protected abstract void g(TListener var1);

        protected abstract void hx();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void hy() {
            TListener TListener;
            b b2 = this;
            synchronized (b2) {
                TListener = this.mListener;
                if (this.MR) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            if (TListener != null) {
                try {
                    this.g(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.hx();
                    throw runtimeException;
                }
            } else {
                this.hx();
            }
            b2 = this;
            synchronized (b2) {
                this.MR = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.hz();
            ArrayList arrayList = jl.this.MK;
            synchronized (arrayList) {
                jl.this.MK.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void hz() {
            b b2 = this;
            synchronized (b2) {
                this.mListener = null;
            }
        }
    }

    final class a
    extends Handler {
        public a(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 1 && !jl.this.isConnecting()) {
                b b2 = (b)msg.obj;
                b2.hx();
                b2.unregister();
                return;
            }
            if (msg.what == 3) {
                jl.this.JS.b(new ConnectionResult((Integer)msg.obj, null));
                return;
            }
            if (msg.what == 4) {
                jl.this.a(4, null);
                jl.this.JS.aE((Integer)msg.obj);
                jl.this.a(4, 1, null);
                return;
            }
            if (msg.what == 2 && !jl.this.isConnected()) {
                b b3 = (b)msg.obj;
                b3.hx();
                b3.unregister();
                return;
            }
            if (msg.what == 2 || msg.what == 1) {
                b b4 = (b)msg.obj;
                b4.hy();
                return;
            }
            Log.wtf((String)"GmsClient", (String)"Don't know how to handle this message.");
        }
    }

    public final class f
    implements ServiceConnection {
        public void onServiceConnected(ComponentName component, IBinder binder) {
            jl.this.N(binder);
        }

        public void onServiceDisconnected(ComponentName component) {
            jl.this.mHandler.sendMessage(jl.this.mHandler.obtainMessage(4, (Object)1));
        }
    }
}

