/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import android.util.TypedValue;
import com.google.android.gms.R;
import com.google.android.gms.common.ErrorDialogFragment;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.SupportErrorDialogFragment;
import com.google.android.gms.common.b;
import com.google.android.gms.internal.jf;
import com.google.android.gms.internal.jh;
import com.google.android.gms.internal.jo;
import com.google.android.gms.internal.jx;
import com.google.android.gms.internal.lc;
import com.google.android.gms.internal.ll;
import java.io.InputStream;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;

public final class GooglePlayServicesUtil {
    public static final String GMS_ERROR_DIALOG = "GooglePlayServicesErrorDialog";
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = 6587000;
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    public static final String GOOGLE_PLAY_STORE_PACKAGE = "com.android.vending";
    public static boolean Jg = false;
    public static boolean Jh = false;
    private static int Ji = -1;
    private static final Object Jj = new Object();

    private GooglePlayServicesUtil() {
    }

    public static String getErrorString(int errorCode) {
        switch (errorCode) {
            case 0: {
                return "SUCCESS";
            }
            case 1: {
                return "SERVICE_MISSING";
            }
            case 2: {
                return "SERVICE_VERSION_UPDATE_REQUIRED";
            }
            case 3: {
                return "SERVICE_DISABLED";
            }
            case 4: {
                return "SIGN_IN_REQUIRED";
            }
            case 5: {
                return "INVALID_ACCOUNT";
            }
            case 6: {
                return "RESOLUTION_REQUIRED";
            }
            case 7: {
                return "NETWORK_ERROR";
            }
            case 8: {
                return "INTERNAL_ERROR";
            }
            case 9: {
                return "SERVICE_INVALID";
            }
            case 10: {
                return "DEVELOPER_ERROR";
            }
            case 11: {
                return "LICENSE_CHECK_FAILED";
            }
        }
        return "UNKNOWN_ERROR_CODE";
    }

    public static int isGooglePlayServicesAvailable(Context context) {
        ApplicationInfo applicationInfo;
        Resources resources;
        PackageManager packageManager;
        block22: {
            Object object;
            packageManager = context.getPackageManager();
            if (!jf.Mv) {
                try {
                    resources = context.getResources();
                    resources.getString(R.string.common_google_play_services_unknown_issue);
                }
                catch (Throwable throwable) {
                    Log.e((String)"GooglePlayServicesUtil", (String)"The Google Play services resources were not found. Check your project configuration to ensure that the resources are included.");
                }
            }
            if (!jf.Mv) {
                GooglePlayServicesUtil.D(context);
            }
            try {
                resources = packageManager.getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services is missing.");
                return 1;
            }
            if (lc.aU(resources.versionCode)) {
                int n2;
                int n3 = n2 = GooglePlayServicesUtil.gw() ? 0 : 1;
                if (GooglePlayServicesUtil.a((PackageInfo)resources, b.Ix[n2], b.IE[n2], b.IC[n2]) == null) {
                    Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Services signature invalid on Glass.");
                    return 9;
                }
                object = context.getPackageName();
                try {
                    applicationInfo = packageManager.getPackageInfo((String)object, 64);
                    if (!GooglePlayServicesUtil.a(packageManager, (PackageInfo)applicationInfo)) {
                        Log.w((String)"GooglePlayServicesUtil", (String)("Calling package " + applicationInfo.packageName + " signature invalid on Glass."));
                        return 9;
                    }
                    break block22;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    Log.w((String)"GooglePlayServicesUtil", (String)("Could not get info for calling package: " + (String)object));
                    return 9;
                }
            }
            if (lc.K(context)) {
                if (GooglePlayServicesUtil.a((PackageInfo)resources, b.Ix) == null) {
                    Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services signature invalid.");
                    return 9;
                }
            } else {
                PackageInfo packageInfo;
                try {
                    packageInfo = packageManager.getPackageInfo(GOOGLE_PLAY_STORE_PACKAGE, 64);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Store is missing.");
                    return 9;
                }
                object = GooglePlayServicesUtil.a(packageInfo, b.Ix);
                if (object == null) {
                    Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Store signature invalid.");
                    return 9;
                }
                if (GooglePlayServicesUtil.a((PackageInfo)resources, new byte[][]{object}) == null) {
                    Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services signature invalid.");
                    return 9;
                }
            }
        }
        int n4 = lc.aS(6587000);
        int n5 = lc.aS(resources.versionCode);
        if (n5 < n4) {
            Log.w((String)"GooglePlayServicesUtil", (String)("Google Play services out of date.  Requires 6587000 but found " + resources.versionCode));
            return 2;
        }
        try {
            applicationInfo = packageManager.getApplicationInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.wtf((String)"GooglePlayServicesUtil", (String)"Google Play services missing when getting application info.");
            nameNotFoundException.printStackTrace();
            return 1;
        }
        if (!applicationInfo.enabled) {
            return 3;
        }
        return 0;
    }

    public static void C(Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable(context);
        if (n2 != 0) {
            Intent intent = GooglePlayServicesUtil.aj(n2);
            Log.e((String)"GooglePlayServicesUtil", (String)("GooglePlayServices not available due to error " + n2));
            if (intent == null) {
                throw new GooglePlayServicesNotAvailableException(n2);
            }
            throw new GooglePlayServicesRepairableException(n2, "Google Play Services not available", intent);
        }
    }

    private static void D(Context context) {
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.wtf((String)"GooglePlayServicesUtil", (String)"This should never happen.", (Throwable)nameNotFoundException);
        }
        Bundle bundle = applicationInfo.metaData;
        if (bundle != null) {
            int n2 = bundle.getInt("com.google.android.gms.version");
            if (n2 == 6587000) {
                return;
            }
            throw new IllegalStateException("The meta-data tag in your app's AndroidManifest.xml does not have the right value.  Expected 6587000 but found " + n2 + ".  You must have the" + " following declaration within the <application> element: " + "    <meta-data android:name=\"" + "com.google.android.gms.version" + "\" android:value=\"@integer/google_play_services_version\" />");
        }
        throw new IllegalStateException("A required meta-data tag in your app's AndroidManifest.xml does not exist.  You must have the following declaration within the <application> element:     <meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />");
    }

    public static boolean isGoogleSignedUid(PackageManager packageManager, int uid) {
        if (packageManager == null) {
            throw new SecurityException("Unknown error: invalid Package Manager");
        }
        String[] stringArray = packageManager.getPackagesForUid(uid);
        if (stringArray.length == 0 || !GooglePlayServicesUtil.b(packageManager, stringArray[0])) {
            throw new SecurityException("Uid is not Google Signed");
        }
        return true;
    }

    public static boolean b(PackageManager packageManager, String string2) {
        PackageInfo packageInfo;
        try {
            packageInfo = packageManager.getPackageInfo(string2, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            if (Log.isLoggable((String)"GooglePlayServicesUtil", (int)3)) {
                Log.d((String)"GooglePlayServicesUtil", (String)("Package manager can't find package " + string2 + ", defaulting to false"));
            }
            return false;
        }
        return GooglePlayServicesUtil.a(packageManager, packageInfo);
    }

    public static boolean a(PackageManager packageManager, PackageInfo packageInfo) {
        boolean bl2;
        if (packageInfo == null) {
            return false;
        }
        if (GooglePlayServicesUtil.c(packageManager)) {
            return GooglePlayServicesUtil.a(packageInfo, true) != null;
        }
        boolean bl3 = bl2 = GooglePlayServicesUtil.a(packageInfo, false) != null;
        if (!bl2 && GooglePlayServicesUtil.a(packageInfo, true) != null) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Test-keys aren't accepted on this build.");
        }
        return bl2;
    }

    private static byte[] a(PackageInfo packageInfo, boolean bl2) {
        byte[] byArray;
        if (packageInfo.signatures.length != 1) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Package has more than one signature.");
            return null;
        }
        Set<byte[]> set = bl2 ? b.gu() : b.gv();
        if (set.contains(byArray = packageInfo.signatures[0].toByteArray())) {
            return byArray;
        }
        if (Log.isLoggable((String)"GooglePlayServicesUtil", (int)2)) {
            Log.v((String)"GooglePlayServicesUtil", (String)("Signature not valid.  Found: \n" + Base64.encodeToString((byte[])byArray, (int)0)));
        }
        return null;
    }

    private static byte[] a(PackageInfo packageInfo, byte[] ... byArray) {
        if (packageInfo.signatures.length != 1) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Package has more than one signature.");
            return null;
        }
        byte[] byArray2 = packageInfo.signatures[0].toByteArray();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte[] byArray3 = byArray[i2];
            if (!Arrays.equals(byArray3, byArray2)) continue;
            return byArray3;
        }
        if (Log.isLoggable((String)"GooglePlayServicesUtil", (int)2)) {
            Log.v((String)"GooglePlayServicesUtil", (String)("Signature not valid.  Found: \n" + Base64.encodeToString((byte[])byArray2, (int)0)));
        }
        return null;
    }

    public static Intent aj(int n2) {
        switch (n2) {
            case 1: 
            case 2: {
                return jo.ba(GOOGLE_PLAY_SERVICES_PACKAGE);
            }
            case 42: {
                return jo.hE();
            }
            case 3: {
                return jo.aY(GOOGLE_PLAY_SERVICES_PACKAGE);
            }
        }
        return null;
    }

    public static boolean gw() {
        if (Jg) {
            return Jh;
        }
        return "user".equals(Build.TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean b(PackageManager packageManager) {
        Object object = Jj;
        synchronized (object) {
            if (Ji == -1) {
                try {
                    PackageInfo packageInfo = packageManager.getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
                    Ji = GooglePlayServicesUtil.a(packageInfo, new byte[][]{b.Jc[1]}) != null ? 1 : 0;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    Ji = 0;
                }
            }
        }
        return Ji != 0;
    }

    public static boolean c(PackageManager packageManager) {
        return GooglePlayServicesUtil.b(packageManager) || !GooglePlayServicesUtil.gw();
    }

    public static String b(Context context, int n2) {
        String string2;
        Resources resources = context.getResources();
        switch (n2) {
            case 1: {
                String string3 = GooglePlayServicesUtil.a(context.getResources()) ? resources.getString(R.string.common_google_play_services_install_text_tablet) : resources.getString(R.string.common_google_play_services_install_text_phone);
                string2 = string3;
                break;
            }
            case 3: {
                string2 = resources.getString(R.string.common_google_play_services_enable_text);
                break;
            }
            case 2: {
                string2 = resources.getString(R.string.common_google_play_services_update_text);
                break;
            }
            case 42: {
                string2 = resources.getString(R.string.common_android_wear_update_text);
                break;
            }
            case 9: {
                string2 = resources.getString(R.string.common_google_play_services_unsupported_text);
                break;
            }
            case 7: {
                string2 = resources.getString(R.string.common_google_play_services_network_error_text);
                break;
            }
            case 5: {
                string2 = resources.getString(R.string.common_google_play_services_invalid_account_text);
                break;
            }
            default: {
                string2 = resources.getString(R.string.common_google_play_services_unknown_issue);
            }
        }
        return string2;
    }

    public static String c(Context context, int n2) {
        String string2;
        Resources resources = context.getResources();
        switch (n2) {
            case 1: {
                string2 = resources.getString(R.string.common_google_play_services_install_button);
                break;
            }
            case 3: {
                string2 = resources.getString(R.string.common_google_play_services_enable_button);
                break;
            }
            case 2: 
            case 42: {
                string2 = resources.getString(R.string.common_google_play_services_update_button);
                break;
            }
            default: {
                string2 = resources.getString(17039370);
            }
        }
        return string2;
    }

    private static int ak(int n2) {
        switch (n2) {
            case 1: 
            case 3: {
                return 10436;
            }
        }
        return 39789;
    }

    public static String d(Context context, int n2) {
        String string2;
        Resources resources = context.getResources();
        switch (n2) {
            case 1: {
                string2 = resources.getString(R.string.common_google_play_services_notification_needs_installation_title);
                break;
            }
            case 2: {
                string2 = resources.getString(R.string.common_google_play_services_notification_needs_update_title);
                break;
            }
            case 42: {
                string2 = resources.getString(R.string.common_android_wear_notification_needs_update_text);
                break;
            }
            case 3: {
                string2 = resources.getString(R.string.common_google_play_services_needs_enabling_title);
                break;
            }
            case 9: {
                string2 = resources.getString(R.string.common_google_play_services_unsupported_text);
                break;
            }
            case 7: {
                string2 = resources.getString(R.string.common_google_play_services_network_error_text);
                break;
            }
            case 5: {
                string2 = resources.getString(R.string.common_google_play_services_invalid_account_text);
                break;
            }
            default: {
                string2 = resources.getString(R.string.common_google_play_services_unknown_issue);
            }
        }
        return string2;
    }

    public static PendingIntent getErrorPendingIntent(int errorCode, Context context, int requestCode) {
        Intent intent = GooglePlayServicesUtil.aj(errorCode);
        if (intent == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)context, (int)requestCode, (Intent)intent, (int)0x10000000);
    }

    public static Dialog getErrorDialog(int errorCode, Activity activity, int requestCode) {
        return GooglePlayServicesUtil.getErrorDialog(errorCode, activity, requestCode, null);
    }

    public static Dialog getErrorDialog(int errorCode, Activity activity, int requestCode, DialogInterface.OnCancelListener cancelListener) {
        return GooglePlayServicesUtil.a(errorCode, activity, null, requestCode, cancelListener);
    }

    private static Dialog a(int n2, Activity activity, Fragment fragment, int n3, DialogInterface.OnCancelListener onCancelListener) {
        Object object;
        TypedValue typedValue;
        if (lc.K((Context)activity) && n2 == 2) {
            n2 = 42;
        }
        AlertDialog.Builder builder = null;
        if (ll.ij()) {
            typedValue = new TypedValue();
            activity.getTheme().resolveAttribute(16843529, typedValue, true);
            object = activity.getResources().getResourceEntryName(typedValue.resourceId);
            if ("Theme.Dialog.Alert".equals(object)) {
                builder = new AlertDialog.Builder((Context)activity, 5);
            }
        }
        if (builder == null) {
            builder = new AlertDialog.Builder((Context)activity);
        }
        builder.setMessage((CharSequence)GooglePlayServicesUtil.b((Context)activity, n2));
        if (onCancelListener != null) {
            builder.setOnCancelListener(onCancelListener);
        }
        typedValue = GooglePlayServicesUtil.aj(n2);
        object = fragment == null ? new jh(activity, (Intent)typedValue, n3) : new jh(fragment, (Intent)typedValue, n3);
        String string2 = GooglePlayServicesUtil.c((Context)activity, n2);
        if (string2 != null) {
            builder.setPositiveButton((CharSequence)string2, (DialogInterface.OnClickListener)object);
        }
        switch (n2) {
            case 0: {
                return null;
            }
            case 4: 
            case 6: {
                return builder.create();
            }
            case 1: {
                return builder.setTitle(R.string.common_google_play_services_install_title).create();
            }
            case 3: {
                return builder.setTitle(R.string.common_google_play_services_enable_title).create();
            }
            case 2: {
                return builder.setTitle(R.string.common_google_play_services_update_title).create();
            }
            case 42: {
                return builder.setTitle(R.string.common_android_wear_update_title).create();
            }
            case 9: {
                Log.e((String)"GooglePlayServicesUtil", (String)"Google Play services is invalid. Cannot recover.");
                return builder.setTitle(R.string.common_google_play_services_unsupported_title).create();
            }
            case 7: {
                Log.e((String)"GooglePlayServicesUtil", (String)"Network error occurred. Please retry request later.");
                return builder.setTitle(R.string.common_google_play_services_network_error_title).create();
            }
            case 8: {
                Log.e((String)"GooglePlayServicesUtil", (String)"Internal error occurred. Please see logs for detailed information");
                return builder.create();
            }
            case 10: {
                Log.e((String)"GooglePlayServicesUtil", (String)"Developer error occurred. Please see logs for detailed information");
                return builder.create();
            }
            case 5: {
                Log.e((String)"GooglePlayServicesUtil", (String)"An invalid account was specified when connecting. Please provide a valid account.");
                return builder.setTitle(R.string.common_google_play_services_invalid_account_title).create();
            }
            case 11: {
                Log.e((String)"GooglePlayServicesUtil", (String)"The application is not licensed to the user.");
                return builder.create();
            }
        }
        Log.e((String)"GooglePlayServicesUtil", (String)("Unexpected error code " + n2));
        return builder.create();
    }

    public static boolean showErrorDialogFragment(int errorCode, Activity activity, int requestCode, DialogInterface.OnCancelListener cancelListener) {
        return GooglePlayServicesUtil.showErrorDialogFragment(errorCode, activity, null, requestCode, cancelListener);
    }

    public static boolean showErrorDialogFragment(int errorCode, Activity activity, Fragment fragment, int requestCode, DialogInterface.OnCancelListener cancelListener) {
        boolean bl2;
        Dialog dialog = GooglePlayServicesUtil.a(errorCode, activity, fragment, requestCode, cancelListener);
        if (dialog == null) {
            return false;
        }
        try {
            bl2 = activity instanceof FragmentActivity;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            bl2 = false;
        }
        if (bl2) {
            FragmentManager fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            SupportErrorDialogFragment supportErrorDialogFragment = SupportErrorDialogFragment.newInstance(dialog, cancelListener);
            supportErrorDialogFragment.show(fragmentManager, GMS_ERROR_DIALOG);
        } else if (ll.ig()) {
            android.app.FragmentManager fragmentManager = activity.getFragmentManager();
            ErrorDialogFragment errorDialogFragment = ErrorDialogFragment.newInstance(dialog, cancelListener);
            errorDialogFragment.show(fragmentManager, GMS_ERROR_DIALOG);
        } else {
            throw new RuntimeException("This Activity does not support Fragments.");
        }
        return true;
    }

    public static void showErrorNotification(int errorCode, Context context) {
        if (lc.K(context) && errorCode == 2) {
            errorCode = 42;
        }
        if (GooglePlayServicesUtil.e(context, errorCode)) {
            GooglePlayServicesUtil.E(context);
        } else {
            GooglePlayServicesUtil.a(errorCode, context);
        }
    }

    private static void E(Context context) {
        a a2 = new a(context);
        a2.sendMessageDelayed(a2.obtainMessage(1), 120000L);
    }

    private static void a(int n2, Context context) {
        Notification notification;
        String string2;
        Resources resources = context.getResources();
        String string3 = GooglePlayServicesUtil.d(context, n2);
        String string4 = resources.getString(R.string.common_google_play_services_error_notification_requested_by_msg, new Object[]{GooglePlayServicesUtil.F(context)});
        PendingIntent pendingIntent = GooglePlayServicesUtil.getErrorPendingIntent(n2, context, 0);
        if (lc.K(context)) {
            jx.K(ll.ik());
            string2 = new Notification.Builder(context).setSmallIcon(R.drawable.common_ic_googleplayservices).setPriority(2).setAutoCancel(true).setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)(string3 + " " + string4))).addAction(R.drawable.common_full_open_on_phone, (CharSequence)resources.getString(R.string.common_open_on_phone), pendingIntent);
            notification = string2.build();
        } else {
            string2 = resources.getString(R.string.common_google_play_services_notification_ticker);
            notification = new Notification(17301642, (CharSequence)string2, System.currentTimeMillis());
            notification.flags |= 0x10;
            notification.setLatestEventInfo(context, (CharSequence)string3, (CharSequence)string4, pendingIntent);
        }
        string2 = (NotificationManager)context.getSystemService("notification");
        string2.notify(GooglePlayServicesUtil.ak(n2), notification);
    }

    public static boolean showErrorDialogFragment(int errorCode, Activity activity, int requestCode) {
        return GooglePlayServicesUtil.showErrorDialogFragment(errorCode, activity, requestCode, null);
    }

    public static boolean isUserRecoverableError(int errorCode) {
        switch (errorCode) {
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOpenSourceSoftwareLicenseInfo(Context context) {
        String string2;
        block9: {
            Uri uri = new Uri.Builder().scheme("android.resource").authority(GOOGLE_PLAY_SERVICES_PACKAGE).appendPath("raw").appendPath("oss_notice").build();
            InputStream inputStream = context.getContentResolver().openInputStream(uri);
            try {
                string2 = new Scanner(inputStream).useDelimiter("\\A").next();
                if (inputStream == null) break block9;
            }
            catch (NoSuchElementException noSuchElementException) {
                String string3;
                block10: {
                    try {
                        string3 = null;
                        if (inputStream == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            throw throwable;
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                    inputStream.close();
                }
                return string3;
            }
            inputStream.close();
        }
        return string2;
    }

    public static boolean a(Resources resources) {
        if (resources == null) {
            return false;
        }
        boolean bl2 = (resources.getConfiguration().screenLayout & 0xF) > 3;
        return ll.ig() && bl2 || GooglePlayServicesUtil.b(resources);
    }

    private static boolean b(Resources resources) {
        Configuration configuration = resources.getConfiguration();
        if (ll.ii()) {
            return (configuration.screenLayout & 0xF) <= 3 && configuration.smallestScreenWidthDp >= 600;
        }
        return false;
    }

    public static Resources getRemoteResource(Context context) {
        try {
            return context.getPackageManager().getResourcesForApplication(GOOGLE_PLAY_SERVICES_PACKAGE);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static Context getRemoteContext(Context context) {
        try {
            return context.createPackageContext(GOOGLE_PLAY_SERVICES_PACKAGE, 3);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static String F(Context context) {
        String string2 = context.getApplicationInfo().name;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            ApplicationInfo applicationInfo;
            string2 = context.getPackageName();
            PackageManager packageManager = context.getApplicationContext().getPackageManager();
            try {
                applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                applicationInfo = null;
            }
            if (applicationInfo != null) {
                string2 = packageManager.getApplicationLabel(applicationInfo).toString();
            }
        }
        return string2;
    }

    public static boolean e(Context context, int n2) {
        if (n2 == 1) {
            PackageManager packageManager = context.getPackageManager();
            try {
                if (packageManager.getApplicationInfo((String)GOOGLE_PLAY_SERVICES_PACKAGE, (int)8192).enabled) {
                    return true;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    private static class a
    extends Handler {
        private final Context mO;

        a(Context context) {
            super(Looper.myLooper() == null ? Looper.getMainLooper() : Looper.myLooper());
            this.mO = context.getApplicationContext();
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mO);
                    if (!GooglePlayServicesUtil.isUserRecoverableError(n2)) break;
                    GooglePlayServicesUtil.a(n2, this.mO);
                    break;
                }
                default: {
                    Log.w((String)"GooglePlayServicesUtil", (String)("Don't know how to handle this message: " + msg.what));
                }
            }
        }
    }
}

