/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.internal.zabv;
import com.google.android.gms.common.internal.Preconditions;

@KeepForSdk
public final class ListenerHolder<L> {
    private final zabv zaa;
    @Nullable
    private volatile L zab;
    @Nullable
    private volatile ListenerKey<L> zac;

    @KeepForSdk
    ListenerHolder(@NonNull Looper object, @NonNull L l, @NonNull String string2) {
        zabv zabv2;
        this.zaa = zabv2 = new zabv(this, (Looper)object);
        this.zab = Preconditions.checkNotNull(l, (Object)"Listener must not be null");
        super(l, Preconditions.checkNotEmpty((String)string2));
        this.zac = object;
    }

    @KeepForSdk
    public void notifyListener(@RecentlyNonNull Notifier<? super L> message) {
        Preconditions.checkNotNull(message, (Object)"Notifier must not be null");
        zabv zabv2 = this.zaa;
        message = zabv2.obtainMessage(1, message);
        this.zaa.sendMessage(message);
    }

    @KeepForSdk
    public boolean hasListener() {
        return this.zab != null;
    }

    @KeepForSdk
    public void clear() {
        this.zab = null;
        this.zac = null;
    }

    @RecentlyNullable
    @KeepForSdk
    public ListenerKey<L> getListenerKey() {
        return this.zac;
    }

    @KeepForSdk
    void notifyListenerInternal(Notifier<? super L> notifier) {
        ListenerHolder<L> listenerHolder = listenerHolder.zab;
        if (listenerHolder == null) {
            notifier.onNotifyListenerFailed();
            return;
        }
        try {
            notifier.notifyListener(listenerHolder);
        }
        catch (RuntimeException runtimeException) {
            notifier.onNotifyListenerFailed();
            throw runtimeException;
        }
    }

    @KeepForSdk
    public static final class ListenerKey<L> {
        private final L zaa;
        private final String zab;

        @KeepForSdk
        ListenerKey(L l, String string2) {
            this.zaa = l;
            this.zab = string2;
        }

        @KeepForSdk
        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ListenerKey)) {
                return false;
            }
            object = (ListenerKey)object;
            return this.zaa == ((ListenerKey)object).zaa && this.zab.equals(((ListenerKey)object).zab);
        }

        @KeepForSdk
        public int hashCode() {
            return System.identityHashCode(this.zaa) * 31 + this.zab.hashCode();
        }
    }

    @KeepForSdk
    public static interface Notifier<L> {
        @KeepForSdk
        public void notifyListener(@RecentlyNonNull L var1);

        @KeepForSdk
        public void onNotifyListenerFailed();
    }
}

