/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zacv;
import com.google.android.gms.common.api.internal.zacw;
import com.google.android.gms.common.api.internal.zaq;
import com.google.android.gms.common.api.internal.zar;
import com.google.android.gms.common.internal.ICancelToken;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.base.zap;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

@KeepName
@KeepForSdk
public abstract class BasePendingResult<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> zaa;
    private final Object zae;
    @RecentlyNonNull
    protected final CallbackHandler<R> zab;
    @RecentlyNonNull
    protected final WeakReference<GoogleApiClient> zac;
    private final CountDownLatch zaf;
    private final ArrayList<PendingResult.StatusListener> zag;
    @Nullable
    private ResultCallback<? super R> zah;
    private final AtomicReference<zacw> zai;
    @Nullable
    private R zaj;
    private Status zak;
    @KeepName
    private zar mResultGuardian;
    private volatile boolean zal;
    private boolean zam;
    private boolean zan;
    @Nullable
    private ICancelToken zao;
    private volatile zacv<R> zap;
    private boolean zaq;
    public static final /* synthetic */ int zad;

    @Deprecated
    BasePendingResult() {
        Object object = new Object();
        this.zae = object;
        object = new Object(1);
        this.zaf = object;
        object = new Object();
        this.zag = object;
        this.zai = object;
        this.zaq = false;
        super(Looper.getMainLooper());
        this.zab = object;
        super(null);
        this.zac = object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    protected BasePendingResult(@Nullable GoogleApiClient googleApiClient) {
        void var2_7;
        CountDownLatch countDownLatch;
        Object object;
        this.zae = object = new Object();
        this.zaf = countDownLatch = new CountDownLatch(1);
        ArrayList arrayList = new ArrayList();
        this.zag = arrayList;
        AtomicReference atomicReference = new AtomicReference();
        this.zai = atomicReference;
        this.zaq = false;
        if (googleApiClient != null) {
            Looper looper = googleApiClient.getLooper();
        } else {
            Looper looper = Looper.getMainLooper();
        }
        CallbackHandler callbackHandler = new CallbackHandler((Looper)var2_7);
        this.zab = callbackHandler;
        WeakReference<GoogleApiClient> weakReference = new WeakReference<GoogleApiClient>(googleApiClient);
        this.zac = weakReference;
    }

    @Deprecated
    @KeepForSdk
    protected BasePendingResult(@RecentlyNonNull Looper object) {
        Object object2 = new Object();
        this.zae = object2;
        object2 = new Object(1);
        this.zaf = object2;
        object2 = new Object();
        this.zag = object2;
        this.zai = object2;
        this.zaq = false;
        super((Looper)object);
        this.zab = object2;
        super(null);
        this.zac = object;
    }

    @VisibleForTesting
    @KeepForSdk
    protected BasePendingResult(@RecentlyNonNull CallbackHandler<R> object) {
        Serializable serializable = new Serializable();
        this.zae = serializable;
        serializable = new Serializable(1);
        this.zaf = serializable;
        serializable = new Serializable();
        this.zag = serializable;
        this.zai = serializable;
        this.zaq = false;
        this.zab = (CallbackHandler)((Object)Preconditions.checkNotNull(object, (Object)"CallbackHandler must not be null"));
        super(null);
        this.zac = object;
    }

    @KeepForSdk
    public final boolean isReady() {
        return this.zaf.getCount() == 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RecentlyNonNull
    public final R await() {
        Preconditions.checkNotMainThread((String)"await must not be called on the UI thread");
        Preconditions.checkState((boolean)(this.zal ^ true), (Object)"Result has already been consumed");
        boolean bl = this.zap == null;
        Preconditions.checkState((boolean)bl, (Object)"Cannot await if then() has been called.");
        try {
            this.zaf.await();
        }
        catch (InterruptedException interruptedException) {
            this.forceFailureUnlessReady(Status.RESULT_INTERRUPTED);
        }
        Preconditions.checkState((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.zaa();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RecentlyNonNull
    public final R await(long l, @RecentlyNonNull TimeUnit timeUnit) {
        if (l > 0L) {
            Preconditions.checkNotMainThread((String)"await must not be called on the UI thread when time is greater than zero.");
        }
        Preconditions.checkState((boolean)(this.zal ^ true), (Object)"Result has already been consumed.");
        boolean bl = this.zap == null;
        Preconditions.checkState((boolean)bl, (Object)"Cannot await if then() has been called.");
        try {
            boolean bl2 = this.zaf.await(l, timeUnit);
            if (!bl2) {
                this.forceFailureUnlessReady(Status.RESULT_TIMEOUT);
            }
        }
        catch (InterruptedException interruptedException) {
            this.forceFailureUnlessReady(Status.RESULT_INTERRUPTED);
        }
        Preconditions.checkState((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.zaa();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @KeepForSdk
    public final void setResultCallback(@Nullable ResultCallback<? super R> var1_2) {
        var3_3 = this.zae;
        synchronized (var3_3) {
            if (var1_2 != null) ** GOTO lbl7
            this.zah = null;
            return;
lbl7:
            // 1 sources

            var2_4 = this.zal;
            {
                catch (Throwable var0_1) {}
                {
                    throw var0_1;
                }
            }
            {
                var4_7 = "Result has already been consumed.";
                Preconditions.checkState((boolean)(var2_4 ^= true), (Object)var4_7);
                var2_5 = this.zap;
                var2_6 = var2_5 == null;
                Preconditions.checkState((boolean)var2_6, (Object)"Cannot set callbacks if then() has been called.");
                var2_6 = this.isCanceled();
                if (var2_6) {
                    return;
                }
                var2_6 = this.isReady();
                if (var2_6) {
                    this.zab.zaa(var1_2, (R)this.zaa());
                } else {
                    this.zah = var1_2;
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @KeepForSdk
    public final void setResultCallback(@RecentlyNonNull ResultCallback<? super R> var1_2, long var2_3, @RecentlyNonNull TimeUnit var4_4) {
        var6_5 = this.zae;
        synchronized (var6_5) {
            if (var1_2 /* !! */  != null) ** GOTO lbl7
            this.zah = null;
            return;
lbl7:
            // 1 sources

            var5_6 = this.zal;
            {
                catch (Throwable var0_1) {}
                {
                    throw var0_1;
                }
            }
            {
                var7_9 = "Result has already been consumed.";
                Preconditions.checkState((boolean)(var5_6 ^= true), (Object)var7_9);
                var5_7 = this.zap;
                var5_8 = var5_7 == null;
                Preconditions.checkState((boolean)var5_8, (Object)"Cannot set callbacks if then() has been called.");
                var5_8 = this.isCanceled();
                if (var5_8) {
                    return;
                }
                var5_8 = this.isReady();
                if (var5_8) {
                    this.zab.zaa(var1_2 /* !! */ , (R)this.zaa());
                } else {
                    this.zah = var1_2 /* !! */ ;
                    var1_2 /* !! */  = this.zab;
                    var8_10 = var4_4.toMillis(var2_3);
                    var1_2 /* !! */ .sendMessageDelayed(var1_2 /* !! */ .obtainMessage(2, (Object)this), var8_10);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void addStatusListener(@RecentlyNonNull PendingResult.StatusListener statusListener) {
        boolean bl = statusListener != null;
        Preconditions.checkArgument((boolean)bl, (Object)"Callback cannot be null.");
        Object object = this.zae;
        synchronized (object) {
            boolean bl2 = this.isReady();
            if (bl2) {
                statusListener.onComplete(this.zak);
            } else {
                this.zag.add(statusListener);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @KeepForSdk
    public void cancel() {
        Object object = this.zae;
        synchronized (object) {
            boolean bl = this.zam;
            if (bl || (bl = this.zal)) {
                return;
            }
            ICancelToken iCancelToken = this.zao;
            if (iCancelToken != null) {
                try {
                    iCancelToken.cancel();
                }
                catch (RemoteException remoteException) {}
            }
            BasePendingResult.zal(this.zaj);
            this.zam = true;
            this.zab(this.createFailedResult(Status.RESULT_CANCELED));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean isCanceled() {
        Object object = this.zae;
        synchronized (object) {
            return this.zam;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RecentlyNonNull
    public final <S extends Result> TransformedResult<S> then(@RecentlyNonNull ResultTransform<? super R, ? extends S> object) {
        Preconditions.checkState((boolean)(this.zal ^ true), (Object)"Result has already been consumed.");
        Object object2 = this.zae;
        synchronized (object2) {
            zacv<R> zacv2 = this.zap;
            boolean bl = zacv2 == null;
            Preconditions.checkState((boolean)bl, (Object)"Cannot call then() twice.");
            ResultCallback<? super R> resultCallback = this.zah;
            boolean bl2 = resultCallback == null;
            Preconditions.checkState((boolean)bl2, (Object)"Cannot call then() if callbacks are set.");
            bl2 = this.zam;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
            {
                Preconditions.checkState((boolean)(bl2 ^= true), (Object)"Cannot call then() if result was canceled.");
                this.zaq = true;
                zacv zacv3 = new zacv(this.zac);
                this.zap = zacv3;
                object = this.zap.then(object);
                boolean bl3 = this.isReady();
                if (bl3) {
                    this.zab.zaa(this.zap, this.zaa());
                } else {
                    zacv<? super R> zacv4 = this.zap;
                    this.zah = zacv4;
                }
                return object;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public final void setResult(@RecentlyNonNull R r) {
        Object object = this.zae;
        synchronized (object) {
            boolean bl = this.zan;
            if (!bl && !(bl = this.zam)) {
                this.isReady();
                bl = this.isReady();
                String string2 = "Results have already been set";
                Preconditions.checkState((boolean)(bl ^= true), (Object)string2);
                bl = this.zal;
                Preconditions.checkState((boolean)(bl ^= true), (Object)"Result has already been consumed");
                this.zab(r);
                return;
            }
            BasePendingResult.zal(r);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    @KeepForSdk
    public final void forceFailureUnlessReady(@RecentlyNonNull Status status) {
        Object object = this.zae;
        synchronized (object) {
            boolean bl = this.isReady();
            if (bl) return;
            this.setResult(this.createFailedResult(status));
            this.zan = true;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @NonNull
    @KeepForSdk
    protected abstract R createFailedResult(@RecentlyNonNull Status var1);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    protected final void setCancelToken(@RecentlyNonNull ICancelToken iCancelToken) {
        Object object = this.zae;
        synchronized (object) {
            this.zao = iCancelToken;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    static {
        zaq zaq2;
        zaa = zaq2 = new zaq();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean zaj() {
        Object object = this.zae;
        synchronized (object) {
            GoogleApiClient googleApiClient = (GoogleApiClient)this.zac.get();
            if (googleApiClient != null) {
                boolean bl = this.zaq;
                if (bl) return this.isCanceled();
            }
            this.cancel();
            return this.isCanceled();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zak() {
        boolean bl = !this.zaq ? zaa.get().booleanValue() : true;
        this.zaq = bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final R zaa() {
        R r;
        Object object = this.zae;
        synchronized (object) {
            boolean bl = this.zal;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
            {
                String string2 = "Result has already been consumed.";
                Preconditions.checkState((boolean)(bl ^= true), (Object)string2);
                Preconditions.checkState((boolean)this.isReady(), (Object)"Result is not ready.");
                r = this.zaj;
                this.zaj = null;
                this.zah = null;
                this.zal = true;
            }
        }
        object = this.zai.getAndSet(null);
        if (object == null) return (R)((Result)Preconditions.checkNotNull(r));
        ((zacw)object).zaa.zab.remove(this);
        return (R)((Result)Preconditions.checkNotNull(r));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final void zab(R object) {
        this.zaj = object;
        this.zak = object.getStatus();
        this.zao = null;
        this.zaf.countDown();
        if (this.zam) {
            this.zah = null;
        } else {
            ResultCallback<? super R> resultCallback = this.zah;
            if (resultCallback == null) {
                if (this.zaj instanceof Releasable) {
                    zar zar2;
                    this.mResultGuardian = zar2 = new zar(this, null);
                }
            } else {
                this.zab.removeMessages(2);
                this.zab.zaa(resultCallback, (R)this.zaa());
            }
        }
        ArrayList<PendingResult.StatusListener> arrayList = this.zag;
        int n = arrayList.size();
        boolean bl = false;
        while (true) {
            void var1_4;
            if (var1_4 >= n) {
                this.zag.clear();
                return;
            }
            ((PendingResult.StatusListener)arrayList.get((int)var1_4)).onComplete(this.zak);
            ++var1_4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void zal(@Nullable Result object) {
        if (!(object instanceof Releasable)) return;
        try {
            ((Releasable)object).release();
            return;
        }
        catch (RuntimeException runtimeException) {
            String string2 = String.valueOf(object);
            String string3 = String.valueOf(string2);
            int n = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n + 18);
            stringBuilder.append("Unable to release ");
            stringBuilder.append(string2);
            Log.w((String)"BasePendingResult", (String)stringBuilder.toString(), (Throwable)runtimeException);
            return;
        }
    }

    static /* synthetic */ Result zam(BasePendingResult basePendingResult) {
        return basePendingResult.zaj;
    }

    public final void zan(@Nullable zacw zacw2) {
        this.zai.set(zacw2);
    }

    @VisibleForTesting
    public static class CallbackHandler<R extends Result>
    extends zap {
        public CallbackHandler() {
            super(Looper.getMainLooper());
        }

        public CallbackHandler(@RecentlyNonNull Looper looper) {
            super(looper);
        }

        public final void handleMessage(@RecentlyNonNull Message object) {
            switch (((Message)object).what) {
                case 2: {
                    ((BasePendingResult)((Message)object).obj).forceFailureUnlessReady(Status.RESULT_TIMEOUT);
                    return;
                }
                case 1: {
                    CallbackHandler callbackHandler = (Pair)((Message)object).obj;
                    object = (ResultCallback)((Pair)callbackHandler).first;
                    callbackHandler = (Result)((Pair)callbackHandler).second;
                    try {
                        object.onResult((Result)callbackHandler);
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        BasePendingResult.zal((Result)callbackHandler);
                        throw runtimeException;
                    }
                }
            }
            int n = ((Message)object).what;
            object = new StringBuilder(45);
            ((StringBuilder)object).append("Don't know how to handle message: ");
            ((StringBuilder)object).append(n);
            String string2 = ((StringBuilder)object).toString();
            object = new Exception();
            Log.wtf((String)"BasePendingResult", (String)string2, (Throwable)object);
        }

        public final void zaa(@RecentlyNonNull ResultCallback<? super R> object, @RecentlyNonNull R r) {
            object = Preconditions.checkNotNull(object);
            Pair pair = new Pair(object, r);
            this.sendMessage(this.obtainMessage(1, pair));
        }
    }
}

