/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import androidx.collection.ArraySet;
import com.google.android.gms.auth.api.signin.zaa;
import com.google.android.gms.auth.api.signin.zab;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="GoogleSignInAccountCreator")
public class GoogleSignInAccount
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<GoogleSignInAccount> CREATOR;
    @VisibleForTesting
    @RecentlyNonNull
    public static Clock zaa;
    @SafeParcelable.VersionField(id=1)
    final int zab;
    @Nullable
    @SafeParcelable.Field(id=2, getter="getId")
    private String zad;
    @Nullable
    @SafeParcelable.Field(id=3, getter="getIdToken")
    private String zae;
    @Nullable
    @SafeParcelable.Field(id=4, getter="getEmail")
    private String zaf;
    @Nullable
    @SafeParcelable.Field(id=5, getter="getDisplayName")
    private String zag;
    @Nullable
    @SafeParcelable.Field(id=6, getter="getPhotoUrl")
    private Uri zah;
    @Nullable
    @SafeParcelable.Field(id=7, getter="getServerAuthCode")
    private String zai;
    @SafeParcelable.Field(id=8, getter="getExpirationTimeSecs")
    private long zaj;
    @SafeParcelable.Field(id=9, getter="getObfuscatedIdentifier")
    private String zak;
    @SafeParcelable.Field(id=10)
    List<Scope> zac;
    @Nullable
    @SafeParcelable.Field(id=11, getter="getGivenName")
    private String zal;
    @Nullable
    @SafeParcelable.Field(id=12, getter="getFamilyName")
    private String zam;
    private Set<Scope> zan;

    @KeepForSdk
    @RecentlyNonNull
    public static GoogleSignInAccount fromAccount(@RecentlyNonNull Account account) {
        ArraySet arraySet = new ArraySet();
        return GoogleSignInAccount.zae(account, (Set<Scope>)arraySet);
    }

    @KeepForSdk
    @RecentlyNonNull
    public static GoogleSignInAccount createDefault() {
        Account account = new Account("<<default account>>", "com.google");
        HashSet<Scope> hashSet = new HashSet<Scope>();
        return GoogleSignInAccount.zae(account, hashSet);
    }

    @SafeParcelable.Constructor
    GoogleSignInAccount(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) @Nullable String string, @SafeParcelable.Param(id=3) @Nullable String string2, @SafeParcelable.Param(id=4) @Nullable String string3, @SafeParcelable.Param(id=5) @Nullable String string4, @SafeParcelable.Param(id=6) @Nullable Uri uri, @SafeParcelable.Param(id=7) @Nullable String string5, @SafeParcelable.Param(id=8) long l, @SafeParcelable.Param(id=9) String string6, @SafeParcelable.Param(id=10) List<Scope> list, @SafeParcelable.Param(id=11) @Nullable String string7, @SafeParcelable.Param(id=12) @Nullable String string8) {
        HashSet<Scope> hashSet = new HashSet<Scope>();
        this.zan = hashSet;
        this.zab = n;
        this.zad = string;
        this.zae = string2;
        this.zaf = string3;
        this.zag = string4;
        this.zah = uri;
        this.zai = string5;
        this.zaj = l;
        this.zak = string6;
        this.zac = list;
        this.zal = string7;
        this.zam = string8;
    }

    @RecentlyNullable
    public String getId() {
        return this.zad;
    }

    @RecentlyNullable
    public String getIdToken() {
        return this.zae;
    }

    @RecentlyNullable
    public String getEmail() {
        return this.zaf;
    }

    @RecentlyNullable
    public Account getAccount() {
        Object object = object.zaf;
        if (object == null) {
            return null;
        }
        Account account = new Account((String)object, "com.google");
        return account;
    }

    @RecentlyNullable
    public String getDisplayName() {
        return this.zag;
    }

    @RecentlyNullable
    public String getGivenName() {
        return this.zal;
    }

    @RecentlyNullable
    public String getFamilyName() {
        return this.zam;
    }

    @RecentlyNullable
    public Uri getPhotoUrl() {
        return this.zah;
    }

    @KeepForSdk
    @RecentlyNonNull
    public GoogleSignInAccount requestExtraScopes(Scope ... scopeArray) {
        if (scopeArray != null) {
            Collections.addAll(this.zan, scopeArray);
        }
        return this;
    }

    @RecentlyNullable
    public String getServerAuthCode() {
        return this.zai;
    }

    @KeepForSdk
    public boolean isExpired() {
        return zaa.currentTimeMillis() / 1000L >= this.zaj + -300L;
    }

    @NonNull
    public Set<Scope> getGrantedScopes() {
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zac);
        return hashSet;
    }

    @NonNull
    @KeepForSdk
    public Set<Scope> getRequestedScopes() {
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zac);
        hashSet.addAll(this.zan);
        return hashSet;
    }

    public void writeToParcel(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)1, (int)this.zab);
        SafeParcelWriter.writeString((Parcel)parcel, (int)2, (String)this.getId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)3, (String)this.getIdToken(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)4, (String)this.getEmail(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)5, (String)this.getDisplayName(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel, (int)6, (Parcelable)this.getPhotoUrl(), (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)7, (String)this.getServerAuthCode(), (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel, (int)8, (long)this.zaj);
        SafeParcelWriter.writeString((Parcel)parcel, (int)9, (String)this.zak, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel, (int)10, this.zac, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)11, (String)this.getGivenName(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)12, (String)this.getFamilyName(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n2);
    }

    public int hashCode() {
        return (this.zak.hashCode() + 527) * 31 + this.getRequestedScopes().hashCode();
    }

    public boolean equals(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof GoogleSignInAccount)) {
            return false;
        }
        object = (GoogleSignInAccount)((Object)object);
        return ((GoogleSignInAccount)((Object)object)).zak.equals(this.zak) && ((GoogleSignInAccount)((Object)object)).getRequestedScopes().equals(this.getRequestedScopes());
    }

    static {
        zab zab2;
        CREATOR = zab2 = new zab();
        zaa = DefaultClock.getInstance();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @RecentlyNullable
    public static GoogleSignInAccount zaa(@Nullable String string) throws JSONException {
        void var4_18;
        void var2_6;
        void var1_13;
        void var1_11;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string);
        string = !TextUtils.isEmpty((CharSequence)(string = jSONObject.optString("photoUrl"))) ? Uri.parse((String)string) : null;
        long l = Long.parseLong(jSONObject.getString("expirationTime"));
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("grantedScopes");
        int n = jSONArray.length();
        boolean bl = false;
        while (var1_11 < n) {
            Scope scope = new Scope(jSONArray.getString((int)var1_11));
            hashSet.add(scope);
            ++var1_11;
        }
        String string2 = jSONObject.optString("id");
        if (jSONObject.has("tokenId")) {
            String string3 = jSONObject.optString("tokenId");
        } else {
            Object var1_15 = null;
        }
        if (jSONObject.has("email")) {
            String string4 = jSONObject.optString("email");
        } else {
            Object var2_7 = null;
        }
        String string5 = jSONObject.has("displayName") ? jSONObject.optString("displayName") : null;
        if (jSONObject.has("givenName")) {
            String string6 = jSONObject.optString("givenName");
        } else {
            Object var4_19 = null;
        }
        String string7 = jSONObject.has("familyName") ? jSONObject.optString("familyName") : null;
        GoogleSignInAccount googleSignInAccount = GoogleSignInAccount.zab(string2, (String)var1_13, (String)var2_6, string5, (String)var4_18, string7, (Uri)string, l, jSONObject.getString("obfuscatedIdentifier"), hashSet);
        string = jSONObject.has("serverAuthCode") ? jSONObject.optString("serverAuthCode") : null;
        googleSignInAccount.zai = string;
        return googleSignInAccount;
    }

    @RecentlyNonNull
    public static GoogleSignInAccount zab(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable Uri uri, @Nullable Long object, @RecentlyNonNull String arrayList, @RecentlyNonNull Set<Scope> set) {
        long l = (Long)object;
        object = Preconditions.checkNotEmpty((String)((Object)arrayList));
        arrayList = new ArrayList<Scope>((Collection)Preconditions.checkNotNull(set));
        GoogleSignInAccount googleSignInAccount = new GoogleSignInAccount(3, string, string2, string3, string4, uri, null, l, (String)object, arrayList, string5, string6);
        return googleSignInAccount;
    }

    private static GoogleSignInAccount zae(Account account, Set<Scope> set) {
        return GoogleSignInAccount.zab(null, null, account.name, null, null, null, null, 0L, account.name, set);
    }

    @NonNull
    public final String zac() {
        return this.zak;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RecentlyNonNull
    public final String zad() {
        String string;
        JSONObject jSONObject = new JSONObject();
        try {
            string = ((GoogleSignInAccount)((Object)list)).getId();
            if (string != null) {
                jSONObject.put("id", (Object)((GoogleSignInAccount)((Object)list)).getId());
            }
            if ((string = ((GoogleSignInAccount)((Object)list)).getIdToken()) != null) {
                jSONObject.put("tokenId", (Object)((GoogleSignInAccount)((Object)list)).getIdToken());
            }
            if ((string = ((GoogleSignInAccount)((Object)list)).getEmail()) != null) {
                jSONObject.put("email", (Object)((GoogleSignInAccount)((Object)list)).getEmail());
            }
            if ((string = ((GoogleSignInAccount)((Object)list)).getDisplayName()) != null) {
                jSONObject.put("displayName", (Object)((GoogleSignInAccount)((Object)list)).getDisplayName());
            }
            if ((string = ((GoogleSignInAccount)((Object)list)).getGivenName()) != null) {
                jSONObject.put("givenName", (Object)((GoogleSignInAccount)((Object)list)).getGivenName());
            }
            if ((string = ((GoogleSignInAccount)((Object)list)).getFamilyName()) != null) {
                jSONObject.put("familyName", (Object)((GoogleSignInAccount)((Object)list)).getFamilyName());
            }
            if ((string = ((GoogleSignInAccount)((Object)list)).getPhotoUrl()) != null) {
                jSONObject.put("photoUrl", (Object)string.toString());
            }
            if ((string = ((GoogleSignInAccount)((Object)list)).getServerAuthCode()) != null) {
                jSONObject.put("serverAuthCode", (Object)((GoogleSignInAccount)((Object)list)).getServerAuthCode());
            }
            jSONObject.put("expirationTime", ((GoogleSignInAccount)((Object)list)).zaj);
            string = "obfuscatedIdentifier";
            Scope[] scopeArray = ((GoogleSignInAccount)((Object)list)).zak;
            jSONObject.put(string, (Object)scopeArray);
            string = new JSONArray();
            List<Scope> list = ((GoogleSignInAccount)((Object)list)).zac;
            scopeArray = list.toArray(new Scope[list.size()]);
            Arrays.sort(scopeArray, com.google.android.gms.auth.api.signin.zaa.zaa);
            int n = scopeArray.length;
            for (int i = 0; i < n; ++i) {
                string.put((Object)scopeArray[i].getScopeUri());
            }
        }
        catch (JSONException jSONException) {
            RuntimeException runtimeException = new RuntimeException(jSONException);
            throw runtimeException;
        }
        {
            jSONObject.put("grantedScopes", (Object)string);
        }
        jSONObject.remove("serverAuthCode");
        return jSONObject.toString();
    }
}

