/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.OnDelegateCreatedListener;
import com.google.android.gms.dynamic.zab;
import com.google.android.gms.dynamic.zac;
import com.google.android.gms.dynamic.zad;
import com.google.android.gms.dynamic.zae;
import com.google.android.gms.dynamic.zaf;
import com.google.android.gms.dynamic.zag;
import java.util.LinkedList;

@KeepForSdk
public abstract class DeferredLifecycleHelper<T extends LifecycleDelegate> {
    private T zaa;
    @Nullable
    private Bundle zab;
    private LinkedList<zaa> zac;
    private final OnDelegateCreatedListener<T> zad = new com.google.android.gms.dynamic.zaa(this);

    @KeepForSdk
    public DeferredLifecycleHelper() {
    }

    @KeepForSdk
    @RecentlyNonNull
    public T getDelegate() {
        return this.zaa;
    }

    private final void zaa(int n) {
        while (!this.zac.isEmpty() && this.zac.getLast().zaa() >= n) {
            this.zac.removeLast();
        }
    }

    private final void zaa(@Nullable Bundle bundle, zaa zaa2) {
        if (this.zaa != null) {
            zaa2.zaa((LifecycleDelegate)this.zaa);
            return;
        }
        if (this.zac == null) {
            this.zac = new LinkedList();
        }
        this.zac.add(zaa2);
        if (bundle != null) {
            if (this.zab == null) {
                this.zab = (Bundle)bundle.clone();
            } else {
                this.zab.putAll(bundle);
            }
        }
        this.createDelegate(this.zad);
    }

    @KeepForSdk
    protected abstract void createDelegate(@RecentlyNonNull OnDelegateCreatedListener<T> var1);

    @KeepForSdk
    public void onInflate(@RecentlyNonNull Activity activity, @RecentlyNonNull Bundle bundle, @RecentlyNonNull Bundle bundle2) {
        this.zaa(bundle2, new zac(this, activity, bundle, bundle2));
    }

    @KeepForSdk
    public void onCreate(@RecentlyNonNull Bundle bundle) {
        this.zaa(bundle, new zab(this, bundle));
    }

    @KeepForSdk
    @RecentlyNonNull
    public View onCreateView(@RecentlyNonNull LayoutInflater layoutInflater, @RecentlyNonNull ViewGroup viewGroup, @RecentlyNonNull Bundle bundle) {
        FrameLayout frameLayout = new FrameLayout(layoutInflater.getContext());
        this.zaa(bundle, new zae(this, frameLayout, layoutInflater, viewGroup, bundle));
        if (this.zaa == null) {
            this.handleGooglePlayUnavailable(frameLayout);
        }
        return frameLayout;
    }

    @KeepForSdk
    protected void handleGooglePlayUnavailable(@RecentlyNonNull FrameLayout frameLayout) {
        DeferredLifecycleHelper.showGooglePlayUnavailableMessage(frameLayout);
    }

    @KeepForSdk
    public static void showGooglePlayUnavailableMessage(@RecentlyNonNull FrameLayout frameLayout) {
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        FrameLayout frameLayout2 = frameLayout;
        Context context = frameLayout2.getContext();
        int n = googleApiAvailability.isGooglePlayServicesAvailable(context);
        String string2 = com.google.android.gms.common.internal.zac.zac(context, n);
        String string3 = com.google.android.gms.common.internal.zac.zae(context, n);
        LinearLayout linearLayout = new LinearLayout(frameLayout2.getContext());
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        frameLayout2.addView((View)linearLayout);
        TextView textView = new TextView(frameLayout2.getContext());
        textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        textView.setText((CharSequence)string2);
        linearLayout.addView((View)textView);
        Intent intent = googleApiAvailability.getErrorResolutionIntent(context, n, null);
        if (intent != null) {
            Button button = new Button(context);
            button.setId(16908313);
            button.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            button.setText((CharSequence)string3);
            linearLayout.addView((View)button);
            button.setOnClickListener((View.OnClickListener)new zad(context, intent));
        }
    }

    @KeepForSdk
    public void onStart() {
        this.zaa(null, new zag(this));
    }

    @KeepForSdk
    public void onResume() {
        this.zaa(null, new zaf(this));
    }

    @KeepForSdk
    public void onPause() {
        if (this.zaa != null) {
            this.zaa.onPause();
            return;
        }
        this.zaa(5);
    }

    @KeepForSdk
    public void onStop() {
        if (this.zaa != null) {
            this.zaa.onStop();
            return;
        }
        this.zaa(4);
    }

    @KeepForSdk
    public void onDestroyView() {
        if (this.zaa != null) {
            this.zaa.onDestroyView();
            return;
        }
        this.zaa(2);
    }

    @KeepForSdk
    public void onDestroy() {
        if (this.zaa != null) {
            this.zaa.onDestroy();
            return;
        }
        this.zaa(1);
    }

    @KeepForSdk
    public void onSaveInstanceState(@RecentlyNonNull Bundle bundle) {
        if (this.zaa != null) {
            this.zaa.onSaveInstanceState(bundle);
            return;
        }
        if (this.zab != null) {
            bundle.putAll(this.zab);
        }
    }

    @KeepForSdk
    public void onLowMemory() {
        if (this.zaa != null) {
            this.zaa.onLowMemory();
        }
    }

    static /* synthetic */ LifecycleDelegate zaa(DeferredLifecycleHelper deferredLifecycleHelper, LifecycleDelegate lifecycleDelegate) {
        deferredLifecycleHelper.zaa = lifecycleDelegate;
        return deferredLifecycleHelper.zaa;
    }

    static /* synthetic */ LinkedList zaa(DeferredLifecycleHelper deferredLifecycleHelper) {
        return deferredLifecycleHelper.zac;
    }

    static /* synthetic */ LifecycleDelegate zab(DeferredLifecycleHelper deferredLifecycleHelper) {
        return deferredLifecycleHelper.zaa;
    }

    static /* synthetic */ Bundle zaa(DeferredLifecycleHelper deferredLifecycleHelper, Bundle bundle) {
        deferredLifecycleHelper.zab = null;
        return null;
    }

    private static interface zaa {
        public int zaa();

        public void zaa(LifecycleDelegate var1);
    }
}

