/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.zaci;
import com.google.android.gms.common.api.internal.zacj;
import com.google.android.gms.common.api.internal.zack;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.BiConsumer;
import com.google.android.gms.tasks.TaskCompletionSource;

@KeepForSdk
public abstract class TaskApiCall<A extends Api.AnyClient, ResultT> {
    @Nullable
    private final Feature[] zaa;
    private final boolean zab;
    private final int zac;

    @Deprecated
    @KeepForSdk
    public TaskApiCall() {
        this.zaa = null;
        this.zab = false;
        this.zac = 0;
    }

    @KeepForSdk
    protected TaskApiCall(@RecentlyNonNull Feature[] featureArray, boolean bl, int n) {
        this.zaa = featureArray;
        this.zab = featureArray != null && bl;
        this.zac = n;
    }

    @KeepForSdk
    protected abstract void doExecute(@RecentlyNonNull A var1, @RecentlyNonNull TaskCompletionSource<ResultT> var2) throws RemoteException;

    @RecentlyNullable
    public final Feature[] zaa() {
        return this.zaa;
    }

    @KeepForSdk
    public boolean shouldAutoResolveMissingFeatures() {
        return this.zab;
    }

    public final int zab() {
        return this.zac;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <A extends Api.AnyClient, ResultT> Builder<A, ResultT> builder() {
        return new Builder(null);
    }

    @KeepForSdk
    public static class Builder<A extends Api.AnyClient, ResultT> {
        private RemoteCall<A, TaskCompletionSource<ResultT>> zaa;
        private boolean zab = true;
        private Feature[] zac;
        private int zad = 0;

        private Builder() {
        }

        @Deprecated
        @KeepForSdk
        @RecentlyNonNull
        public Builder<A, ResultT> execute(@RecentlyNonNull BiConsumer<A, TaskCompletionSource<ResultT>> biConsumer) {
            this.zaa = new zack(biConsumer);
            return this;
        }

        @KeepForSdk
        @RecentlyNonNull
        public Builder<A, ResultT> run(@RecentlyNonNull RemoteCall<A, TaskCompletionSource<ResultT>> remoteCall) {
            this.zaa = remoteCall;
            return this;
        }

        @KeepForSdk
        @RecentlyNonNull
        public Builder<A, ResultT> setFeatures(Feature ... featureArray) {
            this.zac = featureArray;
            return this;
        }

        @KeepForSdk
        @RecentlyNonNull
        public Builder<A, ResultT> setAutoResolveMissingFeatures(boolean bl) {
            this.zab = bl;
            return this;
        }

        @KeepForSdk
        @RecentlyNonNull
        public Builder<A, ResultT> setMethodKey(int n) {
            this.zad = n;
            return this;
        }

        @KeepForSdk
        @RecentlyNonNull
        public TaskApiCall<A, ResultT> build() {
            Preconditions.checkArgument((this.zaa != null ? 1 : 0) != 0, (Object)"execute parameter required");
            return new zacj(this, this.zac, this.zab, this.zad);
        }

        /* synthetic */ Builder(zaci zaci2) {
            this();
        }

        static /* synthetic */ RemoteCall zaa(Builder builder) {
            return builder.zaa;
        }
    }
}

