/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Handler;
import android.os.IInterface;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.ConnectionCallbacks;
import com.google.android.gms.common.api.internal.OnConnectionFailedListener;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zag;
import com.google.android.gms.common.internal.zai;
import com.google.android.gms.common.internal.zak;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.Collections;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;

@KeepForSdk
public abstract class GmsClient<T extends IInterface>
extends BaseGmsClient<T>
implements Api.Client,
zak {
    private final ClientSettings zaa;
    private final Set<Scope> zab;
    @Nullable
    private final Account zac;

    @VisibleForTesting
    @KeepForSdk
    protected GmsClient(@RecentlyNonNull Context context, @RecentlyNonNull Handler handler, int n, @RecentlyNonNull ClientSettings clientSettings) {
        this(context, handler, GmsClientSupervisor.getInstance((Context)context), GoogleApiAvailability.getInstance(), n, clientSettings, null, null);
    }

    @KeepForSdk
    protected GmsClient(@RecentlyNonNull Context context, @RecentlyNonNull Looper looper, int n, @RecentlyNonNull ClientSettings clientSettings, @RecentlyNonNull ConnectionCallbacks connectionCallbacks, @RecentlyNonNull OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, GmsClientSupervisor.getInstance((Context)context), GoogleApiAvailability.getInstance(), n, clientSettings, (ConnectionCallbacks)Preconditions.checkNotNull((Object)connectionCallbacks), (OnConnectionFailedListener)Preconditions.checkNotNull((Object)onConnectionFailedListener));
    }

    @Deprecated
    @KeepForSdk
    protected GmsClient(@RecentlyNonNull Context context, @RecentlyNonNull Looper looper, int n, @RecentlyNonNull ClientSettings clientSettings, @RecentlyNonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks, @RecentlyNonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, n, clientSettings, (ConnectionCallbacks)connectionCallbacks, (OnConnectionFailedListener)onConnectionFailedListener);
    }

    @KeepForSdk
    protected GmsClient(@RecentlyNonNull Context context, @RecentlyNonNull Looper looper, int n, @RecentlyNonNull ClientSettings clientSettings) {
        this(context, looper, GmsClientSupervisor.getInstance((Context)context), GoogleApiAvailability.getInstance(), n, clientSettings, null, null);
    }

    @VisibleForTesting
    private GmsClient(Context context, Looper looper, GmsClientSupervisor gmsClientSupervisor, GoogleApiAvailability googleApiAvailability, int n, ClientSettings clientSettings, @Nullable ConnectionCallbacks connectionCallbacks, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, gmsClientSupervisor, (GoogleApiAvailabilityLight)googleApiAvailability, n, GmsClient.zaa(connectionCallbacks), GmsClient.zaa(onConnectionFailedListener), clientSettings.zab());
        this.zaa = clientSettings;
        this.zac = clientSettings.getAccount();
        this.zab = this.zaa(clientSettings.getAllRequestedScopes());
    }

    @VisibleForTesting
    private GmsClient(Context context, Looper looper, GmsClientSupervisor gmsClientSupervisor, GoogleApiAvailability googleApiAvailability, int n, ClientSettings clientSettings, @Nullable GoogleApiClient.ConnectionCallbacks connectionCallbacks, @Nullable GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, gmsClientSupervisor, googleApiAvailability, n, clientSettings, (ConnectionCallbacks)null, (OnConnectionFailedListener)null);
    }

    @VisibleForTesting
    private GmsClient(Context context, Handler handler, GmsClientSupervisor gmsClientSupervisor, GoogleApiAvailability googleApiAvailability, int n, ClientSettings clientSettings, @Nullable ConnectionCallbacks connectionCallbacks, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
        super(context, handler, gmsClientSupervisor, (GoogleApiAvailabilityLight)googleApiAvailability, n, GmsClient.zaa(null), GmsClient.zaa(null));
        this.zaa = (ClientSettings)Preconditions.checkNotNull((Object)clientSettings);
        this.zac = clientSettings.getAccount();
        this.zab = this.zaa(clientSettings.getAllRequestedScopes());
    }

    @Deprecated
    @VisibleForTesting
    private GmsClient(Context context, Handler handler, GmsClientSupervisor gmsClientSupervisor, GoogleApiAvailability googleApiAvailability, int n, ClientSettings clientSettings, @Nullable GoogleApiClient.ConnectionCallbacks connectionCallbacks, @Nullable GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, handler, gmsClientSupervisor, googleApiAvailability, n, clientSettings, (ConnectionCallbacks)null, (OnConnectionFailedListener)null);
    }

    private final Set<Scope> zaa(@UnknownInitialization GmsClient<T> this, @NonNull Set<Scope> set) {
        Set<Scope> set2 = this.validateScopes(set);
        for (Scope scope : set2) {
            if (set.contains(scope)) continue;
            throw new IllegalStateException("Expanding scopes is not permitted, use implied scopes instead");
        }
        return set2;
    }

    @NonNull
    @KeepForSdk
    protected Set<Scope> validateScopes(@UnknownInitialization GmsClient<T> this, @RecentlyNonNull Set<Scope> set) {
        return set;
    }

    @RecentlyNullable
    public final Account getAccount() {
        return this.zac;
    }

    @KeepForSdk
    @RecentlyNonNull
    protected final ClientSettings getClientSettings() {
        return this.zaa;
    }

    @KeepForSdk
    @RecentlyNonNull
    protected final Set<Scope> getScopes() {
        return this.zab;
    }

    @Override
    @KeepForSdk
    @NonNull
    public Set<Scope> getScopesForConnectionlessNonSignIn() {
        if (this.requiresSignIn()) {
            return this.zab;
        }
        return Collections.emptySet();
    }

    @Override
    @KeepForSdk
    @RecentlyNonNull
    public Feature[] getRequiredFeatures() {
        return new Feature[0];
    }

    @Nullable
    private static BaseGmsClient.BaseConnectionCallbacks zaa(@Nullable ConnectionCallbacks connectionCallbacks) {
        if (connectionCallbacks == null) {
            return null;
        }
        return new zag(connectionCallbacks);
    }

    @Nullable
    private static BaseGmsClient.BaseOnConnectionFailedListener zaa(@Nullable OnConnectionFailedListener onConnectionFailedListener) {
        if (onConnectionFailedListener == null) {
            return null;
        }
        return new zai(onConnectionFailedListener);
    }
}

