/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zak;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.base.zap;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;

public final class zah
implements Handler.Callback {
    @NotOnlyInitialized
    private final zak zaa;
    private final ArrayList<GoogleApiClient.ConnectionCallbacks> zab = new ArrayList();
    @VisibleForTesting
    private final ArrayList<GoogleApiClient.ConnectionCallbacks> zac = new ArrayList();
    private final ArrayList<GoogleApiClient.OnConnectionFailedListener> zad = new ArrayList();
    private volatile boolean zae = false;
    private final AtomicInteger zaf = new AtomicInteger(0);
    private boolean zag = false;
    private final Handler zah;
    private final Object zai = new Object();

    public zah(Looper looper, @UnknownInitialization zak zak2) {
        this.zaa = zak2;
        this.zah = new zap(looper, this);
    }

    public final void zaa() {
        this.zae = false;
        this.zaf.incrementAndGet();
    }

    public final void zab() {
        this.zae = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void zaa(@Nullable Bundle bundle) {
        Preconditions.checkHandlerThread((Handler)this.zah, (String)"onConnectionSuccess must only be called on the Handler thread");
        Object object = this.zai;
        synchronized (object) {
            Preconditions.checkState((!this.zag ? 1 : 0) != 0);
            this.zah.removeMessages(1);
            this.zag = true;
            Preconditions.checkState((this.zac.size() == 0 ? 1 : 0) != 0);
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zab);
            int n = this.zaf.get();
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                GoogleApiClient.ConnectionCallbacks connectionCallbacks = arrayList2.get(i);
                GoogleApiClient.ConnectionCallbacks connectionCallbacks2 = connectionCallbacks;
                if (!this.zae || !this.zaa.isConnected() || this.zaf.get() != n) break;
                if (this.zac.contains(connectionCallbacks2)) continue;
                connectionCallbacks2.onConnected(bundle);
            }
            this.zac.clear();
            this.zag = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void zaa(int n) {
        Preconditions.checkHandlerThread((Handler)this.zah, (String)"onUnintentionalDisconnection must only be called on the Handler thread");
        this.zah.removeMessages(1);
        Object object = this.zai;
        synchronized (object) {
            this.zag = true;
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zab);
            int n2 = this.zaf.get();
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList2 = arrayList;
            int n3 = arrayList2.size();
            for (int i = 0; i < n3; ++i) {
                GoogleApiClient.ConnectionCallbacks connectionCallbacks = arrayList2.get(i);
                GoogleApiClient.ConnectionCallbacks connectionCallbacks2 = connectionCallbacks;
                if (!this.zae || this.zaf.get() != n2) break;
                if (!this.zab.contains(connectionCallbacks2)) continue;
                connectionCallbacks2.onConnectionSuspended(n);
            }
            this.zac.clear();
            this.zag = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void zaa(ConnectionResult connectionResult) {
        Preconditions.checkHandlerThread((Handler)this.zah, (String)"onConnectionFailure must only be called on the Handler thread");
        this.zah.removeMessages(1);
        Object object = this.zai;
        synchronized (object) {
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList = new ArrayList<GoogleApiClient.OnConnectionFailedListener>(this.zad);
            int n = this.zaf.get();
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = arrayList2.get(i);
                GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener2 = onConnectionFailedListener;
                if (this.zae && this.zaf.get() == n) continue;
                return;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zaa(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        Preconditions.checkNotNull((Object)connectionCallbacks);
        Object object = this.zai;
        synchronized (object) {
            if (this.zab.contains(connectionCallbacks)) {
                String string2 = String.valueOf(connectionCallbacks);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(62 + String.valueOf(string2).length()).append("registerConnectionCallbacks(): listener ").append(string2).append(" is already registered").toString());
            } else {
                this.zab.add(connectionCallbacks);
            }
        }
        if (this.zaa.isConnected()) {
            this.zah.sendMessage(this.zah.obtainMessage(1, (Object)connectionCallbacks));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zab(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        Preconditions.checkNotNull((Object)connectionCallbacks);
        Object object = this.zai;
        synchronized (object) {
            return this.zab.contains(connectionCallbacks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zac(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        Preconditions.checkNotNull((Object)connectionCallbacks);
        Object object = this.zai;
        synchronized (object) {
            if (!this.zab.remove(connectionCallbacks)) {
                String string2 = String.valueOf(connectionCallbacks);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(52 + String.valueOf(string2).length()).append("unregisterConnectionCallbacks(): listener ").append(string2).append(" not found").toString());
            } else if (this.zag) {
                this.zac.add(connectionCallbacks);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zaa(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        Preconditions.checkNotNull((Object)onConnectionFailedListener);
        Object object = this.zai;
        synchronized (object) {
            if (this.zad.contains(onConnectionFailedListener)) {
                String string2 = String.valueOf(onConnectionFailedListener);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(67 + String.valueOf(string2).length()).append("registerConnectionFailedListener(): listener ").append(string2).append(" is already registered").toString());
            } else {
                this.zad.add(onConnectionFailedListener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zab(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        Preconditions.checkNotNull((Object)onConnectionFailedListener);
        Object object = this.zai;
        synchronized (object) {
            return this.zad.contains(onConnectionFailedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zac(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        Preconditions.checkNotNull((Object)onConnectionFailedListener);
        Object object = this.zai;
        synchronized (object) {
            if (!this.zad.remove(onConnectionFailedListener)) {
                String string2 = String.valueOf(onConnectionFailedListener);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(57 + String.valueOf(string2).length()).append("unregisterConnectionFailedListener(): listener ").append(string2).append(" not found").toString());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean handleMessage(Message message) {
        if (message.what == 1) {
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)message.obj;
            Object object = this.zai;
            synchronized (object) {
                if (this.zae && this.zaa.isConnected() && this.zab.contains(connectionCallbacks)) {
                    Bundle bundle = this.zaa.getConnectionHint();
                    connectionCallbacks.onConnected(bundle);
                }
            }
            return true;
        }
        int n = message.what;
        Log.wtf((String)"GmsClientEvents", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        return false;
    }
}

