/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.Cursor;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.data.zab;
import com.google.android.gms.common.data.zac;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.sqlite.CursorWrapper;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@KeepName
@SafeParcelable.Class(creator="DataHolderCreator", validate=true)
@KeepForSdk
public final class DataHolder
extends AbstractSafeParcelable
implements Closeable {
    @KeepForSdk
    @RecentlyNonNull
    public static final Parcelable.Creator<DataHolder> CREATOR = new zac();
    @SafeParcelable.VersionField(id=1000)
    private final int zaa;
    @SafeParcelable.Field(id=1, getter="getColumns")
    private final String[] zab;
    private Bundle zac;
    @SafeParcelable.Field(id=2, getter="getWindows")
    private final CursorWindow[] zad;
    @SafeParcelable.Field(id=3, getter="getStatusCode")
    private final int zae;
    @SafeParcelable.Field(id=4, getter="getMetadata")
    @Nullable
    private final Bundle zaf;
    private int[] zag;
    private int zah;
    private boolean zai = false;
    private boolean zaj = true;
    private static final Builder zak = new zab(new String[0], null);

    @SafeParcelable.Constructor
    DataHolder(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) String[] stringArray, @SafeParcelable.Param(id=2) CursorWindow[] cursorWindowArray, @SafeParcelable.Param(id=3) int n2, @SafeParcelable.Param(id=4) @Nullable Bundle bundle) {
        this.zaa = n;
        this.zab = stringArray;
        this.zad = cursorWindowArray;
        this.zae = n2;
        this.zaf = bundle;
    }

    @KeepForSdk
    public DataHolder(@RecentlyNonNull String[] stringArray, @RecentlyNonNull CursorWindow[] cursorWindowArray, @RecentlyNonNull int n, @Nullable Bundle bundle) {
        this.zaa = 1;
        this.zab = (String[])Preconditions.checkNotNull((Object)stringArray);
        this.zad = (CursorWindow[])Preconditions.checkNotNull((Object)cursorWindowArray);
        this.zae = n;
        this.zaf = bundle;
        this.zaa();
    }

    private DataHolder(CursorWrapper cursorWrapper, int n, @Nullable Bundle bundle) {
        this(cursorWrapper.getColumnNames(), DataHolder.zaa(cursorWrapper), n, bundle);
    }

    @KeepForSdk
    public DataHolder(@RecentlyNonNull Cursor cursor, @RecentlyNonNull int n, @Nullable Bundle bundle) {
        this(new CursorWrapper(cursor), n, bundle);
    }

    private DataHolder(Builder builder, int n, @Nullable Bundle bundle) {
        this(builder.zaa, DataHolder.zaa(builder, -1), n, null);
    }

    private DataHolder(Builder builder, int n, @Nullable Bundle bundle, int n2) {
        this(builder.zaa, DataHolder.zaa(builder, -1), n, bundle);
    }

    public final void zaa() {
        int n;
        this.zac = new Bundle();
        for (n = 0; n < this.zab.length; ++n) {
            this.zac.putInt(this.zab[n], n);
        }
        this.zag = new int[this.zad.length];
        n = 0;
        for (int i = 0; i < this.zad.length; ++i) {
            this.zag[i] = n;
            int n2 = this.zad[i].getStartPosition();
            int n3 = n - n2;
            n += this.zad[i].getNumRows() - n3;
        }
        this.zah = n;
    }

    public final void writeToParcel(@RecentlyNonNull Parcel parcel, @RecentlyNonNull int n) {
        Parcel parcel2 = parcel;
        DataHolder dataHolder = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeStringArray((Parcel)parcel2, (int)1, (String[])dataHolder.zab, (boolean)false);
        SafeParcelWriter.writeTypedArray((Parcel)parcel2, (int)2, (Parcelable[])dataHolder.zad, (int)n, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)3, (int)dataHolder.getStatusCode());
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)4, (Bundle)dataHolder.getMetadata(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1000, (int)dataHolder.zaa);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        if ((n & 1) != 0) {
            this.close();
        }
    }

    @KeepForSdk
    @RecentlyNonNull
    public final int getStatusCode() {
        return this.zae;
    }

    @KeepForSdk
    @RecentlyNullable
    public final Bundle getMetadata() {
        return this.zaf;
    }

    private static CursorWindow[] zaa(CursorWrapper cursorWrapper) {
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        try {
            int n = cursorWrapper.getCount();
            CursorWindow cursorWindow = cursorWrapper.getWindow();
            int n2 = 0;
            if (cursorWindow != null && cursorWindow.getStartPosition() == 0) {
                cursorWindow.acquireReference();
                cursorWrapper.setWindow(null);
                arrayList.add(cursorWindow);
                n2 = cursorWindow.getNumRows();
            }
            while (n2 < n && cursorWrapper.moveToPosition(n2)) {
                CursorWindow cursorWindow2 = cursorWrapper.getWindow();
                if (cursorWindow2 != null) {
                    cursorWindow2.acquireReference();
                    cursorWrapper.setWindow(null);
                } else {
                    cursorWindow2 = new CursorWindow(false);
                    cursorWindow2.setStartPosition(n2);
                    cursorWrapper.fillWindow(n2, cursorWindow2);
                }
                if (cursorWindow2.getNumRows() != 0) {
                    arrayList.add(cursorWindow2);
                    n2 = cursorWindow2.getStartPosition() + cursorWindow2.getNumRows();
                    continue;
                }
                break;
            }
        }
        finally {
            cursorWrapper.close();
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private static CursorWindow[] zaa(Builder builder, int n) {
        if (builder.zaa.length == 0) {
            return new CursorWindow[0];
        }
        ArrayList arrayList = builder.zab;
        int n2 = arrayList.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList2 = new ArrayList<CursorWindow>();
        arrayList2.add(cursorWindow);
        cursorWindow.setNumColumns(builder.zaa.length);
        boolean bl = false;
        try {
            for (int i = 0; i < n2; ++i) {
                int n3;
                if (!cursorWindow.allocRow()) {
                    int n4 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(72).append("Allocating additional cursor window for large data set (row ").append(n4).append(")").toString());
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(builder.zaa.length);
                    arrayList2.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList2.remove(cursorWindow);
                        return arrayList2.toArray(new CursorWindow[arrayList2.size()]);
                    }
                }
                Map map = (Map)arrayList.get(i);
                boolean bl2 = true;
                for (n3 = 0; n3 < builder.zaa.length && bl2; ++n3) {
                    String string2 = builder.zaa[n3];
                    Object v = map.get(string2);
                    if (v == null) {
                        bl2 = cursorWindow.putNull(i, n3);
                        continue;
                    }
                    if (v instanceof String) {
                        bl2 = cursorWindow.putString((String)v, i, n3);
                        continue;
                    }
                    if (v instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v).longValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v).intValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Boolean) {
                        boolean bl3 = (Boolean)v;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, i, n3);
                        continue;
                    }
                    if (v instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v, i, n3);
                        continue;
                    }
                    if (v instanceof Double) {
                        bl2 = cursorWindow.putDouble(((Double)v).doubleValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Float) {
                        bl2 = cursorWindow.putDouble((double)((Float)v).floatValue(), i, n3);
                        continue;
                    }
                    String string3 = String.valueOf(v);
                    throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Unsupported object for column ").append(string2).append(": ").append(string3).toString());
                }
                if (!bl2) {
                    if (bl) {
                        String string4 = "Could not add the value to a new CursorWindow. The size of value may be larger than what a CursorWindow can handle.";
                        throw new zaa(string4);
                    }
                    n3 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(74).append("Couldn't populate window data for row ").append(n3).append(" - allocating new window.").toString());
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(builder.zaa.length);
                    arrayList2.add(cursorWindow);
                    --i;
                    bl = true;
                    continue;
                }
                bl = false;
            }
        }
        catch (RuntimeException runtimeException) {
            int n5 = arrayList2.size();
            for (int i = 0; i < n5; ++i) {
                ((CursorWindow)arrayList2.get(i)).close();
            }
            throw runtimeException;
        }
        return arrayList2.toArray(new CursorWindow[arrayList2.size()]);
    }

    private final void zaa(String string2, int n) {
        if (this.zac == null || !this.zac.containsKey(string2)) {
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException(string3.length() != 0 ? "No such column: ".concat(string3) : new String("No such column: "));
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n < 0 || n >= this.zah) {
            throw new CursorIndexOutOfBoundsException(n, this.zah);
        }
    }

    @KeepForSdk
    @RecentlyNonNull
    public final boolean hasColumn(@RecentlyNonNull String string2) {
        return this.zac.containsKey(string2);
    }

    @KeepForSdk
    @RecentlyNonNull
    public final long getLong(@RecentlyNonNull String string2, @RecentlyNonNull int n, @RecentlyNonNull int n2) {
        this.zaa(string2, n);
        return this.zad[n2].getLong(n, this.zac.getInt(string2));
    }

    @KeepForSdk
    @RecentlyNonNull
    public final int getInteger(@RecentlyNonNull String string2, @RecentlyNonNull int n, @RecentlyNonNull int n2) {
        this.zaa(string2, n);
        return this.zad[n2].getInt(n, this.zac.getInt(string2));
    }

    @KeepForSdk
    @RecentlyNonNull
    public final String getString(@RecentlyNonNull String string2, @RecentlyNonNull int n, @RecentlyNonNull int n2) {
        this.zaa(string2, n);
        return this.zad[n2].getString(n, this.zac.getInt(string2));
    }

    @KeepForSdk
    @RecentlyNonNull
    public final boolean getBoolean(@RecentlyNonNull String string2, @RecentlyNonNull int n, @RecentlyNonNull int n2) {
        this.zaa(string2, n);
        return Long.valueOf(this.zad[n2].getLong(n, this.zac.getInt(string2))) == 1L;
    }

    @RecentlyNonNull
    public final float zaa(@RecentlyNonNull String string2, @RecentlyNonNull int n, @RecentlyNonNull int n2) {
        this.zaa(string2, n);
        return this.zad[n2].getFloat(n, this.zac.getInt(string2));
    }

    @RecentlyNonNull
    public final double zab(@RecentlyNonNull String string2, @RecentlyNonNull int n, @RecentlyNonNull int n2) {
        this.zaa(string2, n);
        return this.zad[n2].getDouble(n, this.zac.getInt(string2));
    }

    @KeepForSdk
    @RecentlyNonNull
    public final byte[] getByteArray(@RecentlyNonNull String string2, @RecentlyNonNull int n, @RecentlyNonNull int n2) {
        this.zaa(string2, n);
        return this.zad[n2].getBlob(n, this.zac.getInt(string2));
    }

    public final void zaa(@RecentlyNonNull String string2, @RecentlyNonNull int n, @RecentlyNonNull int n2, @RecentlyNonNull CharArrayBuffer charArrayBuffer) {
        this.zaa(string2, n);
        this.zad[n2].copyStringToBuffer(n, this.zac.getInt(string2), charArrayBuffer);
    }

    @KeepForSdk
    @RecentlyNonNull
    public final boolean hasNull(@RecentlyNonNull String string2, @RecentlyNonNull int n, @RecentlyNonNull int n2) {
        this.zaa(string2, n);
        return this.zad[n2].isNull(n, this.zac.getInt(string2));
    }

    @KeepForSdk
    @RecentlyNonNull
    public final int getCount() {
        return this.zah;
    }

    @KeepForSdk
    @RecentlyNonNull
    public final int getWindowIndex(@RecentlyNonNull int n) {
        int n2;
        Preconditions.checkState((n >= 0 && n < this.zah ? 1 : 0) != 0);
        for (n2 = 0; n2 < this.zag.length; ++n2) {
            if (n >= this.zag[n2]) continue;
            --n2;
            break;
        }
        if (n2 == this.zag.length) {
            --n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    @RecentlyNonNull
    public final boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.zai;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @KeepForSdk
    public final void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.zai) {
                this.zai = true;
                for (int i = 0; i < this.zad.length; ++i) {
                    this.zad[i].close();
                }
            }
            return;
        }
    }

    protected final void finalize() throws Throwable {
        try {
            if (this.zaj && this.zad.length > 0 && !this.isClosed()) {
                this.close();
                String string2 = this.toString();
                Log.e((String)"DataBuffer", (String)new StringBuilder(178 + String.valueOf(string2).length()).append("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (internal object: ").append(string2).append(")").toString());
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    @KeepForSdk
    @RecentlyNonNull
    public static Builder builder(@RecentlyNonNull String[] stringArray) {
        return new Builder(stringArray, null, null);
    }

    @KeepForSdk
    @RecentlyNonNull
    public static DataHolder empty(@RecentlyNonNull int n) {
        return new DataHolder(zak, n, null);
    }

    /* synthetic */ DataHolder(Builder builder, int n, Bundle bundle, zab zab2) {
        this(builder, n, null);
    }

    /* synthetic */ DataHolder(Builder builder, int n, Bundle bundle, int n2, zab zab2) {
        this(builder, n, bundle, -1);
    }

    public static final class zaa
    extends RuntimeException {
        public zaa(String string2) {
            super(string2);
        }
    }

    @KeepForSdk
    public static class Builder {
        private final String[] zaa;
        private final ArrayList<HashMap<String, Object>> zab;
        @Nullable
        private final String zac;
        private final HashMap<Object, Integer> zad;
        private boolean zae;
        @Nullable
        private String zaf;

        private Builder(String[] stringArray, @Nullable String string2) {
            this.zaa = (String[])Preconditions.checkNotNull((Object)stringArray);
            this.zab = new ArrayList();
            this.zac = null;
            this.zad = new HashMap();
            this.zae = false;
            this.zaf = null;
        }

        @RecentlyNonNull
        public Builder zaa(@RecentlyNonNull HashMap<String, Object> hashMap) {
            int n;
            int n2;
            Asserts.checkNotNull(hashMap);
            HashMap<String, Object> hashMap2 = hashMap;
            Builder builder = this;
            if (builder.zac == null) {
                n2 = -1;
            } else {
                Object object = hashMap2.get(builder.zac);
                if (object == null) {
                    n2 = -1;
                } else {
                    Integer n3 = builder.zad.get(object);
                    if (n3 == null) {
                        builder.zad.put(object, builder.zab.size());
                        n2 = -1;
                    } else {
                        n2 = n = n3.intValue();
                    }
                }
            }
            if (n2 == -1) {
                this.zab.add(hashMap);
            } else {
                this.zab.remove(n);
                this.zab.add(n, hashMap);
            }
            this.zae = false;
            return this;
        }

        @KeepForSdk
        @RecentlyNonNull
        public Builder withRow(@RecentlyNonNull ContentValues contentValues) {
            Asserts.checkNotNull((Object)contentValues);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(contentValues.size());
            for (Map.Entry entry : contentValues.valueSet()) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return this.zaa(hashMap);
        }

        @KeepForSdk
        @RecentlyNonNull
        public DataHolder build(@RecentlyNonNull int n) {
            return new DataHolder(this, n, null, null);
        }

        @KeepForSdk
        @RecentlyNonNull
        public DataHolder build(@RecentlyNonNull int n, @RecentlyNonNull Bundle bundle) {
            return new DataHolder(this, n, bundle, -1, null);
        }

        /* synthetic */ Builder(String[] stringArray, String string2, zab zab2) {
            this(stringArray, null);
        }
    }
}

