/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.LifecycleActivity;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.StatusPendingResult;
import com.google.android.gms.common.api.internal.zaar;
import com.google.android.gms.common.api.internal.zaas;
import com.google.android.gms.common.api.internal.zaat;
import com.google.android.gms.common.api.internal.zaau;
import com.google.android.gms.common.api.internal.zaav;
import com.google.android.gms.common.api.internal.zaaw;
import com.google.android.gms.common.api.internal.zaax;
import com.google.android.gms.common.api.internal.zabj;
import com.google.android.gms.common.api.internal.zabm;
import com.google.android.gms.common.api.internal.zabn;
import com.google.android.gms.common.api.internal.zack;
import com.google.android.gms.common.api.internal.zacl;
import com.google.android.gms.common.api.internal.zai;
import com.google.android.gms.common.api.internal.zap;
import com.google.android.gms.common.api.internal.zaq;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.service.Common;
import com.google.android.gms.common.internal.zah;
import com.google.android.gms.common.internal.zak;
import com.google.android.gms.common.util.ClientLibraryUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.zad;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class zaap
extends GoogleApiClient
implements zabm {
    private final Lock zaf;
    private final zah zag;
    @Nullable
    private zabn zah = null;
    private final int zai;
    private final Context zaj;
    private final Looper zak;
    @VisibleForTesting
    final Queue<BaseImplementation.ApiMethodImpl<?, ?>> zaa = new LinkedList();
    private volatile boolean zal;
    private long zam = ClientLibraryUtils.isPackageSide() ? 10000L : 120000L;
    private long zan = 5000L;
    private final zaaw zao;
    private final GoogleApiAvailability zap;
    @Nullable
    @VisibleForTesting
    private zabj zaq;
    final Map<Api.AnyClientKey<?>, Api.Client> zab;
    Set<Scope> zac = new HashSet<Scope>();
    private final ClientSettings zar;
    private final Map<Api<?>, Boolean> zas;
    private final Api.AbstractClientBuilder<? extends zad, SignInOptions> zat;
    private final ListenerHolders zau = new ListenerHolders();
    private final ArrayList<zap> zav;
    private @MonotonicNonNull Integer zaw = null;
    @Nullable
    Set<zack> zad = null;
    final zacl zae;
    private final zak zax = new zaas(this);

    public zaap(Context context, Lock lock, Looper looper, ClientSettings clientSettings, GoogleApiAvailability googleApiAvailability, Api.AbstractClientBuilder<? extends zad, SignInOptions> abstractClientBuilder, Map<Api<?>, Boolean> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.AnyClientKey<?>, Api.Client> map2, int n, int n2, ArrayList<zap> arrayList) {
        this.zaj = context;
        this.zaf = lock;
        this.zag = new zah(looper, this.zax);
        this.zak = looper;
        this.zao = new zaaw(this, looper);
        this.zap = googleApiAvailability;
        this.zai = n;
        if (this.zai >= 0) {
            this.zaw = n2;
        }
        this.zas = map;
        this.zab = map2;
        this.zav = arrayList;
        this.zae = new zacl();
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.zag.zaa(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.zag.zaa(onConnectionFailedListener);
        }
        this.zar = clientSettings;
        this.zat = abstractClientBuilder;
    }

    @Override
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T t) {
        Api<?> api = t.getApi();
        String string2 = api != null ? api.zad() : "the API";
        Preconditions.checkArgument((boolean)this.zab.containsKey(t.getClientKey()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.zaf.lock();
        try {
            if (this.zah == null) {
                this.zaa.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.zah.zaa(t);
            return (T)string2;
        }
        finally {
            this.zaf.unlock();
        }
    }

    @Override
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T t) {
        Api<?> api = t.getApi();
        Object object = api != null ? api.zad() : "the API";
        Preconditions.checkArgument((boolean)this.zab.containsKey(t.getClientKey()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.zaf.lock();
        try {
            object = this.zah;
            if (object == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.zal) {
                Object object2;
                this.zaa.add(t);
                while (!this.zaa.isEmpty()) {
                    object2 = this.zaa.remove();
                    this.zae.zaa((BasePendingResult<? extends Result>)object2);
                    ((BaseImplementation.ApiMethodImpl)object2).setFailedResult(Status.RESULT_INTERNAL_ERROR);
                }
                object2 = t;
                return (T)object2;
            }
            T t2 = object.zab(t);
            return t2;
        }
        finally {
            this.zaf.unlock();
        }
    }

    @Override
    public final <L> ListenerHolder<L> registerListener(@NonNull L l) {
        this.zaf.lock();
        try {
            Looper looper = this.zak;
            ListenerHolder<L> listenerHolder = this.zau.zaa(l, looper, "NO_TYPE");
            return listenerHolder;
        }
        finally {
            this.zaf.unlock();
        }
    }

    @Override
    @NonNull
    public final <C extends Api.Client> C getClient(@NonNull Api.AnyClientKey<C> anyClientKey) {
        Api.Client client = this.zab.get(anyClientKey);
        Preconditions.checkNotNull((Object)client, (Object)"Appropriate Api was not requested.");
        return (C)client;
    }

    @Override
    public final boolean hasApi(@NonNull Api<?> api) {
        return this.zab.containsKey(api.zac());
    }

    @Override
    public final boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!((GoogleApiClient)this).isConnected()) {
            return false;
        }
        Api.Client client = this.zab.get(api.zac());
        return client != null && client.isConnected();
    }

    @Override
    @NonNull
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        block6: {
            ConnectionResult connectionResult;
            block7: {
                block8: {
                    this.zaf.lock();
                    if (!((GoogleApiClient)this).isConnected() && !this.zal) {
                        throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
                    }
                    if (!this.zab.containsKey(api.zac())) break block6;
                    connectionResult = ((zabn)Preconditions.checkNotNull((Object)this.zah)).zaa(api);
                    if (connectionResult != null) break block7;
                    if (!this.zal) break block8;
                    ConnectionResult connectionResult2 = ConnectionResult.RESULT_SUCCESS;
                    this.zaf.unlock();
                    return connectionResult2;
                }
                Log.w((String)"GoogleApiClientImpl", (String)this.zac());
                Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.zad()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                return connectionResult3;
            }
            ConnectionResult connectionResult4 = connectionResult;
            this.zaf.unlock();
            return connectionResult4;
        }
        try {
            throw new IllegalArgumentException(String.valueOf(api.zad()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.zaf.unlock();
        }
    }

    @Override
    public final void connect() {
        this.zaf.lock();
        try {
            if (this.zai >= 0) {
                Preconditions.checkState((this.zaw != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zaw == null) {
                this.zaw = zaap.zaa(this.zab.values(), false);
            } else if (this.zaw == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            ((GoogleApiClient)this).connect((Integer)Preconditions.checkNotNull((Object)this.zaw));
            return;
        }
        finally {
            this.zaf.unlock();
        }
    }

    @Override
    public final void connect(int n) {
        this.zaf.lock();
        try {
            Preconditions.checkArgument((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zaa(n);
            this.zad();
            return;
        }
        finally {
            this.zaf.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        Preconditions.checkState((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.zaf.lock();
        try {
            if (this.zai >= 0) {
                Preconditions.checkState((this.zaw != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zaw == null) {
                this.zaw = zaap.zaa(this.zab.values(), false);
            } else if (this.zaw == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zaa((Integer)Preconditions.checkNotNull((Object)this.zaw));
            this.zag.zab();
            ConnectionResult connectionResult = ((zabn)Preconditions.checkNotNull((Object)this.zah)).zab();
            return connectionResult;
        }
        finally {
            this.zaf.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        Preconditions.checkState((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.zaf.lock();
        try {
            if (this.zaw == null) {
                this.zaw = zaap.zaa(this.zab.values(), false);
            } else if (this.zaw == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zaa((Integer)Preconditions.checkNotNull((Object)this.zaw));
            this.zag.zab();
            ConnectionResult connectionResult = ((zabn)Preconditions.checkNotNull((Object)this.zah)).zaa(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.zaf.unlock();
        }
    }

    @Override
    public final void disconnect() {
        this.zaf.lock();
        try {
            this.zae.zaa();
            if (this.zah != null) {
                this.zah.zac();
            }
            this.zau.zaa();
            for (BaseImplementation.ApiMethodImpl apiMethodImpl : this.zaa) {
                apiMethodImpl.zaa(null);
                ((PendingResult)apiMethodImpl).cancel();
            }
            this.zaa.clear();
            if (this.zah == null) {
                return;
            }
            this.zab();
            this.zag.zaa();
            return;
        }
        finally {
            this.zaf.unlock();
        }
    }

    @Override
    public final void reconnect() {
        ((GoogleApiClient)this).disconnect();
        ((GoogleApiClient)this).connect();
    }

    @Override
    public final PendingResult<Status> clearDefaultAccountAndReconnect() {
        Preconditions.checkState((boolean)((GoogleApiClient)this).isConnected(), (Object)"GoogleApiClient is not connected yet.");
        Preconditions.checkState((this.zaw == null || this.zaw != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        StatusPendingResult statusPendingResult = new StatusPendingResult(this);
        if (this.zab.containsKey(Common.CLIENT_KEY)) {
            this.zaa(this, statusPendingResult, false);
        } else {
            AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            zaar zaar2 = new zaar(this, atomicReference, statusPendingResult);
            zaau zaau2 = new zaau(this, statusPendingResult);
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.zaj).addApi(Common.API).addConnectionCallbacks(zaar2).addOnConnectionFailedListener(zaau2).setHandler(this.zao).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return statusPendingResult;
    }

    private final void zaa(GoogleApiClient googleApiClient, StatusPendingResult statusPendingResult, boolean bl) {
        Common.zaa.zaa(googleApiClient).setResultCallback(new zaat(this, statusPendingResult, bl, googleApiClient));
    }

    @Override
    public final void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        LifecycleActivity lifecycleActivity = new LifecycleActivity((Activity)fragmentActivity);
        zaap zaap2 = this;
        if (zaap2.zai >= 0) {
            com.google.android.gms.common.api.internal.zai.zaa(lifecycleActivity).zaa(zaap2.zai);
            return;
        }
        throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
    }

    @Override
    public final boolean isConnected() {
        return this.zah != null && this.zah.zad();
    }

    @Override
    public final boolean isConnecting() {
        return this.zah != null && this.zah.zae();
    }

    private final void zaa(int n) {
        if (this.zaw == null) {
            this.zaw = n;
        } else if (this.zaw != n) {
            String string2 = zaap.zab(n);
            String string3 = zaap.zab(this.zaw);
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.zah != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.Client client : this.zab.values()) {
            if (client.requiresSignIn()) {
                bl = true;
            }
            if (!client.providesSignIn()) continue;
            bl2 = true;
        }
        switch (this.zaw) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                this.zah = com.google.android.gms.common.api.internal.zaq.zaa(this.zaj, this, this.zaf, this.zak, this.zap, this.zab, this.zar, this.zas, this.zat, this.zav);
                return;
            }
        }
        this.zah = new zaax(this.zaj, this, this.zaf, this.zak, this.zap, this.zab, this.zar, this.zas, this.zat, this.zav, this);
    }

    @GuardedBy(value="mLock")
    private final void zad() {
        this.zag.zab();
        ((zabn)Preconditions.checkNotNull((Object)this.zah)).zaa();
    }

    private final void zae() {
        this.zaf.lock();
        try {
            if (this.zal) {
                this.zad();
            }
            return;
        }
        finally {
            this.zaf.unlock();
        }
    }

    private final void zaf() {
        this.zaf.lock();
        try {
            if (this.zab()) {
                this.zad();
            }
            return;
        }
        finally {
            this.zaf.unlock();
        }
    }

    @GuardedBy(value="mLock")
    final boolean zab() {
        if (!this.zal) {
            return false;
        }
        this.zal = false;
        this.zao.removeMessages(2);
        this.zao.removeMessages(1);
        if (this.zaq != null) {
            this.zaq.zaa();
            this.zaq = null;
        }
        return true;
    }

    @Override
    public final void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zag.zaa(connectionCallbacks);
    }

    @Override
    public final boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zag.zab(connectionCallbacks);
    }

    @Override
    public final void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zag.zac(connectionCallbacks);
    }

    @Override
    public final void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zag.zaa(onConnectionFailedListener);
    }

    @Override
    public final boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zag.zab(onConnectionFailedListener);
    }

    @Override
    public final void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zag.zac(onConnectionFailedListener);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaa(@Nullable Bundle bundle) {
        while (!this.zaa.isEmpty()) {
            ((GoogleApiClient)this).execute(this.zaa.remove());
        }
        this.zag.zaa(bundle);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaa(ConnectionResult connectionResult) {
        if (!this.zap.isPlayServicesPossiblyUpdating(this.zaj, connectionResult.getErrorCode())) {
            this.zab();
        }
        if (!this.zal) {
            this.zag.zaa(connectionResult);
            this.zag.zaa();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaa(int n, boolean bl) {
        if (n == 1 && !bl) {
            zaap zaap2 = this;
            if (!zaap2.zal) {
                zaap2.zal = true;
                if (zaap2.zaq == null && !ClientLibraryUtils.isPackageSide()) {
                    try {
                        zaap2.zaq = zaap2.zap.zaa(zaap2.zaj.getApplicationContext(), new zaav(zaap2));
                    }
                    catch (SecurityException securityException) {}
                }
                zaap2.zao.sendMessageDelayed(zaap2.zao.obtainMessage(1), zaap2.zam);
                zaap2.zao.sendMessageDelayed(zaap2.zao.obtainMessage(2), zaap2.zan);
            }
        }
        BasePendingResult[] basePendingResultArray = this.zae.zab.toArray(new BasePendingResult[0]);
        int n2 = basePendingResultArray.length;
        for (int i = 0; i < n2; ++i) {
            basePendingResultArray[i].forceFailureUnlessReady(zacl.zaa);
        }
        this.zag.zaa(n);
        this.zag.zaa();
        if (n == 2) {
            this.zad();
        }
    }

    @Override
    public final Context getContext() {
        return this.zaj;
    }

    @Override
    public final Looper getLooper() {
        return this.zak;
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        return this.zah != null && this.zah.zaa(signInConnectionListener);
    }

    @Override
    public final void maybeSignOut() {
        if (this.zah != null) {
            this.zah.zag();
        }
    }

    @Override
    public final void zaa(zack zack2) {
        this.zaf.lock();
        try {
            if (this.zad == null) {
                this.zad = new HashSet<zack>();
            }
            this.zad.add(zack2);
            return;
        }
        finally {
            this.zaf.unlock();
        }
    }

    @Override
    public final void zab(zack zack2) {
        this.zaf.lock();
        try {
            if (this.zad == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.zad.remove(zack2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zag() && this.zah != null) {
                this.zah.zaf();
            }
            return;
        }
        finally {
            this.zaf.unlock();
        }
    }

    private final boolean zag() {
        this.zaf.lock();
        try {
            if (this.zad == null) {
                return false;
            }
            boolean bl = !this.zad.isEmpty();
            return bl;
        }
        finally {
            this.zaf.unlock();
        }
    }

    final String zac() {
        StringWriter stringWriter = new StringWriter();
        ((GoogleApiClient)this).dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public final void dump(String string2, @Nullable FileDescriptor fileDescriptor, PrintWriter printWriter, @Nullable String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.zaj);
        printWriter.append(string2).append("mResuming=").print(this.zal);
        printWriter.append(" mWorkQueue.size()=").print(this.zaa.size());
        PrintWriter printWriter2 = printWriter;
        zacl zacl2 = this.zae;
        printWriter2.append(" mUnconsumedApiCalls.size()=").println(zacl2.zab.size());
        if (this.zah != null) {
            this.zah.zaa(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public static int zaa(Iterable<Api.Client> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.Client client : iterable) {
            if (client.requiresSignIn()) {
                bl2 = true;
            }
            if (!client.providesSignIn()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    private static String zab(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ void zaa(zaap zaap2) {
        zaap2.zae();
    }

    static /* synthetic */ void zab(zaap zaap2) {
        zaap2.zaf();
    }

    static /* synthetic */ void zaa(zaap zaap2, GoogleApiClient googleApiClient, StatusPendingResult statusPendingResult, boolean bl) {
        zaap2.zaa(googleApiClient, statusPendingResult, true);
    }

    static /* synthetic */ Context zac(zaap zaap2) {
        return zaap2.zaj;
    }
}

