/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import androidx.annotation.NonNull;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.BasePendingResult;
import java.util.concurrent.TimeUnit;

@KeepForSdk
public final class OptionalPendingResultImpl<R extends Result>
extends OptionalPendingResult<R> {
    private final BasePendingResult<R> zaa;

    public OptionalPendingResultImpl(@RecentlyNonNull PendingResult<R> pendingResult) {
        this.zaa = (BasePendingResult)pendingResult;
    }

    @Override
    @RecentlyNonNull
    public final boolean isDone() {
        return this.zaa.isReady();
    }

    @Override
    @RecentlyNonNull
    public final R get() {
        if (((OptionalPendingResult)this).isDone()) {
            return ((PendingResult)this).await(0L, TimeUnit.MILLISECONDS);
        }
        throw new IllegalStateException("Result is not available. Check that isDone() returns true before calling get().");
    }

    @Override
    @RecentlyNonNull
    public final R await() {
        return ((PendingResult)this.zaa).await();
    }

    @Override
    @RecentlyNonNull
    public final R await(@RecentlyNonNull long l, @RecentlyNonNull TimeUnit timeUnit) {
        return ((PendingResult)this.zaa).await(l, timeUnit);
    }

    @Override
    public final void cancel() {
        ((PendingResult)this.zaa).cancel();
    }

    @Override
    @RecentlyNonNull
    public final boolean isCanceled() {
        return ((PendingResult)this.zaa).isCanceled();
    }

    @Override
    public final void setResultCallback(@RecentlyNonNull ResultCallback<? super R> resultCallback) {
        ((PendingResult)this.zaa).setResultCallback(resultCallback);
    }

    @Override
    public final void setResultCallback(@RecentlyNonNull ResultCallback<? super R> resultCallback, @RecentlyNonNull long l, @RecentlyNonNull TimeUnit timeUnit) {
        ((PendingResult)this.zaa).setResultCallback(resultCallback, l, timeUnit);
    }

    @Override
    public final void addStatusListener(@RecentlyNonNull PendingResult.StatusListener statusListener) {
        ((PendingResult)this.zaa).addStatusListener(statusListener);
    }

    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@RecentlyNonNull ResultTransform<? super R, ? extends S> resultTransform) {
        return ((PendingResult)this.zaa).then(resultTransform);
    }
}

