/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.zaah;
import com.google.android.gms.common.api.internal.zaai;
import com.google.android.gms.common.api.internal.zaau;
import com.google.android.gms.common.api.internal.zaav;
import com.google.android.gms.common.api.internal.zabd;
import com.google.android.gms.common.api.internal.zabe;
import com.google.android.gms.common.api.internal.zabf;
import com.google.android.gms.common.api.internal.zabr;
import com.google.android.gms.common.api.internal.zabs;
import com.google.android.gms.common.api.internal.zap;
import com.google.android.gms.common.api.internal.zaq;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.zad;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zabc
implements zabs,
zap {
    private final Lock zaet;
    private final Condition zahr;
    private final Context mContext;
    private final GoogleApiAvailabilityLight zafc;
    private final zabe zahs;
    final Map<Api.AnyClientKey<?>, Api.Client> zahd;
    final Map<Api.AnyClientKey<?>, ConnectionResult> zaht = new HashMap();
    private final ClientSettings zaex;
    private final Map<Api<?>, Boolean> zafa;
    private final Api.AbstractClientBuilder<? extends zad, SignInOptions> zaci;
    private volatile zabd zahu;
    private ConnectionResult zahv = null;
    int zahw;
    final zaau zaej;
    final zabr zahx;

    public zabc(Context context, zaau zaau2, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, ClientSettings clientSettings, Map<Api<?>, Boolean> map2, Api.AbstractClientBuilder<? extends zad, SignInOptions> abstractClientBuilder, ArrayList<zaq> arrayList, zabr zabr2) {
        this.mContext = context;
        this.zaet = lock;
        this.zafc = googleApiAvailabilityLight;
        this.zahd = map;
        this.zaex = clientSettings;
        this.zafa = map2;
        this.zaci = abstractClientBuilder;
        this.zaej = zaau2;
        this.zahx = zabr2;
        ArrayList<zaq> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zaq zaq2 = arrayList2.get(i);
            zaq2.zaa(this);
        }
        this.zahs = new zabe(this, looper);
        this.zahr = lock.newCondition();
        this.zahu = new zaav(this);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T t) {
        t.zas();
        return this.zahu.enqueue(t);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T t) {
        t.zas();
        return this.zahu.execute(t);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void connect() {
        this.zahu.connect();
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zahr.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        if (this.zahv != null) {
            return this.zahv;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zahr.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        if (this.zahv != null) {
            return this.zahv;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void disconnect() {
        if (this.zahu.disconnect()) {
            this.zaht.clear();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.AnyClientKey<?> anyClientKey = api.getClientKey();
        if (this.zahd.containsKey(anyClientKey)) {
            if (this.zahd.get(anyClientKey).isConnected()) {
                return ConnectionResult.RESULT_SUCCESS;
            }
            if (this.zaht.containsKey(anyClientKey)) {
                return this.zaht.get(anyClientKey);
            }
        }
        return null;
    }

    final void zaax() {
        this.zaet.lock();
        try {
            this.zahu = new zaai(this, this.zaex, this.zafa, this.zafc, this.zaci, this.zaet, this.mContext);
            this.zahu.begin();
            this.zahr.signalAll();
            return;
        }
        finally {
            this.zaet.unlock();
        }
    }

    final void zaay() {
        this.zaet.lock();
        try {
            this.zaej.zaau();
            this.zahu = new zaah(this);
            this.zahu.begin();
            this.zahr.signalAll();
            return;
        }
        finally {
            this.zaet.unlock();
        }
    }

    final void zaf(ConnectionResult connectionResult) {
        this.zaet.lock();
        try {
            this.zahv = connectionResult;
            this.zahu = new zaav(this);
            this.zahu.begin();
            this.zahr.signalAll();
            return;
        }
        finally {
            this.zaet.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        return this.zahu instanceof zaah;
    }

    @Override
    public final boolean isConnecting() {
        return this.zahu instanceof zaai;
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        return false;
    }

    @Override
    public final void maybeSignOut() {
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zau() {
        if (this.isConnected()) {
            ((zaah)this.zahu).zaal();
        }
    }

    @Override
    public final void zaa(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, boolean bl) {
        this.zaet.lock();
        try {
            this.zahu.zaa(connectionResult, api, bl);
            return;
        }
        finally {
            this.zaet.unlock();
        }
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        this.zaet.lock();
        try {
            this.zahu.onConnected(bundle);
            return;
        }
        finally {
            this.zaet.unlock();
        }
    }

    @Override
    public final void onConnectionSuspended(int n) {
        this.zaet.lock();
        try {
            this.zahu.onConnectionSuspended(n);
            return;
        }
        finally {
            this.zaet.unlock();
        }
    }

    final void zaa(zabf zabf2) {
        Message message = this.zahs.obtainMessage(1, zabf2);
        this.zahs.sendMessage(message);
    }

    final void zaa(RuntimeException runtimeException) {
        Message message = this.zahs.obtainMessage(2, runtimeException);
        this.zahs.sendMessage(message);
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.zahu);
        for (Api<?> api : this.zafa.keySet()) {
            printWriter.append(string2).append(api.getName()).println(":");
            this.zahd.get(api.getClientKey()).dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ Lock zaa(zabc zabc2) {
        return zabc2.zaet;
    }

    static /* synthetic */ zabd zab(zabc zabc2) {
        return zabc2.zahu;
    }
}

