/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import androidx.collection.ArraySet;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.HasApiKey;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.UnsupportedApiCallException;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.BackgroundDetector;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.RegisterListenerMethod;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.api.internal.UnregisterListenerMethod;
import com.google.android.gms.common.api.internal.zaab;
import com.google.android.gms.common.api.internal.zaac;
import com.google.android.gms.common.api.internal.zaaf;
import com.google.android.gms.common.api.internal.zabh;
import com.google.android.gms.common.api.internal.zabi;
import com.google.android.gms.common.api.internal.zabj;
import com.google.android.gms.common.api.internal.zabk;
import com.google.android.gms.common.api.internal.zabl;
import com.google.android.gms.common.api.internal.zabn;
import com.google.android.gms.common.api.internal.zabu;
import com.google.android.gms.common.api.internal.zabv;
import com.google.android.gms.common.api.internal.zace;
import com.google.android.gms.common.api.internal.zach;
import com.google.android.gms.common.api.internal.zad;
import com.google.android.gms.common.api.internal.zae;
import com.google.android.gms.common.api.internal.zaf;
import com.google.android.gms.common.api.internal.zag;
import com.google.android.gms.common.api.internal.zah;
import com.google.android.gms.common.api.internal.zaj;
import com.google.android.gms.common.api.internal.zap;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.GoogleApiAvailabilityCache;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.SimpleClientAdapter;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public class GoogleApiManager
implements Handler.Callback {
    public static final Status zaia = new Status(4, "Sign-out occurred while this API call was in progress.");
    private static final Status zaib = new Status(4, "The user must be signed in to make this API call.");
    private long zaic = 5000L;
    private long zaid = 120000L;
    private long zaie = 10000L;
    private static final Object lock = new Object();
    @GuardedBy(value="lock")
    private static GoogleApiManager zaif;
    private final Context zaig;
    private final GoogleApiAvailability zaih;
    private final GoogleApiAvailabilityCache zaii;
    private final AtomicInteger zaij = new AtomicInteger(1);
    private final AtomicInteger zaik = new AtomicInteger(0);
    private final Map<ApiKey<?>, zaa<?>> zail = new ConcurrentHashMap(5, 0.75f, 1);
    @GuardedBy(value="lock")
    private zaac zaim = null;
    @GuardedBy(value="lock")
    private final Set<ApiKey<?>> zain = new ArraySet();
    private final Set<ApiKey<?>> zaio = new ArraySet();
    private final Handler handler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GoogleApiManager zab(Context context) {
        Object object = lock;
        synchronized (object) {
            if (zaif == null) {
                HandlerThread handlerThread = new HandlerThread("GoogleApiHandler", 9);
                handlerThread.start();
                Looper looper = handlerThread.getLooper();
                zaif = new GoogleApiManager(context.getApplicationContext(), looper, GoogleApiAvailability.getInstance());
            }
            return zaif;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GoogleApiManager zaaz() {
        Object object = lock;
        synchronized (object) {
            Preconditions.checkNotNull((Object)zaif, (Object)"Must guarantee manager is non-null before using getInstance");
            return zaif;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static void reportSignOut() {
        Object object = lock;
        synchronized (object) {
            if (zaif != null) {
                GoogleApiManager googleApiManager = zaif;
                googleApiManager.zaik.incrementAndGet();
                googleApiManager.handler.sendMessageAtFrontOfQueue(googleApiManager.handler.obtainMessage(10));
            }
            return;
        }
    }

    @KeepForSdk
    private GoogleApiManager(Context context, Looper looper, GoogleApiAvailability googleApiAvailability) {
        this.zaig = context;
        this.handler = new com.google.android.gms.internal.base.zap(looper, this);
        this.zaih = googleApiAvailability;
        this.zaii = new GoogleApiAvailabilityCache(googleApiAvailability);
        this.handler.sendMessage(this.handler.obtainMessage(6));
    }

    public final int zaba() {
        return this.zaij.getAndIncrement();
    }

    public final void zaa(GoogleApi<?> googleApi) {
        this.handler.sendMessage(this.handler.obtainMessage(7, googleApi));
    }

    @WorkerThread
    private final void zab(GoogleApi<?> googleApi) {
        ApiKey<?> apiKey = googleApi.getApiKey();
        zaa<?> zaa2 = this.zail.get(apiKey);
        if (zaa2 == null) {
            zaa2 = new zaa(googleApi);
            this.zail.put(apiKey, zaa2);
        }
        if (zaa2.requiresSignIn()) {
            this.zaio.add(apiKey);
        }
        zaa2.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zaa(@NonNull zaac zaac2) {
        Object object = lock;
        synchronized (object) {
            if (this.zaim != zaac2) {
                this.zaim = zaac2;
                this.zain.clear();
            }
            this.zain.addAll((Collection<ApiKey<?>>)zaac2.zaah());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zab(@NonNull zaac zaac2) {
        Object object = lock;
        synchronized (object) {
            if (this.zaim == zaac2) {
                this.zaim = null;
                this.zain.clear();
            }
            return;
        }
    }

    public final Task<Map<ApiKey<?>, String>> zaa(Iterable<? extends HasApiKey<?>> iterable) {
        zaj zaj2 = new zaj(iterable);
        this.handler.sendMessage(this.handler.obtainMessage(2, (Object)zaj2));
        return zaj2.getTask();
    }

    public final void zam() {
        this.handler.sendMessage(this.handler.obtainMessage(3));
    }

    final void maybeSignOut() {
        this.zaik.incrementAndGet();
        this.handler.sendMessage(this.handler.obtainMessage(10));
    }

    public final Task<Boolean> zac(GoogleApi<?> googleApi) {
        zaaf zaaf2 = new zaaf(googleApi.getApiKey());
        this.handler.sendMessage(this.handler.obtainMessage(14, (Object)zaaf2));
        return zaaf2.zaaj().getTask();
    }

    public final <O extends Api.ApiOptions> void zaa(GoogleApi<O> googleApi, int n, BaseImplementation.ApiMethodImpl<? extends Result, Api.AnyClient> apiMethodImpl) {
        zaf<BaseImplementation.ApiMethodImpl<? extends Result, Api.AnyClient>> zaf2 = new zaf<BaseImplementation.ApiMethodImpl<? extends Result, Api.AnyClient>>(n, apiMethodImpl);
        this.handler.sendMessage(this.handler.obtainMessage(4, (Object)new zabu(zaf2, this.zaik.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions, ResultT> void zaa(GoogleApi<O> googleApi, int n, TaskApiCall<Api.AnyClient, ResultT> taskApiCall, TaskCompletionSource<ResultT> taskCompletionSource, StatusExceptionMapper statusExceptionMapper) {
        zah<ResultT> zah2 = new zah<ResultT>(n, taskApiCall, taskCompletionSource, statusExceptionMapper);
        this.handler.sendMessage(this.handler.obtainMessage(4, (Object)new zabu(zah2, this.zaik.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions> Task<Void> zaa(@NonNull GoogleApi<O> googleApi, @NonNull RegisterListenerMethod<Api.AnyClient, ?> registerListenerMethod, @NonNull UnregisterListenerMethod<Api.AnyClient, ?> unregisterListenerMethod, @NonNull Runnable runnable) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zae zae2 = new zae(new zabv(registerListenerMethod, unregisterListenerMethod, runnable), (TaskCompletionSource<Void>)taskCompletionSource);
        this.handler.sendMessage(this.handler.obtainMessage(8, (Object)new zabu(zae2, this.zaik.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    public final <O extends Api.ApiOptions> Task<Boolean> zaa(@NonNull GoogleApi<O> googleApi, @NonNull ListenerHolder.ListenerKey<?> listenerKey) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zag zag2 = new zag(listenerKey, (TaskCompletionSource<Boolean>)taskCompletionSource);
        this.handler.sendMessage(this.handler.obtainMessage(13, (Object)new zabu(zag2, this.zaik.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    @WorkerThread
    public boolean handleMessage(Message message) {
        block0 : switch (message.what) {
            case 1: {
                boolean bl = (Boolean)message.obj;
                GoogleApiManager googleApiManager = this;
                this.zaie = bl ? 10000L : 300000L;
                googleApiManager.handler.removeMessages(12);
                for (ApiKey<?> apiKey : googleApiManager.zail.keySet()) {
                    googleApiManager.handler.sendMessageDelayed(googleApiManager.handler.obtainMessage(12, apiKey), googleApiManager.zaie);
                }
                break;
            }
            case 2: {
                zaj zaj2 = (zaj)message.obj;
                GoogleApiManager googleApiManager = this;
                for (ApiKey<?> apiKey : zaj2.zan()) {
                    zaa<?> zaa2 = googleApiManager.zail.get(apiKey);
                    if (zaa2 == null) {
                        ConnectionResult connectionResult = new ConnectionResult(13);
                        zaj2.zaa(apiKey, connectionResult, null);
                        break block0;
                    }
                    if (zaa2.isConnected()) {
                        zaj2.zaa(apiKey, ConnectionResult.RESULT_SUCCESS, zaa2.zaz().getEndpointPackageName());
                        continue;
                    }
                    if (zaa2.zabk() != null) {
                        zaj2.zaa(apiKey, zaa2.zabk(), null);
                        continue;
                    }
                    zaa2.zaa(zaj2);
                    zaa2.connect();
                }
                break;
            }
            case 3: {
                for (zaa<?> zaa3 : this.zail.values()) {
                    zaa3.zabj();
                    zaa3.connect();
                }
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                zabu zabu2 = (zabu)message.obj;
                GoogleApiManager googleApiManager = this;
                zaa<?> zaa4 = googleApiManager.zail.get(zabu2.zaka.getApiKey());
                if (zaa4 == null) {
                    googleApiManager.zab(zabu2.zaka);
                    zaa4 = googleApiManager.zail.get(zabu2.zaka.getApiKey());
                }
                if (zaa4.requiresSignIn() && googleApiManager.zaik.get() != zabu2.zajz) {
                    zabu2.zajy.zaa(zaia);
                    zaa4.zabh();
                    break;
                }
                zaa4.zaa(zabu2.zajy);
                break;
            }
            case 5: {
                ConnectionResult connectionResult = (ConnectionResult)message.obj;
                int n = message.arg1;
                GoogleApiManager googleApiManager = this;
                zaa<?> zaa5 = null;
                for (zaa<?> zaa6 : googleApiManager.zail.values()) {
                    if (zaa6.getInstanceId() != n) continue;
                    zaa5 = zaa6;
                    break;
                }
                if (zaa5 != null) {
                    zaa<?> zaa6;
                    String string2 = googleApiManager.zaih.getErrorString(connectionResult.getErrorCode());
                    zaa6 = connectionResult.getErrorMessage();
                    ((zaa)zaa5).zac(new Status(17, new StringBuilder(69 + String.valueOf(string2).length() + String.valueOf(zaa6).length()).append("Error resolution was canceled by the user, original error message: ").append(string2).append(": ").append((String)((Object)zaa6)).toString()));
                    break;
                }
                Log.wtf((String)"GoogleApiManager", (String)new StringBuilder(76).append("Could not find API instance ").append(n).append(" while trying to fail enqueued calls.").toString(), (Throwable)new Exception());
                break;
            }
            case 6: {
                GoogleApiManager googleApiManager = this;
                if (!(googleApiManager.zaig.getApplicationContext() instanceof Application)) break;
                BackgroundDetector.initialize((Application)((Application)googleApiManager.zaig.getApplicationContext()));
                BackgroundDetector.getInstance().addListener((BackgroundDetector.BackgroundStateChangeListener)new zabh(googleApiManager));
                if (BackgroundDetector.getInstance().readCurrentStateIfPossible(true)) break;
                googleApiManager.zaie = 300000L;
                break;
            }
            case 7: {
                this.zab((GoogleApi)message.obj);
                break;
            }
            case 9: {
                if (!this.zail.containsKey(message.obj)) break;
                this.zail.get(message.obj).resume();
                break;
            }
            case 10: {
                GoogleApiManager googleApiManager = this;
                for (ApiKey<?> apiKey : googleApiManager.zaio) {
                    googleApiManager.zail.remove(apiKey).zabh();
                }
                googleApiManager.zaio.clear();
                break;
            }
            case 11: {
                if (!this.zail.containsKey(message.obj)) break;
                this.zail.get(message.obj).zaat();
                break;
            }
            case 12: {
                if (!this.zail.containsKey(message.obj)) break;
                this.zail.get(message.obj).zabn();
                break;
            }
            case 14: {
                zaaf zaaf2 = (zaaf)message.obj;
                GoogleApiManager googleApiManager = this;
                ApiKey<?> apiKey = zaaf2.getApiKey();
                if (!googleApiManager.zail.containsKey(apiKey)) {
                    zaaf2.zaaj().setResult((Object)false);
                    break;
                }
                boolean bl = ((zaa)googleApiManager.zail.get(apiKey)).zac(false);
                zaaf2.zaaj().setResult((Object)bl);
                break;
            }
            case 15: {
                zab zab2 = (zab)message.obj;
                if (!this.zail.containsKey(zab2.zaje)) break;
                ((zaa)this.zail.get(zab2.zaje)).zaa(zab2);
                break;
            }
            case 16: {
                zab zab3 = (zab)message.obj;
                if (!this.zail.containsKey(zab3.zaje)) break;
                ((zaa)this.zail.get(zab3.zaje)).zab(zab3);
                break;
            }
            default: {
                int n = message.what;
                Log.w((String)"GoogleApiManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                return false;
            }
        }
        return true;
    }

    final PendingIntent zaa(ApiKey<?> apiKey, int n) {
        zaa<?> zaa2 = this.zail.get(apiKey);
        if (zaa2 == null) {
            return null;
        }
        com.google.android.gms.signin.zad zad2 = zaa2.zabo();
        if (zad2 == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.zaig, (int)n, (Intent)zad2.getSignInIntent(), (int)0x8000000);
    }

    final boolean zac(ConnectionResult connectionResult, int n) {
        return this.zaih.zaa(this.zaig, connectionResult, n);
    }

    public final void zaa(ConnectionResult connectionResult, int n) {
        if (!this.zac(connectionResult, n)) {
            this.handler.sendMessage(this.handler.obtainMessage(5, n, 0, (Object)connectionResult));
        }
    }

    private static final class zab {
        private final ApiKey<?> zaje;
        private final Feature zajf;

        private zab(ApiKey<?> apiKey, Feature feature) {
            this.zaje = apiKey;
            this.zajf = feature;
        }

        public final boolean equals(Object object) {
            if (object != null && object instanceof zab) {
                zab zab2 = (zab)object;
                return Objects.equal(this.zaje, zab2.zaje) && Objects.equal((Object)this.zajf, (Object)zab2.zajf);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.zaje, this.zajf});
        }

        public final String toString() {
            return Objects.toStringHelper((Object)this).add("key", this.zaje).add("feature", (Object)this.zajf).toString();
        }

        /* synthetic */ zab(ApiKey apiKey, Feature feature, zabh zabh2) {
            this(apiKey, feature);
        }
    }

    private final class zac
    implements zach,
    BaseGmsClient.ConnectionProgressReportCallbacks {
        private final Api.Client zair;
        private final ApiKey<?> zafv;
        private IAccountAccessor zaji = null;
        private Set<Scope> zajj = null;
        private boolean zajk = false;

        public zac(Api.Client client, ApiKey<?> apiKey) {
            this.zair = client;
            this.zafv = apiKey;
        }

        public final void onReportServiceBinding(@NonNull ConnectionResult connectionResult) {
            GoogleApiManager.this.handler.post((Runnable)new zabn(this, connectionResult));
        }

        @Override
        @WorkerThread
        public final void zag(ConnectionResult connectionResult) {
            ((zaa)GoogleApiManager.this.zail.get(this.zafv)).zag(connectionResult);
        }

        @Override
        @WorkerThread
        public final void zaa(IAccountAccessor iAccountAccessor, Set<Scope> set) {
            if (iAccountAccessor == null || set == null) {
                Log.wtf((String)"GoogleApiManager", (String)"Received null response from onSignInSuccess", (Throwable)new Exception());
                this.zag(new ConnectionResult(4));
                return;
            }
            this.zaji = iAccountAccessor;
            this.zajj = set;
            this.zabp();
        }

        @WorkerThread
        private final void zabp() {
            if (this.zajk && this.zaji != null) {
                this.zair.getRemoteService(this.zaji, this.zajj);
            }
        }

        static /* synthetic */ ApiKey zaa(zac zac2) {
            return zac2.zafv;
        }

        static /* synthetic */ boolean zaa(zac zac2, boolean bl) {
            zac2.zajk = true;
            return true;
        }

        static /* synthetic */ Api.Client zab(zac zac2) {
            return zac2.zair;
        }

        static /* synthetic */ void zac(zac zac2) {
            zac2.zabp();
        }
    }

    public final class zaa<O extends Api.ApiOptions>
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener,
    zap {
        private final Queue<com.google.android.gms.common.api.internal.zab> zaiq = new LinkedList<com.google.android.gms.common.api.internal.zab>();
        private final Api.Client zair;
        private final Api.AnyClient zais;
        private final ApiKey<O> zafv;
        private final zaab zait;
        private final Set<zaj> zaiu = new HashSet<zaj>();
        private final Map<ListenerHolder.ListenerKey<?>, zabv> zaiv = new HashMap();
        private final int zaiw;
        private final zace zaix;
        private boolean zaiy;
        private final List<zab> zaiz = new ArrayList<zab>();
        private ConnectionResult zaja = null;

        @WorkerThread
        public zaa(GoogleApi<O> googleApi) {
            this.zair = googleApi.zaa(GoogleApiManager.this.handler.getLooper(), this);
            this.zais = this.zair instanceof SimpleClientAdapter ? ((SimpleClientAdapter)this.zair).getClient() : this.zair;
            this.zafv = googleApi.getApiKey();
            this.zait = new zaab();
            this.zaiw = googleApi.getInstanceId();
            if (this.zair.requiresSignIn()) {
                this.zaix = googleApi.zaa(GoogleApiManager.this.zaig, GoogleApiManager.this.handler);
                return;
            }
            this.zaix = null;
        }

        @Override
        public final void onConnected(@Nullable Bundle bundle) {
            if (Looper.myLooper() == GoogleApiManager.this.handler.getLooper()) {
                this.zabe();
                return;
            }
            GoogleApiManager.this.handler.post((Runnable)new zabj(this));
        }

        @WorkerThread
        private final void zabe() {
            this.zabj();
            this.zai(ConnectionResult.RESULT_SUCCESS);
            this.zabl();
            Iterator<zabv> iterator = this.zaiv.values().iterator();
            while (iterator.hasNext()) {
                zabv zabv2 = iterator.next();
                if (this.zaa(zabv2.zake.getRequiredFeatures()) != null) {
                    iterator.remove();
                    continue;
                }
                try {
                    zabv2.zake.registerListener(this.zais, (TaskCompletionSource<Void>)new TaskCompletionSource());
                }
                catch (DeadObjectException deadObjectException) {
                    this.onConnectionSuspended(1);
                    this.zair.disconnect();
                    break;
                }
                catch (RemoteException remoteException) {
                    iterator.remove();
                }
            }
            this.zabg();
            this.zabm();
        }

        @Override
        public final void onConnectionSuspended(int n) {
            if (Looper.myLooper() == GoogleApiManager.this.handler.getLooper()) {
                this.zabf();
                return;
            }
            GoogleApiManager.this.handler.post((Runnable)new zabi(this));
        }

        @WorkerThread
        private final void zabf() {
            this.zabj();
            this.zaiy = true;
            this.zait.zaag();
            GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.handler, (int)9, this.zafv), GoogleApiManager.this.zaic);
            GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.handler, (int)11, this.zafv), GoogleApiManager.this.zaid);
            GoogleApiManager.this.zaii.flush();
            Iterator<zabv> iterator = this.zaiv.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().zakd.run();
            }
        }

        @WorkerThread
        public final void zag(@NonNull ConnectionResult connectionResult) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            this.zair.disconnect();
            this.onConnectionFailed(connectionResult);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private final boolean zah(@NonNull ConnectionResult connectionResult) {
            Object object = lock;
            synchronized (object) {
                if (GoogleApiManager.this.zaim != null && GoogleApiManager.this.zain.contains(this.zafv)) {
                    GoogleApiManager.this.zaim.zab(connectionResult, this.zaiw);
                    return true;
                }
                return false;
            }
        }

        @Override
        public final void zaa(ConnectionResult connectionResult, Api<?> api, boolean bl) {
            if (Looper.myLooper() == GoogleApiManager.this.handler.getLooper()) {
                this.onConnectionFailed(connectionResult);
                return;
            }
            GoogleApiManager.this.handler.post((Runnable)new zabl(this, connectionResult));
        }

        @Override
        @WorkerThread
        public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            this.zaa(connectionResult, null);
        }

        @WorkerThread
        private final void zaa(@NonNull ConnectionResult connectionResult, @Nullable Exception exception) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zaix != null) {
                this.zaix.zabq();
            }
            this.zabj();
            GoogleApiManager.this.zaii.flush();
            this.zai(connectionResult);
            if (connectionResult.getErrorCode() == 4) {
                this.zac(zaib);
                return;
            }
            if (this.zaiq.isEmpty()) {
                this.zaja = connectionResult;
                return;
            }
            if (exception != null) {
                Exception exception2 = exception;
                zaa zaa2 = this;
                Preconditions.checkHandlerThread((Handler)zaa2.GoogleApiManager.this.handler);
                zaa2.zaa(null, exception2, false);
                return;
            }
            this.zaa(this.zaj(connectionResult), null, true);
            if (this.zaiq.isEmpty()) {
                return;
            }
            if (this.zah(connectionResult)) {
                return;
            }
            if (!GoogleApiManager.this.zac(connectionResult, this.zaiw)) {
                if (connectionResult.getErrorCode() == 18) {
                    this.zaiy = true;
                }
                if (this.zaiy) {
                    GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.handler, (int)9, this.zafv), GoogleApiManager.this.zaic);
                    return;
                }
                this.zac(this.zaj(connectionResult));
            }
        }

        @WorkerThread
        private final void zabg() {
            ArrayList<com.google.android.gms.common.api.internal.zab> arrayList = new ArrayList<com.google.android.gms.common.api.internal.zab>(this.zaiq);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                com.google.android.gms.common.api.internal.zab zab2 = arrayList.get(i);
                com.google.android.gms.common.api.internal.zab zab3 = zab2;
                if (!this.zair.isConnected()) break;
                if (!this.zab(zab3)) continue;
                this.zaiq.remove(zab3);
            }
        }

        @WorkerThread
        public final void zaa(com.google.android.gms.common.api.internal.zab zab2) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zair.isConnected()) {
                if (this.zab(zab2)) {
                    this.zabm();
                    return;
                }
                this.zaiq.add(zab2);
                return;
            }
            this.zaiq.add(zab2);
            if (this.zaja != null && this.zaja.hasResolution()) {
                this.onConnectionFailed(this.zaja);
                return;
            }
            this.connect();
        }

        @WorkerThread
        public final void zabh() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            this.zac(zaia);
            this.zait.zaaf();
            for (ListenerHolder.ListenerKey listenerKey : this.zaiv.keySet().toArray(new ListenerHolder.ListenerKey[this.zaiv.size()])) {
                this.zaa(new zag(listenerKey, (TaskCompletionSource<Boolean>)new TaskCompletionSource()));
            }
            this.zai(new ConnectionResult(4));
            if (this.zair.isConnected()) {
                this.zair.onUserSignOut(new zabk(this));
            }
        }

        public final Api.Client zaz() {
            return this.zair;
        }

        public final Map<ListenerHolder.ListenerKey<?>, zabv> zabi() {
            return this.zaiv;
        }

        @WorkerThread
        public final void zabj() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            this.zaja = null;
        }

        @WorkerThread
        public final ConnectionResult zabk() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            return this.zaja;
        }

        @WorkerThread
        private final boolean zab(com.google.android.gms.common.api.internal.zab zab2) {
            if (!(zab2 instanceof zad)) {
                this.zac(zab2);
                return true;
            }
            zad zad2 = (zad)zab2;
            Feature feature = this.zaa(zad2.zac(this));
            if (feature == null) {
                this.zac(zab2);
                return true;
            }
            String string2 = this.zais.getClass().getName();
            String string3 = feature.getName();
            long l = feature.getVersion();
            Log.w((String)"GoogleApiManager", (String)new StringBuilder(77 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(" could not execute call because it requires feature (").append(string3).append(", ").append(l).append(").").toString());
            if (zad2.zad(this)) {
                Feature feature2 = feature;
                zaa zaa2 = this;
                zab zab3 = new zab(zaa2.zafv, feature2, null);
                int n = zaa2.zaiz.indexOf(zab3);
                if (n >= 0) {
                    zab zab4 = zaa2.zaiz.get(n);
                    zaa2.GoogleApiManager.this.handler.removeMessages(15, (Object)zab4);
                    zaa2.GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)zaa2.GoogleApiManager.this.handler, (int)15, (Object)zab4), zaa2.GoogleApiManager.this.zaic);
                } else {
                    zaa2.zaiz.add(zab3);
                    zaa2.GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)zaa2.GoogleApiManager.this.handler, (int)15, (Object)zab3), zaa2.GoogleApiManager.this.zaic);
                    zaa2.GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)zaa2.GoogleApiManager.this.handler, (int)16, (Object)zab3), zaa2.GoogleApiManager.this.zaid);
                    ConnectionResult connectionResult = new ConnectionResult(2, null);
                    if (!zaa2.zah(connectionResult)) {
                        zaa2.GoogleApiManager.this.zac(connectionResult, zaa2.zaiw);
                    }
                }
                return false;
            }
            zad2.zaa((Exception)new UnsupportedApiCallException(feature));
            return true;
        }

        @WorkerThread
        private final void zac(com.google.android.gms.common.api.internal.zab zab2) {
            zab2.zaa(this.zait, this.requiresSignIn());
            try {
                zab2.zaa(this);
                return;
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(1);
                this.zair.disconnect();
                return;
            }
            catch (Throwable throwable) {
                String string2 = String.format("Error in GoogleApi implementation for client %s.", this.zais.getClass().getName());
                throw new IllegalStateException(string2, throwable);
            }
        }

        @WorkerThread
        private final void zaa(@Nullable Status status, @Nullable Exception exception, boolean bl) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (status == null == (exception == null)) {
                throw new IllegalArgumentException("Status XOR exception should be null");
            }
            Iterator iterator = this.zaiq.iterator();
            while (iterator.hasNext()) {
                com.google.android.gms.common.api.internal.zab zab2 = (com.google.android.gms.common.api.internal.zab)iterator.next();
                if (bl && zab2.type != 2) continue;
                if (status != null) {
                    zab2.zaa(status);
                } else {
                    zab2.zaa(exception);
                }
                iterator.remove();
            }
        }

        @WorkerThread
        private final void zac(Status status) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            this.zaa(status, null, false);
        }

        @WorkerThread
        public final void resume() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zaiy) {
                this.connect();
            }
        }

        @WorkerThread
        private final void zabl() {
            if (this.zaiy) {
                GoogleApiManager.this.handler.removeMessages(11, this.zafv);
                GoogleApiManager.this.handler.removeMessages(9, this.zafv);
                this.zaiy = false;
            }
        }

        @WorkerThread
        public final void zaat() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zaiy) {
                this.zabl();
                Status status = GoogleApiManager.this.zaih.isGooglePlayServicesAvailable(GoogleApiManager.this.zaig) == 18 ? new Status(8, "Connection timed out while waiting for Google Play services update to complete.") : new Status(8, "API failed to connect while resuming due to an unknown error.");
                this.zac(status);
                this.zair.disconnect();
            }
        }

        private final void zabm() {
            GoogleApiManager.this.handler.removeMessages(12, this.zafv);
            GoogleApiManager.this.handler.sendMessageDelayed(GoogleApiManager.this.handler.obtainMessage(12, this.zafv), GoogleApiManager.this.zaie);
        }

        @WorkerThread
        public final boolean zabn() {
            return this.zac(true);
        }

        @WorkerThread
        private final boolean zac(boolean bl) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zair.isConnected() && this.zaiv.size() == 0) {
                if (this.zait.zaae()) {
                    if (bl) {
                        this.zabm();
                    }
                    return false;
                }
                this.zair.disconnect();
                return true;
            }
            return false;
        }

        @WorkerThread
        public final void connect() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zair.isConnected() || this.zair.isConnecting()) {
                return;
            }
            try {
                int n = GoogleApiManager.this.zaii.getClientAvailability(GoogleApiManager.this.zaig, this.zair);
                if (n != 0) {
                    ConnectionResult connectionResult = new ConnectionResult(n, null);
                    String string2 = this.zais.getClass().getName();
                    String string3 = String.valueOf(connectionResult);
                    Log.w((String)"GoogleApiManager", (String)new StringBuilder(35 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("The service for ").append(string2).append(" is not available: ").append(string3).toString());
                    this.onConnectionFailed(connectionResult);
                    return;
                }
            }
            catch (IllegalStateException illegalStateException) {
                ConnectionResult connectionResult = new ConnectionResult(10);
                this.zaa(connectionResult, illegalStateException);
                return;
            }
            zac zac2 = new zac(this.zair, this.zafv);
            if (this.zair.requiresSignIn()) {
                this.zaix.zaa(zac2);
            }
            try {
                this.zair.connect(zac2);
                return;
            }
            catch (SecurityException securityException) {
                ConnectionResult connectionResult = new ConnectionResult(10);
                this.zaa(connectionResult, securityException);
                return;
            }
        }

        @WorkerThread
        public final void zaa(zaj zaj2) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            this.zaiu.add(zaj2);
        }

        @WorkerThread
        private final void zai(ConnectionResult connectionResult) {
            for (zaj zaj2 : this.zaiu) {
                String string2 = null;
                if (Objects.equal((Object)connectionResult, (Object)ConnectionResult.RESULT_SUCCESS)) {
                    string2 = this.zair.getEndpointPackageName();
                }
                zaj2.zaa(this.zafv, connectionResult, string2);
            }
            this.zaiu.clear();
        }

        final boolean isConnected() {
            return this.zair.isConnected();
        }

        public final boolean requiresSignIn() {
            return this.zair.requiresSignIn();
        }

        public final int getInstanceId() {
            return this.zaiw;
        }

        final com.google.android.gms.signin.zad zabo() {
            if (this.zaix == null) {
                return null;
            }
            return this.zaix.zabo();
        }

        @WorkerThread
        @Nullable
        private final Feature zaa(@Nullable Feature[] featureArray) {
            Feature feature;
            int n;
            if (featureArray == null || featureArray.length == 0) {
                return null;
            }
            Feature[] featureArray2 = this.zair.getAvailableFeatures();
            if (featureArray2 == null) {
                featureArray2 = new Feature[]{};
            }
            ArrayMap arrayMap = new ArrayMap(featureArray2.length);
            Feature[] featureArray3 = featureArray2;
            int n2 = featureArray2.length;
            for (n = 0; n < n2; ++n) {
                feature = featureArray3[n];
                arrayMap.put(feature.getName(), feature.getVersion());
            }
            featureArray3 = featureArray;
            n2 = featureArray.length;
            for (n = 0; n < n2; ++n) {
                feature = featureArray3[n];
                if (arrayMap.containsKey(feature.getName()) && (Long)arrayMap.get(feature.getName()) >= feature.getVersion()) continue;
                return feature;
            }
            return null;
        }

        @WorkerThread
        private final void zaa(zab zab2) {
            if (!this.zaiz.contains(zab2)) {
                return;
            }
            if (!this.zaiy) {
                if (!this.zair.isConnected()) {
                    this.connect();
                    return;
                }
                this.zabg();
            }
        }

        @WorkerThread
        private final void zab(zab zab2) {
            if (this.zaiz.remove(zab2)) {
                GoogleApiManager.this.handler.removeMessages(15, (Object)zab2);
                GoogleApiManager.this.handler.removeMessages(16, (Object)zab2);
                Feature feature = zab2.zajf;
                zaa zaa2 = this;
                ArrayList<com.google.android.gms.common.api.internal.zab> arrayList = new ArrayList<com.google.android.gms.common.api.internal.zab>(zaa2.zaiq.size());
                for (com.google.android.gms.common.api.internal.zab zab3 : zaa2.zaiq) {
                    Object[] objectArray;
                    if (!(zab3 instanceof zad) || (objectArray = ((zad)zab3).zac(zaa2)) == null || !ArrayUtils.contains((Object[])objectArray, (Object)feature)) continue;
                    arrayList.add(zab3);
                }
                ArrayList<com.google.android.gms.common.api.internal.zab> arrayList2 = arrayList;
                int n = arrayList2.size();
                for (int i = 0; i < n; ++i) {
                    com.google.android.gms.common.api.internal.zab zab3;
                    Object e = arrayList2.get(i);
                    zab3 = (com.google.android.gms.common.api.internal.zab)e;
                    zaa2.zaiq.remove(zab3);
                    zab3.zaa((Exception)new UnsupportedApiCallException(feature));
                }
            }
        }

        private final Status zaj(ConnectionResult connectionResult) {
            String string2 = this.zafv.getApiName();
            String string3 = String.valueOf(connectionResult);
            return new Status(17, new StringBuilder(63 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("API: ").append(string2).append(" is not available on this device. Connection failed with: ").append(string3).toString());
        }

        static /* synthetic */ void zae(zaa zaa2) {
            zaa2.zabe();
        }

        static /* synthetic */ void zaf(zaa zaa2) {
            zaa2.zabf();
        }

        static /* synthetic */ Api.Client zag(zaa zaa2) {
            return zaa2.zair;
        }
    }
}

