/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zab;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ClientIdentityCreator")
@KeepForSdk
public class ClientIdentity
extends AbstractSafeParcelable {
    @SafeParcelable.Field(id=1, defaultValueUnchecked="0")
    private final int uid;
    @SafeParcelable.Field(id=2, defaultValueUnchecked="null")
    @Nullable
    private final String packageName;
    @KeepForSdk
    public static final Parcelable.Creator<ClientIdentity> CREATOR = new zab();

    @SafeParcelable.Constructor
    public ClientIdentity(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) @Nullable String string2) {
        this.uid = n;
        this.packageName = string2;
    }

    public int hashCode() {
        return this.uid;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof ClientIdentity)) {
            return false;
        }
        ClientIdentity clientIdentity = (ClientIdentity)((Object)object);
        return clientIdentity.uid == this.uid && Objects.equal((Object)clientIdentity.packageName, (Object)this.packageName);
    }

    public String toString() {
        int n = this.uid;
        String string2 = this.packageName;
        return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(":").append(string2).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ClientIdentity clientIdentity = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)clientIdentity.uid);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)clientIdentity.packageName, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

