/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.AbstractDataBuffer;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

@KeepForSdk
public class DataBufferSafeParcelable<T extends SafeParcelable>
extends AbstractDataBuffer<T> {
    private static final String[] zalr = new String[]{"data"};
    private final Parcelable.Creator<T> zals;

    @KeepForSdk
    public DataBufferSafeParcelable(DataHolder dataHolder, Parcelable.Creator<T> creator) {
        super(dataHolder);
        this.zals = creator;
    }

    @KeepForSdk
    public static DataHolder.Builder buildDataHolder() {
        return DataHolder.builder(zalr);
    }

    @KeepForSdk
    public static <T extends SafeParcelable> void addValue(DataHolder.Builder builder, T t) {
        Parcel parcel = Parcel.obtain();
        t.writeToParcel(parcel, 0);
        ContentValues contentValues = new ContentValues();
        contentValues.put("data", parcel.marshall());
        builder.withRow(contentValues);
        parcel.recycle();
    }

    @Override
    @KeepForSdk
    public T get(int n) {
        byte[] byArray = this.mDataHolder.getByteArray("data", n, this.mDataHolder.getWindowIndex(n));
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        SafeParcelable safeParcelable = (SafeParcelable)this.zals.createFromParcel(parcel);
        parcel.recycle();
        return (T)safeParcelable;
    }
}

