/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import androidx.collection.ArraySet;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.HasApiKey;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.UnsupportedApiCallException;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.BackgroundDetector;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.RegisterListenerMethod;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.api.internal.UnregisterListenerMethod;
import com.google.android.gms.common.api.internal.zaad;
import com.google.android.gms.common.api.internal.zaae;
import com.google.android.gms.common.api.internal.zabh;
import com.google.android.gms.common.api.internal.zabi;
import com.google.android.gms.common.api.internal.zabj;
import com.google.android.gms.common.api.internal.zabk;
import com.google.android.gms.common.api.internal.zabm;
import com.google.android.gms.common.api.internal.zabo;
import com.google.android.gms.common.api.internal.zabu;
import com.google.android.gms.common.api.internal.zabv;
import com.google.android.gms.common.api.internal.zace;
import com.google.android.gms.common.api.internal.zacf;
import com.google.android.gms.common.api.internal.zad;
import com.google.android.gms.common.api.internal.zaf;
import com.google.android.gms.common.api.internal.zag;
import com.google.android.gms.common.api.internal.zah;
import com.google.android.gms.common.api.internal.zaj;
import com.google.android.gms.common.api.internal.zar;
import com.google.android.gms.common.api.internal.zaz;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.GoogleApiAvailabilityCache;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.SimpleClientAdapter;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public class GoogleApiManager
implements Handler.Callback {
    public static final Status zaib = new Status(4, "Sign-out occurred while this API call was in progress.");
    private static final Status zaic = new Status(4, "The user must be signed in to make this API call.");
    private long zaid = 5000L;
    private long zaie = 120000L;
    private long zaif = 10000L;
    private static final Object lock = new Object();
    @GuardedBy(value="lock")
    private static GoogleApiManager zaig;
    private final Context zaih;
    private final GoogleApiAvailability zaii;
    private final GoogleApiAvailabilityCache zaij;
    private final AtomicInteger zaik = new AtomicInteger(1);
    private final AtomicInteger zail = new AtomicInteger(0);
    private final Map<ApiKey<?>, zaa<?>> zaim = new ConcurrentHashMap(5, 0.75f, 1);
    @GuardedBy(value="lock")
    private zaad zain = null;
    @GuardedBy(value="lock")
    private final Set<ApiKey<?>> zaio = new ArraySet();
    private final Set<ApiKey<?>> zaip = new ArraySet();
    private final Handler handler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GoogleApiManager zab(Context context) {
        Object object = lock;
        synchronized (object) {
            if (zaig == null) {
                HandlerThread handlerThread = new HandlerThread("GoogleApiHandler", 9);
                handlerThread.start();
                Looper looper = handlerThread.getLooper();
                zaig = new GoogleApiManager(context.getApplicationContext(), looper, GoogleApiAvailability.getInstance());
            }
            return zaig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GoogleApiManager zaba() {
        Object object = lock;
        synchronized (object) {
            Preconditions.checkNotNull((Object)zaig, (Object)"Must guarantee manager is non-null before using getInstance");
            return zaig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static void reportSignOut() {
        Object object = lock;
        synchronized (object) {
            if (zaig != null) {
                GoogleApiManager googleApiManager = zaig;
                googleApiManager.zail.incrementAndGet();
                googleApiManager.handler.sendMessageAtFrontOfQueue(googleApiManager.handler.obtainMessage(10));
            }
            return;
        }
    }

    @KeepForSdk
    private GoogleApiManager(Context context, Looper looper, GoogleApiAvailability googleApiAvailability) {
        this.zaih = context;
        this.handler = new com.google.android.gms.internal.base.zar(looper, this);
        this.zaii = googleApiAvailability;
        this.zaij = new GoogleApiAvailabilityCache(googleApiAvailability);
        this.handler.sendMessage(this.handler.obtainMessage(6));
    }

    public final int zabb() {
        return this.zaik.getAndIncrement();
    }

    public final void zaa(GoogleApi<?> googleApi) {
        this.handler.sendMessage(this.handler.obtainMessage(7, googleApi));
    }

    @WorkerThread
    private final void zab(GoogleApi<?> googleApi) {
        ApiKey<?> apiKey = googleApi.getApiKey();
        zaa<?> zaa2 = this.zaim.get(apiKey);
        if (zaa2 == null) {
            zaa2 = new zaa(googleApi);
            this.zaim.put(apiKey, zaa2);
        }
        if (zaa2.requiresSignIn()) {
            this.zaip.add(apiKey);
        }
        zaa2.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zaa(@NonNull zaad zaad2) {
        Object object = lock;
        synchronized (object) {
            if (this.zain != zaad2) {
                this.zain = zaad2;
                this.zaio.clear();
            }
            this.zaio.addAll((Collection<ApiKey<?>>)zaad2.zaah());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zab(@NonNull zaad zaad2) {
        Object object = lock;
        synchronized (object) {
            if (this.zain == zaad2) {
                this.zain = null;
                this.zaio.clear();
            }
            return;
        }
    }

    public final Task<Map<ApiKey<?>, String>> zaa(Iterable<? extends HasApiKey<?>> iterable) {
        zaj zaj2 = new zaj(iterable);
        this.handler.sendMessage(this.handler.obtainMessage(2, (Object)zaj2));
        return zaj2.getTask();
    }

    public final void zam() {
        this.handler.sendMessage(this.handler.obtainMessage(3));
    }

    final void maybeSignOut() {
        this.zail.incrementAndGet();
        this.handler.sendMessage(this.handler.obtainMessage(10));
    }

    public final Task<Boolean> zac(GoogleApi<?> googleApi) {
        zaae zaae2 = new zaae(googleApi.getApiKey());
        this.handler.sendMessage(this.handler.obtainMessage(14, (Object)zaae2));
        return zaae2.zaaj().getTask();
    }

    public final <O extends Api.ApiOptions> void zaa(GoogleApi<O> googleApi, int n, BaseImplementation.ApiMethodImpl<? extends Result, Api.AnyClient> apiMethodImpl) {
        zad<BaseImplementation.ApiMethodImpl<? extends Result, Api.AnyClient>> zad2 = new zad<BaseImplementation.ApiMethodImpl<? extends Result, Api.AnyClient>>(n, apiMethodImpl);
        this.handler.sendMessage(this.handler.obtainMessage(4, (Object)new zabu(zad2, this.zail.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions, ResultT> void zaa(GoogleApi<O> googleApi, int n, TaskApiCall<Api.AnyClient, ResultT> taskApiCall, TaskCompletionSource<ResultT> taskCompletionSource, StatusExceptionMapper statusExceptionMapper) {
        zaf<ResultT> zaf2 = new zaf<ResultT>(n, taskApiCall, taskCompletionSource, statusExceptionMapper);
        this.handler.sendMessage(this.handler.obtainMessage(4, (Object)new zabu(zaf2, this.zail.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions> Task<Void> zaa(@NonNull GoogleApi<O> googleApi, @NonNull RegisterListenerMethod<Api.AnyClient, ?> registerListenerMethod, @NonNull UnregisterListenerMethod<Api.AnyClient, ?> unregisterListenerMethod) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zag zag2 = new zag(new zabv(registerListenerMethod, unregisterListenerMethod), (TaskCompletionSource<Void>)taskCompletionSource);
        this.handler.sendMessage(this.handler.obtainMessage(8, (Object)new zabu(zag2, this.zail.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    public final <O extends Api.ApiOptions> Task<Boolean> zaa(@NonNull GoogleApi<O> googleApi, @NonNull ListenerHolder.ListenerKey<?> listenerKey) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zah zah2 = new zah(listenerKey, (TaskCompletionSource<Boolean>)taskCompletionSource);
        this.handler.sendMessage(this.handler.obtainMessage(13, (Object)new zabu(zah2, this.zail.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    @WorkerThread
    public boolean handleMessage(Message message) {
        block0 : switch (message.what) {
            case 1: {
                boolean bl = (Boolean)message.obj;
                GoogleApiManager googleApiManager = this;
                this.zaif = bl ? 10000L : 300000L;
                googleApiManager.handler.removeMessages(12);
                for (ApiKey<?> apiKey : googleApiManager.zaim.keySet()) {
                    googleApiManager.handler.sendMessageDelayed(googleApiManager.handler.obtainMessage(12, apiKey), googleApiManager.zaif);
                }
                break;
            }
            case 2: {
                zaj zaj2 = (zaj)message.obj;
                GoogleApiManager googleApiManager = this;
                for (ApiKey<?> apiKey : zaj2.zan()) {
                    zaa<?> zaa2 = googleApiManager.zaim.get(apiKey);
                    if (zaa2 == null) {
                        ConnectionResult connectionResult = new ConnectionResult(13);
                        zaj2.zaa(apiKey, connectionResult, null);
                        break block0;
                    }
                    if (zaa2.isConnected()) {
                        zaj2.zaa(apiKey, ConnectionResult.RESULT_SUCCESS, zaa2.zaad().getEndpointPackageName());
                        continue;
                    }
                    if (zaa2.zabk() != null) {
                        zaj2.zaa(apiKey, zaa2.zabk(), null);
                        continue;
                    }
                    zaa2.zaa(zaj2);
                    zaa2.connect();
                }
                break;
            }
            case 3: {
                for (zaa<?> zaa3 : this.zaim.values()) {
                    zaa3.zabj();
                    zaa3.connect();
                }
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                zabu zabu2 = (zabu)message.obj;
                GoogleApiManager googleApiManager = this;
                zaa<?> zaa4 = googleApiManager.zaim.get(zabu2.zajz.getApiKey());
                if (zaa4 == null) {
                    googleApiManager.zab(zabu2.zajz);
                    zaa4 = googleApiManager.zaim.get(zabu2.zajz.getApiKey());
                }
                if (zaa4.requiresSignIn() && googleApiManager.zail.get() != zabu2.zajy) {
                    zabu2.zajx.zaa(zaib);
                    zaa4.zabh();
                    break;
                }
                zaa4.zaa(zabu2.zajx);
                break;
            }
            case 5: {
                ConnectionResult connectionResult = (ConnectionResult)message.obj;
                int n = message.arg1;
                GoogleApiManager googleApiManager = this;
                zaa<?> zaa5 = null;
                for (zaa<?> zaa6 : googleApiManager.zaim.values()) {
                    if (zaa6.getInstanceId() != n) continue;
                    zaa5 = zaa6;
                    break;
                }
                if (zaa5 != null) {
                    zaa<?> zaa6;
                    String string2 = googleApiManager.zaii.getErrorString(connectionResult.getErrorCode());
                    zaa6 = connectionResult.getErrorMessage();
                    zaa5.zac(new Status(17, new StringBuilder(69 + String.valueOf(string2).length() + String.valueOf(zaa6).length()).append("Error resolution was canceled by the user, original error message: ").append(string2).append(": ").append((String)((Object)zaa6)).toString()));
                    break;
                }
                Log.wtf((String)"GoogleApiManager", (String)new StringBuilder(76).append("Could not find API instance ").append(n).append(" while trying to fail enqueued calls.").toString(), (Throwable)new Exception());
                break;
            }
            case 6: {
                GoogleApiManager googleApiManager = this;
                if (!PlatformVersion.isAtLeastIceCreamSandwich() || !(googleApiManager.zaih.getApplicationContext() instanceof Application)) break;
                BackgroundDetector.initialize((Application)((Application)googleApiManager.zaih.getApplicationContext()));
                BackgroundDetector.getInstance().addListener((BackgroundDetector.BackgroundStateChangeListener)new zabh(googleApiManager));
                if (BackgroundDetector.getInstance().readCurrentStateIfPossible(true)) break;
                googleApiManager.zaif = 300000L;
                break;
            }
            case 7: {
                this.zab((GoogleApi)message.obj);
                break;
            }
            case 9: {
                if (!this.zaim.containsKey(message.obj)) break;
                this.zaim.get(message.obj).resume();
                break;
            }
            case 10: {
                GoogleApiManager googleApiManager = this;
                for (ApiKey<?> apiKey : googleApiManager.zaip) {
                    googleApiManager.zaim.remove(apiKey).zabh();
                }
                googleApiManager.zaip.clear();
                break;
            }
            case 11: {
                if (!this.zaim.containsKey(message.obj)) break;
                this.zaim.get(message.obj).zaat();
                break;
            }
            case 12: {
                if (!this.zaim.containsKey(message.obj)) break;
                this.zaim.get(message.obj).zabn();
                break;
            }
            case 14: {
                zaae zaae2 = (zaae)message.obj;
                GoogleApiManager googleApiManager = this;
                ApiKey<?> apiKey = zaae2.getApiKey();
                if (!googleApiManager.zaim.containsKey(apiKey)) {
                    zaae2.zaaj().setResult((Object)false);
                    break;
                }
                boolean bl = ((zaa)googleApiManager.zaim.get(apiKey)).zac(false);
                zaae2.zaaj().setResult((Object)bl);
                break;
            }
            case 15: {
                zac zac2 = (zac)message.obj;
                if (!this.zaim.containsKey(zac2.zajh)) break;
                ((zaa)this.zaim.get(zac2.zajh)).zaa(zac2);
                break;
            }
            case 16: {
                zac zac3 = (zac)message.obj;
                if (!this.zaim.containsKey(zac3.zajh)) break;
                ((zaa)this.zaim.get(zac3.zajh)).zab(zac3);
                break;
            }
            default: {
                int n = message.what;
                Log.w((String)"GoogleApiManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                return false;
            }
        }
        return true;
    }

    final PendingIntent zaa(ApiKey<?> apiKey, int n) {
        zaa<?> zaa2 = this.zaim.get(apiKey);
        if (zaa2 == null) {
            return null;
        }
        com.google.android.gms.signin.zac zac2 = zaa2.zabo();
        if (zac2 == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.zaih, (int)n, (Intent)zac2.getSignInIntent(), (int)0x8000000);
    }

    final boolean zac(ConnectionResult connectionResult, int n) {
        return this.zaii.zaa(this.zaih, connectionResult, n);
    }

    public final void zaa(ConnectionResult connectionResult, int n) {
        if (!this.zac(connectionResult, n)) {
            this.handler.sendMessage(this.handler.obtainMessage(5, n, 0, (Object)connectionResult));
        }
    }

    private static final class zac {
        private final ApiKey<?> zajh;
        private final Feature zaji;

        private zac(ApiKey<?> apiKey, Feature feature) {
            this.zajh = apiKey;
            this.zaji = feature;
        }

        public final boolean equals(Object object) {
            if (object != null && object instanceof zac) {
                zac zac2 = (zac)object;
                return Objects.equal(this.zajh, zac2.zajh) && Objects.equal((Object)this.zaji, (Object)zac2.zaji);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.zajh, this.zaji});
        }

        public final String toString() {
            return Objects.toStringHelper((Object)this).add("key", this.zajh).add("feature", (Object)this.zaji).toString();
        }

        /* synthetic */ zac(ApiKey apiKey, Feature feature, zabh zabh2) {
            this(apiKey, feature);
        }
    }

    private final class zab
    implements zacf,
    BaseGmsClient.ConnectionProgressReportCallbacks {
        private final Api.Client zais;
        private final ApiKey<?> zaft;
        private IAccountAccessor zaje = null;
        private Set<Scope> zajf = null;
        private boolean zajg = false;

        public zab(Api.Client client, ApiKey<?> apiKey) {
            this.zais = client;
            this.zaft = apiKey;
        }

        public final void onReportServiceBinding(@NonNull ConnectionResult connectionResult) {
            GoogleApiManager.this.handler.post((Runnable)new zabo(this, connectionResult));
        }

        @Override
        @WorkerThread
        public final void zag(ConnectionResult connectionResult) {
            ((zaa)GoogleApiManager.this.zaim.get(this.zaft)).zag(connectionResult);
        }

        @Override
        @WorkerThread
        public final void zaa(IAccountAccessor iAccountAccessor, Set<Scope> set) {
            if (iAccountAccessor == null || set == null) {
                Log.wtf((String)"GoogleApiManager", (String)"Received null response from onSignInSuccess", (Throwable)new Exception());
                this.zag(new ConnectionResult(4));
                return;
            }
            this.zaje = iAccountAccessor;
            this.zajf = set;
            this.zabp();
        }

        @WorkerThread
        private final void zabp() {
            if (this.zajg && this.zaje != null) {
                this.zais.getRemoteService(this.zaje, this.zajf);
            }
        }

        static /* synthetic */ ApiKey zaa(zab zab2) {
            return zab2.zaft;
        }

        static /* synthetic */ boolean zaa(zab zab2, boolean bl) {
            zab2.zajg = true;
            return true;
        }

        static /* synthetic */ Api.Client zab(zab zab2) {
            return zab2.zais;
        }

        static /* synthetic */ void zac(zab zab2) {
            zab2.zabp();
        }
    }

    public final class zaa<O extends Api.ApiOptions>
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener,
    zar {
        private final Queue<com.google.android.gms.common.api.internal.zac> zair = new LinkedList<com.google.android.gms.common.api.internal.zac>();
        private final Api.Client zais;
        private final Api.AnyClient zait;
        private final ApiKey<O> zaft;
        private final zaz zaiu;
        private final Set<zaj> zaiv = new HashSet<zaj>();
        private final Map<ListenerHolder.ListenerKey<?>, zabv> zaiw = new HashMap();
        private final int zaix;
        private final zace zaiy;
        private boolean zaiz;
        private final List<zac> zaja = new ArrayList<zac>();
        private ConnectionResult zajb = null;

        @WorkerThread
        public zaa(GoogleApi<O> googleApi) {
            this.zais = googleApi.zaa(GoogleApiManager.this.handler.getLooper(), this);
            this.zait = this.zais instanceof SimpleClientAdapter ? ((SimpleClientAdapter)this.zais).getClient() : this.zais;
            this.zaft = googleApi.getApiKey();
            this.zaiu = new zaz();
            this.zaix = googleApi.getInstanceId();
            if (this.zais.requiresSignIn()) {
                this.zaiy = googleApi.zaa(GoogleApiManager.this.zaih, GoogleApiManager.this.handler);
                return;
            }
            this.zaiy = null;
        }

        @Override
        public final void onConnected(@Nullable Bundle bundle) {
            if (Looper.myLooper() == GoogleApiManager.this.handler.getLooper()) {
                this.zabe();
                return;
            }
            GoogleApiManager.this.handler.post((Runnable)new zabi(this));
        }

        @WorkerThread
        private final void zabe() {
            this.zabj();
            this.zai(ConnectionResult.RESULT_SUCCESS);
            this.zabl();
            Iterator<zabv> iterator = this.zaiw.values().iterator();
            while (iterator.hasNext()) {
                zabv zabv2 = iterator.next();
                if (this.zaa(zabv2.zakc.getRequiredFeatures()) != null) {
                    iterator.remove();
                    continue;
                }
                try {
                    zabv2.zakc.registerListener(this.zait, (TaskCompletionSource<Void>)new TaskCompletionSource());
                }
                catch (DeadObjectException deadObjectException) {
                    this.onConnectionSuspended(1);
                    this.zais.disconnect();
                    break;
                }
                catch (RemoteException remoteException) {
                    iterator.remove();
                }
            }
            this.zabg();
            this.zabm();
        }

        @Override
        public final void onConnectionSuspended(int n) {
            if (Looper.myLooper() == GoogleApiManager.this.handler.getLooper()) {
                this.zabf();
                return;
            }
            GoogleApiManager.this.handler.post((Runnable)new zabk(this));
        }

        @WorkerThread
        private final void zabf() {
            this.zabj();
            this.zaiz = true;
            this.zaiu.zaag();
            GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.handler, (int)9, this.zaft), GoogleApiManager.this.zaid);
            GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.handler, (int)11, this.zaft), GoogleApiManager.this.zaie);
            GoogleApiManager.this.zaij.flush();
        }

        @WorkerThread
        public final void zag(@NonNull ConnectionResult connectionResult) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            this.zais.disconnect();
            this.onConnectionFailed(connectionResult);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private final boolean zah(@NonNull ConnectionResult connectionResult) {
            Object object = lock;
            synchronized (object) {
                if (GoogleApiManager.this.zain != null && GoogleApiManager.this.zaio.contains(this.zaft)) {
                    GoogleApiManager.this.zain.zab(connectionResult, this.zaix);
                    return true;
                }
                return false;
            }
        }

        @Override
        public final void zaa(ConnectionResult connectionResult, Api<?> api, boolean bl) {
            if (Looper.myLooper() == GoogleApiManager.this.handler.getLooper()) {
                this.onConnectionFailed(connectionResult);
                return;
            }
            GoogleApiManager.this.handler.post((Runnable)new zabj(this, connectionResult));
        }

        @Override
        @WorkerThread
        public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zaiy != null) {
                this.zaiy.zabq();
            }
            this.zabj();
            GoogleApiManager.this.zaij.flush();
            this.zai(connectionResult);
            if (connectionResult.getErrorCode() == 4) {
                this.zac(zaic);
                return;
            }
            if (this.zair.isEmpty()) {
                this.zajb = connectionResult;
                return;
            }
            if (this.zah(connectionResult)) {
                return;
            }
            if (!GoogleApiManager.this.zac(connectionResult, this.zaix)) {
                if (connectionResult.getErrorCode() == 18) {
                    this.zaiz = true;
                }
                if (this.zaiz) {
                    GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.handler, (int)9, this.zaft), GoogleApiManager.this.zaid);
                    return;
                }
                String string2 = this.zaft.getApiName();
                String string3 = String.valueOf(connectionResult);
                this.zac(new Status(17, new StringBuilder(63 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("API: ").append(string2).append(" is not available on this device. Connection failed with: ").append(string3).toString()));
            }
        }

        @WorkerThread
        private final void zabg() {
            ArrayList<com.google.android.gms.common.api.internal.zac> arrayList = new ArrayList<com.google.android.gms.common.api.internal.zac>(this.zair);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                com.google.android.gms.common.api.internal.zac zac2 = arrayList.get(i);
                com.google.android.gms.common.api.internal.zac zac3 = zac2;
                if (!this.zais.isConnected()) break;
                if (!this.zab(zac3)) continue;
                this.zair.remove(zac3);
            }
        }

        @WorkerThread
        public final void zaa(com.google.android.gms.common.api.internal.zac zac2) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zais.isConnected()) {
                if (this.zab(zac2)) {
                    this.zabm();
                    return;
                }
                this.zair.add(zac2);
                return;
            }
            this.zair.add(zac2);
            if (this.zajb != null && this.zajb.hasResolution()) {
                this.onConnectionFailed(this.zajb);
                return;
            }
            this.connect();
        }

        @WorkerThread
        public final void zabh() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            this.zac(zaib);
            this.zaiu.zaaf();
            for (ListenerHolder.ListenerKey listenerKey : this.zaiw.keySet().toArray(new ListenerHolder.ListenerKey[this.zaiw.size()])) {
                this.zaa(new zah(listenerKey, (TaskCompletionSource<Boolean>)new TaskCompletionSource()));
            }
            this.zai(new ConnectionResult(4));
            if (this.zais.isConnected()) {
                this.zais.onUserSignOut(new zabm(this));
            }
        }

        public final Api.Client zaad() {
            return this.zais;
        }

        public final Map<ListenerHolder.ListenerKey<?>, zabv> zabi() {
            return this.zaiw;
        }

        @WorkerThread
        public final void zabj() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            this.zajb = null;
        }

        @WorkerThread
        public final ConnectionResult zabk() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            return this.zajb;
        }

        @WorkerThread
        private final boolean zab(com.google.android.gms.common.api.internal.zac zac2) {
            if (!(zac2 instanceof com.google.android.gms.common.api.internal.zab)) {
                this.zac(zac2);
                return true;
            }
            com.google.android.gms.common.api.internal.zab zab2 = (com.google.android.gms.common.api.internal.zab)zac2;
            Feature feature = this.zaa(zab2.zaa(this));
            if (feature == null) {
                this.zac(zac2);
                return true;
            }
            if (zab2.zab(this)) {
                Feature feature2 = feature;
                zaa zaa2 = this;
                zac zac3 = new zac(zaa2.zaft, feature2, null);
                int n = zaa2.zaja.indexOf(zac3);
                if (n >= 0) {
                    zac zac4 = zaa2.zaja.get(n);
                    zaa2.GoogleApiManager.this.handler.removeMessages(15, (Object)zac4);
                    zaa2.GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)zaa2.GoogleApiManager.this.handler, (int)15, (Object)zac4), zaa2.GoogleApiManager.this.zaid);
                } else {
                    zaa2.zaja.add(zac3);
                    zaa2.GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)zaa2.GoogleApiManager.this.handler, (int)15, (Object)zac3), zaa2.GoogleApiManager.this.zaid);
                    zaa2.GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)zaa2.GoogleApiManager.this.handler, (int)16, (Object)zac3), zaa2.GoogleApiManager.this.zaie);
                    ConnectionResult connectionResult = new ConnectionResult(2, null);
                    if (!zaa2.zah(connectionResult)) {
                        zaa2.GoogleApiManager.this.zac(connectionResult, zaa2.zaix);
                    }
                }
            } else {
                zab2.zaa((RuntimeException)new UnsupportedApiCallException(feature));
            }
            return false;
        }

        @WorkerThread
        private final void zac(com.google.android.gms.common.api.internal.zac zac2) {
            zac2.zaa(this.zaiu, this.requiresSignIn());
            try {
                zac2.zac(this);
                return;
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(1);
                this.zais.disconnect();
                return;
            }
        }

        @WorkerThread
        public final void zac(Status status) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            Iterator iterator = this.zair.iterator();
            while (iterator.hasNext()) {
                ((com.google.android.gms.common.api.internal.zac)iterator.next()).zaa(status);
            }
            this.zair.clear();
        }

        @WorkerThread
        public final void resume() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zaiz) {
                this.connect();
            }
        }

        @WorkerThread
        private final void zabl() {
            if (this.zaiz) {
                GoogleApiManager.this.handler.removeMessages(11, this.zaft);
                GoogleApiManager.this.handler.removeMessages(9, this.zaft);
                this.zaiz = false;
            }
        }

        @WorkerThread
        public final void zaat() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zaiz) {
                this.zabl();
                Status status = GoogleApiManager.this.zaii.isGooglePlayServicesAvailable(GoogleApiManager.this.zaih) == 18 ? new Status(8, "Connection timed out while waiting for Google Play services update to complete.") : new Status(8, "API failed to connect while resuming due to an unknown error.");
                this.zac(status);
                this.zais.disconnect();
            }
        }

        private final void zabm() {
            GoogleApiManager.this.handler.removeMessages(12, this.zaft);
            GoogleApiManager.this.handler.sendMessageDelayed(GoogleApiManager.this.handler.obtainMessage(12, this.zaft), GoogleApiManager.this.zaif);
        }

        @WorkerThread
        public final boolean zabn() {
            return this.zac(true);
        }

        @WorkerThread
        private final boolean zac(boolean bl) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zais.isConnected() && this.zaiw.size() == 0) {
                if (this.zaiu.zaae()) {
                    if (bl) {
                        this.zabm();
                    }
                    return false;
                }
                this.zais.disconnect();
                return true;
            }
            return false;
        }

        @WorkerThread
        public final void connect() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zais.isConnected() || this.zais.isConnecting()) {
                return;
            }
            int n = GoogleApiManager.this.zaij.getClientAvailability(GoogleApiManager.this.zaih, this.zais);
            if (n != 0) {
                ConnectionResult connectionResult = new ConnectionResult(n, null);
                this.onConnectionFailed(connectionResult);
                return;
            }
            zab zab2 = new zab(this.zais, this.zaft);
            if (this.zais.requiresSignIn()) {
                this.zaiy.zaa(zab2);
            }
            this.zais.connect(zab2);
        }

        @WorkerThread
        public final void zaa(zaj zaj2) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            this.zaiv.add(zaj2);
        }

        @WorkerThread
        private final void zai(ConnectionResult connectionResult) {
            for (zaj zaj2 : this.zaiv) {
                String string2 = null;
                if (Objects.equal((Object)connectionResult, (Object)ConnectionResult.RESULT_SUCCESS)) {
                    string2 = this.zais.getEndpointPackageName();
                }
                zaj2.zaa(this.zaft, connectionResult, string2);
            }
            this.zaiv.clear();
        }

        final boolean isConnected() {
            return this.zais.isConnected();
        }

        public final boolean requiresSignIn() {
            return this.zais.requiresSignIn();
        }

        public final int getInstanceId() {
            return this.zaix;
        }

        final com.google.android.gms.signin.zac zabo() {
            if (this.zaiy == null) {
                return null;
            }
            return this.zaiy.zabo();
        }

        @WorkerThread
        @Nullable
        private final Feature zaa(@Nullable Feature[] featureArray) {
            Feature feature;
            int n;
            if (featureArray == null || featureArray.length == 0) {
                return null;
            }
            Feature[] featureArray2 = this.zais.getAvailableFeatures();
            if (featureArray2 == null) {
                featureArray2 = new Feature[]{};
            }
            ArrayMap arrayMap = new ArrayMap(featureArray2.length);
            Feature[] featureArray3 = featureArray2;
            int n2 = featureArray2.length;
            for (n = 0; n < n2; ++n) {
                feature = featureArray3[n];
                arrayMap.put(feature.getName(), feature.getVersion());
            }
            featureArray3 = featureArray;
            n2 = featureArray.length;
            for (n = 0; n < n2; ++n) {
                feature = featureArray3[n];
                if (arrayMap.containsKey(feature.getName()) && (Long)arrayMap.get(feature.getName()) >= feature.getVersion()) continue;
                return feature;
            }
            return null;
        }

        @WorkerThread
        private final void zaa(zac zac2) {
            if (!this.zaja.contains(zac2)) {
                return;
            }
            if (!this.zaiz) {
                if (!this.zais.isConnected()) {
                    this.connect();
                    return;
                }
                this.zabg();
            }
        }

        @WorkerThread
        private final void zab(zac zac2) {
            if (this.zaja.remove(zac2)) {
                GoogleApiManager.this.handler.removeMessages(15, (Object)zac2);
                GoogleApiManager.this.handler.removeMessages(16, (Object)zac2);
                Feature feature = zac2.zaji;
                zaa zaa2 = this;
                ArrayList<com.google.android.gms.common.api.internal.zac> arrayList = new ArrayList<com.google.android.gms.common.api.internal.zac>(zaa2.zair.size());
                for (com.google.android.gms.common.api.internal.zac zac3 : zaa2.zair) {
                    Object[] objectArray;
                    if (!(zac3 instanceof com.google.android.gms.common.api.internal.zab) || (objectArray = ((com.google.android.gms.common.api.internal.zab)zac3).zaa(zaa2)) == null || !ArrayUtils.contains((Object[])objectArray, (Object)feature)) continue;
                    arrayList.add(zac3);
                }
                ArrayList<com.google.android.gms.common.api.internal.zac> arrayList2 = arrayList;
                int n = arrayList2.size();
                for (int i = 0; i < n; ++i) {
                    com.google.android.gms.common.api.internal.zac zac3;
                    Object e = arrayList2.get(i);
                    zac3 = (com.google.android.gms.common.api.internal.zac)e;
                    zaa2.zair.remove(zac3);
                    zac3.zaa((RuntimeException)new UnsupportedApiCallException(feature));
                }
            }
        }

        static /* synthetic */ void zae(zaa zaa2) {
            zaa2.zabe();
        }

        static /* synthetic */ void zaf(zaa zaa2) {
            zaa2.zabf();
        }

        static /* synthetic */ Api.Client zag(zaa zaa2) {
            return zaa2.zais;
        }
    }
}

