/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.server.converter.zaa;
import com.google.android.gms.common.server.response.SafeParcelResponse;
import com.google.android.gms.common.server.response.zai;
import com.google.android.gms.common.server.response.zak;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.JsonUtils;
import com.google.android.gms.common.util.MapUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@ShowFirstParty
@KeepForSdk
public abstract class FastJsonResponse {
    @KeepForSdk
    public abstract Map<String, Field<?, ?>> getFieldMappings();

    @KeepForSdk
    protected abstract Object getValueObject(String var1);

    @KeepForSdk
    protected boolean isFieldSet(Field field) {
        if (field.zapt == 11) {
            if (field.zapu) {
                String cfr_ignored_0 = field.zapv;
                throw new UnsupportedOperationException("Concrete type arrays not supported");
            }
            String cfr_ignored_1 = field.zapv;
            throw new UnsupportedOperationException("Concrete types not supported");
        }
        return this.isPrimitiveFieldSet(field.zapv);
    }

    @KeepForSdk
    protected abstract boolean isPrimitiveFieldSet(String var1);

    private final <I, O> void zaa(Field<I, O> field, I i) {
        String string2 = field.zapv;
        O o = field.convert(i);
        switch (field.zapt) {
            case 0: {
                if (!FastJsonResponse.zaa(string2, o)) break;
                this.setIntegerInternal(field, string2, (Integer)o);
                return;
            }
            case 1: {
                this.zaa(field, string2, (BigInteger)o);
                return;
            }
            case 2: {
                if (!FastJsonResponse.zaa(string2, o)) break;
                this.setLongInternal(field, string2, (Long)o);
                return;
            }
            case 4: {
                if (!FastJsonResponse.zaa(string2, o)) break;
                this.zaa(field, string2, (Double)o);
                return;
            }
            case 5: {
                this.zaa(field, string2, (BigDecimal)o);
                return;
            }
            case 6: {
                if (!FastJsonResponse.zaa(string2, o)) break;
                this.setBooleanInternal(field, string2, (Boolean)o);
                return;
            }
            case 7: {
                this.setStringInternal(field, string2, (String)o);
                return;
            }
            case 8: 
            case 9: {
                if (!FastJsonResponse.zaa(string2, o)) break;
                this.setDecodedBytesInternal(field, string2, (byte[])o);
                return;
            }
            default: {
                int n = field.zapt;
                throw new IllegalStateException(new StringBuilder(44).append("Unsupported type for conversion: ").append(n).toString());
            }
        }
    }

    protected static <O, I> I zab(Field<I, O> field, Object object) {
        if (((Field)field).zaqa != null) {
            return field.convertBack(object);
        }
        return (I)object;
    }

    public final <O> void zaa(Field<Integer, O> field, int n) {
        if (((Field)field).zaqa != null) {
            this.zaa((Field)field, (Object)n);
            return;
        }
        this.setIntegerInternal(field, field.zapv, n);
    }

    public final <O> void zaa(Field<ArrayList<Integer>, O> field, ArrayList<Integer> arrayList) {
        if (((Field)field).zaqa != null) {
            this.zaa((Field)field, (Object)arrayList);
            return;
        }
        this.zaa(field, field.zapv, arrayList);
    }

    public final <O> void zaa(Field<BigInteger, O> field, BigInteger bigInteger) {
        if (((Field)field).zaqa != null) {
            this.zaa((Field)field, (Object)bigInteger);
            return;
        }
        this.zaa(field, field.zapv, bigInteger);
    }

    public final <O> void zab(Field<ArrayList<BigInteger>, O> field, ArrayList<BigInteger> arrayList) {
        if (((Field)field).zaqa != null) {
            this.zaa(field, (Object)arrayList);
            return;
        }
        this.zab(field, field.zapv, arrayList);
    }

    public final <O> void zaa(Field<Long, O> field, long l) {
        if (((Field)field).zaqa != null) {
            this.zaa((Field)field, (Object)l);
            return;
        }
        this.setLongInternal(field, field.zapv, l);
    }

    public final <O> void zac(Field<ArrayList<Long>, O> field, ArrayList<Long> arrayList) {
        if (((Field)field).zaqa != null) {
            this.zaa(field, (Object)arrayList);
            return;
        }
        this.zac(field, field.zapv, arrayList);
    }

    public final <O> void zaa(Field<Float, O> field, float f) {
        if (((Field)field).zaqa != null) {
            this.zaa((Field)field, (Object)Float.valueOf(f));
            return;
        }
        this.zaa(field, field.zapv, f);
    }

    public final <O> void zad(Field<ArrayList<Float>, O> field, ArrayList<Float> arrayList) {
        if (((Field)field).zaqa != null) {
            this.zaa(field, (Object)arrayList);
            return;
        }
        this.zad(field, field.zapv, arrayList);
    }

    public final <O> void zaa(Field<Double, O> field, double d) {
        if (((Field)field).zaqa != null) {
            this.zaa((Field)field, (Object)d);
            return;
        }
        this.zaa(field, field.zapv, d);
    }

    public final <O> void zae(Field<ArrayList<Double>, O> field, ArrayList<Double> arrayList) {
        if (((Field)field).zaqa != null) {
            this.zaa(field, (Object)arrayList);
            return;
        }
        this.zae(field, field.zapv, arrayList);
    }

    public final <O> void zaa(Field<BigDecimal, O> field, BigDecimal bigDecimal) {
        if (((Field)field).zaqa != null) {
            this.zaa((Field)field, (Object)bigDecimal);
            return;
        }
        this.zaa(field, field.zapv, bigDecimal);
    }

    public final <O> void zaf(Field<ArrayList<BigDecimal>, O> field, ArrayList<BigDecimal> arrayList) {
        if (((Field)field).zaqa != null) {
            this.zaa(field, (Object)arrayList);
            return;
        }
        this.zaf(field, field.zapv, arrayList);
    }

    public final <O> void zaa(Field<Boolean, O> field, boolean bl) {
        if (((Field)field).zaqa != null) {
            this.zaa((Field)field, (Object)bl);
            return;
        }
        this.setBooleanInternal(field, field.zapv, bl);
    }

    public final <O> void zag(Field<ArrayList<Boolean>, O> field, ArrayList<Boolean> arrayList) {
        if (((Field)field).zaqa != null) {
            this.zaa(field, (Object)arrayList);
            return;
        }
        this.zag(field, field.zapv, arrayList);
    }

    public final <O> void zaa(Field<String, O> field, String string2) {
        if (((Field)field).zaqa != null) {
            this.zaa((Field)field, (Object)string2);
            return;
        }
        this.setStringInternal(field, field.zapv, string2);
    }

    public final <O> void zah(Field<ArrayList<String>, O> field, ArrayList<String> arrayList) {
        if (((Field)field).zaqa != null) {
            this.zaa(field, (Object)arrayList);
            return;
        }
        this.setStringsInternal(field, field.zapv, arrayList);
    }

    public final <O> void zaa(Field<byte[], O> field, byte[] byArray) {
        if (((Field)field).zaqa != null) {
            this.zaa((Field)field, (Object)byArray);
            return;
        }
        this.setDecodedBytesInternal(field, field.zapv, byArray);
    }

    public final <O> void zaa(Field<Map<String, String>, O> field, Map<String, String> map) {
        if (((Field)field).zaqa != null) {
            this.zaa((Field)field, (Object)map);
            return;
        }
        this.zaa(field, field.zapv, map);
    }

    @KeepForSdk
    protected void setIntegerInternal(Field<?, ?> field, String string2, int n) {
        throw new UnsupportedOperationException("Integer not supported");
    }

    protected void zaa(Field<?, ?> field, String string2, ArrayList<Integer> arrayList) {
        throw new UnsupportedOperationException("Integer list not supported");
    }

    protected void zaa(Field<?, ?> field, String string2, BigInteger bigInteger) {
        throw new UnsupportedOperationException("BigInteger not supported");
    }

    protected void zab(Field<?, ?> field, String string2, ArrayList<BigInteger> arrayList) {
        throw new UnsupportedOperationException("BigInteger list not supported");
    }

    @KeepForSdk
    protected void setLongInternal(Field<?, ?> field, String string2, long l) {
        throw new UnsupportedOperationException("Long not supported");
    }

    protected void zac(Field<?, ?> field, String string2, ArrayList<Long> arrayList) {
        throw new UnsupportedOperationException("Long list not supported");
    }

    protected void zaa(Field<?, ?> field, String string2, float f) {
        throw new UnsupportedOperationException("Float not supported");
    }

    protected void zad(Field<?, ?> field, String string2, ArrayList<Float> arrayList) {
        throw new UnsupportedOperationException("Float list not supported");
    }

    protected void zaa(Field<?, ?> field, String string2, double d) {
        throw new UnsupportedOperationException("Double not supported");
    }

    protected void zae(Field<?, ?> field, String string2, ArrayList<Double> arrayList) {
        throw new UnsupportedOperationException("Double list not supported");
    }

    protected void zaa(Field<?, ?> field, String string2, BigDecimal bigDecimal) {
        throw new UnsupportedOperationException("BigDecimal not supported");
    }

    protected void zaf(Field<?, ?> field, String string2, ArrayList<BigDecimal> arrayList) {
        throw new UnsupportedOperationException("BigDecimal list not supported");
    }

    @KeepForSdk
    protected void setBooleanInternal(Field<?, ?> field, String string2, boolean bl) {
        throw new UnsupportedOperationException("Boolean not supported");
    }

    protected void zag(Field<?, ?> field, String string2, ArrayList<Boolean> arrayList) {
        throw new UnsupportedOperationException("Boolean list not supported");
    }

    @KeepForSdk
    protected void setStringInternal(Field<?, ?> field, String string2, String string3) {
        throw new UnsupportedOperationException("String not supported");
    }

    @KeepForSdk
    protected void setStringsInternal(Field<?, ?> field, String string2, ArrayList<String> arrayList) {
        throw new UnsupportedOperationException("String list not supported");
    }

    @KeepForSdk
    protected void setDecodedBytesInternal(Field<?, ?> field, String string2, byte[] byArray) {
        throw new UnsupportedOperationException("byte[] not supported");
    }

    protected void zaa(Field<?, ?> field, String string2, Map<String, String> map) {
        throw new UnsupportedOperationException("String map not supported");
    }

    private static <O> boolean zaa(String string2, O o) {
        if (o == null) {
            if (Log.isLoggable((String)"FastJsonResponse", (int)6)) {
                Log.e((String)"FastJsonResponse", (String)new StringBuilder(58 + String.valueOf(string2).length()).append("Output field (").append(string2).append(") has a null value, but expected a primitive").toString());
            }
            return false;
        }
        return true;
    }

    @KeepForSdk
    public <T extends FastJsonResponse> void addConcreteTypeInternal(Field<?, ?> field, String string2, T t) {
        throw new UnsupportedOperationException("Concrete type not supported");
    }

    @KeepForSdk
    public <T extends FastJsonResponse> void addConcreteTypeArrayInternal(Field<?, ?> field, String string2, ArrayList<T> arrayList) {
        throw new UnsupportedOperationException("Concrete type array not supported");
    }

    @KeepForSdk
    public String toString() {
        Map<String, Field<?, ?>> map = this.getFieldMappings();
        StringBuilder stringBuilder = new StringBuilder(100);
        block5: for (String string2 : map.keySet()) {
            Field<?, ?> field = map.get(string2);
            if (!this.isFieldSet(field)) continue;
            Object object = this.getFieldValue(field);
            Object obj = FastJsonResponse.zab(field, object);
            if (stringBuilder.length() == 0) {
                stringBuilder.append("{");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("\"").append(string2).append("\":");
            if (obj == null) {
                stringBuilder.append("null");
                continue;
            }
            switch (field.zapt) {
                case 8: {
                    stringBuilder.append("\"").append(Base64Utils.encode((byte[])((byte[])obj))).append("\"");
                    continue block5;
                }
                case 9: {
                    stringBuilder.append("\"").append(Base64Utils.encodeUrlSafe((byte[])((byte[])obj))).append("\"");
                    continue block5;
                }
                case 10: {
                    HashMap hashMap = (HashMap)obj;
                    MapUtils.writeStringMapToJson((StringBuilder)stringBuilder, (HashMap)hashMap);
                    continue block5;
                }
            }
            if (field.zaps) {
                ArrayList arrayList = (ArrayList)obj;
                Field<?, ?> field2 = field;
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.append("[");
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    Object e;
                    if (i > 0) {
                        stringBuilder2.append(",");
                    }
                    if ((e = arrayList.get(i)) == null) continue;
                    FastJsonResponse.zaa(stringBuilder2, field2, e);
                }
                stringBuilder2.append("]");
                continue;
            }
            FastJsonResponse.zaa(stringBuilder, field, obj);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("}");
        } else {
            stringBuilder.append("{}");
        }
        return stringBuilder.toString();
    }

    @KeepForSdk
    protected Object getFieldValue(Field field) {
        String string2 = field.zapv;
        if (field.zapx != null) {
            Preconditions.checkState((this.getValueObject(field.zapv) == null ? 1 : 0) != 0, (String)"Concrete field shouldn't be value object: %s", (Object[])new Object[]{field.zapv});
            boolean cfr_ignored_0 = field.zapu;
            try {
                char c = Character.toUpperCase(string2.charAt(0));
                String string3 = string2.substring(1);
                String string4 = new StringBuilder(4 + String.valueOf(string3).length()).append("get").append(c).append(string3).toString();
                return this.getClass().getMethod(string4, new Class[0]).invoke((Object)this, new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.getValueObject(field.zapv);
    }

    private static void zaa(StringBuilder stringBuilder, Field field, Object object) {
        if (field.zapr == 11) {
            Class<? extends FastJsonResponse> clazz = field.zapx;
            stringBuilder.append(clazz.cast(object).toString());
            return;
        }
        if (field.zapr == 7) {
            stringBuilder.append("\"");
            stringBuilder.append(JsonUtils.escapeString((String)((String)object)));
            stringBuilder.append("\"");
            return;
        }
        stringBuilder.append(object);
    }

    @ShowFirstParty
    public static interface FieldConverter<I, O> {
        public int zacj();

        public int zack();

        public O convert(I var1);

        public I convertBack(O var1);
    }

    @VisibleForTesting
    @ShowFirstParty
    @SafeParcelable.Class(creator="FieldCreator")
    @KeepForSdk
    public static class Field<I, O>
    extends AbstractSafeParcelable {
        @SafeParcelable.VersionField(id=1, getter="getVersionCode")
        private final int zalf;
        @SafeParcelable.Field(id=2, getter="getTypeIn")
        protected final int zapr;
        @SafeParcelable.Field(id=3, getter="isTypeInArray")
        protected final boolean zaps;
        @SafeParcelable.Field(id=4, getter="getTypeOut")
        protected final int zapt;
        @SafeParcelable.Field(id=5, getter="isTypeOutArray")
        protected final boolean zapu;
        @SafeParcelable.Field(id=6, getter="getOutputFieldName")
        protected final String zapv;
        @SafeParcelable.Field(id=7, getter="getSafeParcelableFieldId")
        protected final int zapw;
        protected final Class<? extends FastJsonResponse> zapx;
        @SafeParcelable.Field(id=8, getter="getConcreteTypeName")
        private final String zapy;
        private zak zapz;
        @SafeParcelable.Field(id=9, getter="getWrappedConverter", type="com.google.android.gms.common.server.converter.ConverterWrapper")
        private FieldConverter<I, O> zaqa;
        public static final zai CREATOR = new zai();

        @SafeParcelable.Constructor
        Field(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2, @SafeParcelable.Param(id=3) boolean bl, @SafeParcelable.Param(id=4) int n3, @SafeParcelable.Param(id=5) boolean bl2, @SafeParcelable.Param(id=6) String string2, @SafeParcelable.Param(id=7) int n4, @SafeParcelable.Param(id=8) String string3, @SafeParcelable.Param(id=9) zaa zaa2) {
            this.zalf = n;
            this.zapr = n2;
            this.zaps = bl;
            this.zapt = n3;
            this.zapu = bl2;
            this.zapv = string2;
            this.zapw = n4;
            if (string3 == null) {
                this.zapx = null;
                this.zapy = null;
            } else {
                this.zapx = SafeParcelResponse.class;
                this.zapy = string3;
            }
            if (zaa2 == null) {
                this.zaqa = null;
                return;
            }
            this.zaqa = zaa2.zaci();
        }

        private Field(int n, boolean bl, int n2, boolean bl2, String string2, int n3, Class<? extends FastJsonResponse> clazz, FieldConverter<I, O> fieldConverter) {
            this.zalf = 1;
            this.zapr = n;
            this.zaps = bl;
            this.zapt = n2;
            this.zapu = bl2;
            this.zapv = string2;
            this.zapw = n3;
            this.zapx = clazz;
            this.zapy = clazz == null ? null : clazz.getCanonicalName();
            this.zaqa = fieldConverter;
        }

        public final Field<I, O> zacl() {
            return new Field<I, O>(this.zalf, this.zapr, this.zaps, this.zapt, this.zapu, this.zapv, this.zapw, this.zapy, this.zaco());
        }

        @KeepForSdk
        public int getSafeParcelableFieldId() {
            return this.zapw;
        }

        private final String zacm() {
            if (this.zapy == null) {
                return null;
            }
            return this.zapy;
        }

        public final boolean zacn() {
            return this.zaqa != null;
        }

        public final void zaa(zak zak2) {
            this.zapz = zak2;
        }

        private final zaa zaco() {
            if (this.zaqa == null) {
                return null;
            }
            return zaa.zaa(this.zaqa);
        }

        public final FastJsonResponse zacp() throws InstantiationException, IllegalAccessException {
            if (this.zapx == SafeParcelResponse.class) {
                Preconditions.checkNotNull((Object)((Object)this.zapz), (Object)"The field mapping dictionary must be set if the concrete type is a SafeParcelResponse object.");
                return new SafeParcelResponse(this.zapz, this.zapy);
            }
            return this.zapx.newInstance();
        }

        public final Map<String, Field<?, ?>> zacq() {
            Preconditions.checkNotNull((Object)this.zapy);
            Preconditions.checkNotNull((Object)((Object)this.zapz));
            return this.zapz.zai(this.zapy);
        }

        public final O convert(I i) {
            return this.zaqa.convert(i);
        }

        public final I convertBack(O o) {
            return this.zaqa.convertBack(o);
        }

        @VisibleForTesting
        @KeepForSdk
        public static Field<Integer, Integer> forInteger(String string2, int n) {
            return new Field<Integer, Integer>(0, false, 0, false, string2, n, null, null);
        }

        @KeepForSdk
        public static Field<Long, Long> forLong(String string2, int n) {
            return new Field<Long, Long>(2, false, 2, false, string2, n, null, null);
        }

        @KeepForSdk
        public static Field<Float, Float> forFloat(String string2, int n) {
            return new Field<Float, Float>(3, false, 3, false, string2, n, null, null);
        }

        @KeepForSdk
        public static Field<Double, Double> forDouble(String string2, int n) {
            return new Field<Double, Double>(4, false, 4, false, string2, n, null, null);
        }

        @KeepForSdk
        public static Field<Boolean, Boolean> forBoolean(String string2, int n) {
            return new Field<Boolean, Boolean>(6, false, 6, false, string2, n, null, null);
        }

        @KeepForSdk
        public static Field<String, String> forString(String string2, int n) {
            return new Field<String, String>(7, false, 7, false, string2, n, null, null);
        }

        @KeepForSdk
        public static Field<ArrayList<String>, ArrayList<String>> forStrings(String string2, int n) {
            return new Field<ArrayList<String>, ArrayList<String>>(7, true, 7, true, string2, n, null, null);
        }

        @VisibleForTesting
        @KeepForSdk
        public static Field<byte[], byte[]> forBase64(String string2, int n) {
            return new Field<byte[], byte[]>(8, false, 8, false, string2, n, null, null);
        }

        @KeepForSdk
        public static <T extends FastJsonResponse> Field<T, T> forConcreteType(String string2, int n, Class<T> clazz) {
            return new Field(11, false, 11, false, string2, n, clazz, null);
        }

        @KeepForSdk
        public static <T extends FastJsonResponse> Field<ArrayList<T>, ArrayList<T>> forConcreteTypeArray(String string2, int n, Class<T> clazz) {
            return new Field<ArrayList<T>, ArrayList<T>>(11, true, 11, true, string2, n, clazz, null);
        }

        @KeepForSdk
        public static Field withConverter(String string2, int n, FieldConverter<?, ?> fieldConverter, boolean bl) {
            return new Field(fieldConverter.zacj(), bl, fieldConverter.zack(), false, string2, n, null, fieldConverter);
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            Field field = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)field.zalf);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)field.zapr);
            SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)3, (boolean)field.zaps);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)field.zapt);
            SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)field.zapu);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)field.zapv, (boolean)false);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)7, (int)field.getSafeParcelableFieldId());
            SafeParcelWriter.writeString((Parcel)parcel2, (int)8, (String)field.zacm(), (boolean)false);
            SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)9, (Parcelable)field.zaco(), (int)n, (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }

        public String toString() {
            Objects.ToStringHelper toStringHelper = Objects.toStringHelper((Object)((Object)this)).add("versionCode", (Object)this.zalf).add("typeIn", (Object)this.zapr).add("typeInArray", (Object)this.zaps).add("typeOut", (Object)this.zapt).add("typeOutArray", (Object)this.zapu).add("outputFieldName", (Object)this.zapv).add("safeParcelFieldId", (Object)this.zapw).add("concreteTypeName", (Object)this.zacm());
            Class<? extends FastJsonResponse> clazz = this.zapx;
            if (clazz != null) {
                toStringHelper.add("concreteType.class", (Object)clazz.getCanonicalName());
            }
            if (this.zaqa != null) {
                toStringHelper.add("converterName", (Object)this.zaqa.getClass().getCanonicalName());
            }
            return toStringHelper.toString();
        }
    }
}

