/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.content.Context;
import android.view.View;
import androidx.collection.ArraySet;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.signin.SignInOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@VisibleForTesting
@KeepForSdk
public final class ClientSettings {
    private final Account zax;
    private final Set<Scope> zabr;
    private final Set<Scope> zaob;
    private final Map<Api<?>, OptionalApiSettings> zaoc;
    private final int zabt;
    private final View zabu;
    private final String zabv;
    private final String zabw;
    private final SignInOptions zaod;
    private final boolean zaby;
    private Integer zaoe;
    public static final String KEY_CLIENT_SESSION_ID = "com.google.android.gms.common.internal.ClientSettings.sessionId";

    @KeepForSdk
    public static ClientSettings createDefault(Context context) {
        return new GoogleApiClient.Builder(context).buildClientSettings();
    }

    @KeepForSdk
    public ClientSettings(Account account, Set<Scope> set, Map<Api<?>, OptionalApiSettings> map, int n, View view, String string2, String string3, SignInOptions signInOptions) {
        this(account, set, map, n, view, string2, string3, signInOptions, false);
    }

    public ClientSettings(Account account, Set<Scope> set, Map<Api<?>, OptionalApiSettings> map, int n, View view, String string2, String string3, SignInOptions signInOptions, boolean bl) {
        this.zax = account;
        this.zabr = set == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(set);
        this.zaoc = map == null ? Collections.EMPTY_MAP : map;
        this.zabu = view;
        this.zabt = n;
        this.zabv = string2;
        this.zabw = string3;
        this.zaod = signInOptions;
        this.zaby = bl;
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zabr);
        for (OptionalApiSettings optionalApiSettings : this.zaoc.values()) {
            hashSet.addAll(optionalApiSettings.mScopes);
        }
        this.zaob = Collections.unmodifiableSet(hashSet);
    }

    @Deprecated
    @Nullable
    @KeepForSdk
    public final String getAccountName() {
        if (this.zax != null) {
            return this.zax.name;
        }
        return null;
    }

    @Nullable
    @KeepForSdk
    public final Account getAccount() {
        return this.zax;
    }

    @KeepForSdk
    public final Account getAccountOrDefault() {
        if (this.zax != null) {
            return this.zax;
        }
        return new Account("<<default account>>", "com.google");
    }

    @KeepForSdk
    public final int getGravityForPopups() {
        return this.zabt;
    }

    @KeepForSdk
    public final Set<Scope> getRequiredScopes() {
        return this.zabr;
    }

    @KeepForSdk
    public final Set<Scope> getAllRequestedScopes() {
        return this.zaob;
    }

    public final Map<Api<?>, OptionalApiSettings> getOptionalApiSettings() {
        return this.zaoc;
    }

    @Nullable
    @KeepForSdk
    public final String getRealClientPackageName() {
        return this.zabv;
    }

    @Nullable
    public final String getRealClientClassName() {
        return this.zabw;
    }

    @Nullable
    @KeepForSdk
    public final View getViewForPopups() {
        return this.zabu;
    }

    @Nullable
    public final SignInOptions getSignInOptions() {
        return this.zaod;
    }

    @Nullable
    public final Integer getClientSessionId() {
        return this.zaoe;
    }

    public final void setClientSessionId(Integer n) {
        this.zaoe = n;
    }

    @KeepForSdk
    public final Set<Scope> getApplicableScopes(Api<?> api) {
        OptionalApiSettings optionalApiSettings = this.zaoc.get(api);
        if (optionalApiSettings == null || optionalApiSettings.mScopes.isEmpty()) {
            return this.zabr;
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zabr);
        hashSet.addAll(optionalApiSettings.mScopes);
        return hashSet;
    }

    public final boolean isSignInClientDisconnectFixEnabled() {
        return this.zaby;
    }

    @KeepForSdk
    public static final class Builder {
        private Account zax;
        private ArraySet<Scope> zaof;
        private Map<Api<?>, OptionalApiSettings> zaoc;
        private int zabt = 0;
        private View zabu;
        private String zabv;
        private String zabw;
        private SignInOptions zaod = SignInOptions.DEFAULT;
        private boolean zaby;

        public final Builder setAccount(Account account) {
            this.zax = account;
            return this;
        }

        public final Builder addRequiredScope(Scope scope) {
            if (this.zaof == null) {
                this.zaof = new ArraySet();
            }
            this.zaof.add((Object)scope);
            return this;
        }

        public final Builder addAllRequiredScopes(Collection<Scope> collection) {
            if (this.zaof == null) {
                this.zaof = new ArraySet();
            }
            this.zaof.addAll(collection);
            return this;
        }

        public final Builder setOptionalApiSettingsMap(Map<Api<?>, OptionalApiSettings> map) {
            this.zaoc = map;
            return this;
        }

        public final Builder setGravityForPopups(int n) {
            this.zabt = n;
            return this;
        }

        public final Builder setViewForPopups(View view) {
            this.zabu = view;
            return this;
        }

        @KeepForSdk
        public final Builder setRealClientPackageName(String string2) {
            this.zabv = string2;
            return this;
        }

        public final Builder setRealClientClassName(String string2) {
            this.zabw = string2;
            return this;
        }

        public final Builder setSignInOptions(SignInOptions signInOptions) {
            this.zaod = signInOptions;
            return this;
        }

        public final Builder enableSignInClientDisconnectFix() {
            this.zaby = true;
            return this;
        }

        @KeepForSdk
        public final ClientSettings build() {
            return new ClientSettings(this.zax, (Set<Scope>)this.zaof, this.zaoc, this.zabt, this.zabu, this.zabv, this.zabw, this.zaod, this.zaby);
        }
    }

    public static final class OptionalApiSettings {
        public final Set<Scope> mScopes;

        public OptionalApiSettings(Set<Scope> set) {
            Preconditions.checkNotNull(set);
            this.mScopes = Collections.unmodifiableSet(set);
        }
    }
}

