/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.common.internal.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;

@KeepForSdk
public class DataBufferIterator<T>
implements Iterator<T> {
    protected final DataBuffer<T> zalj;
    protected int zalk;

    public DataBufferIterator(DataBuffer<T> dataBuffer) {
        this.zalj = (DataBuffer)Preconditions.checkNotNull(dataBuffer);
        this.zalk = -1;
    }

    @Override
    public boolean hasNext() {
        return this.zalk < this.zalj.getCount() - 1;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            int n = this.zalk;
            throw new NoSuchElementException(new StringBuilder(46).append("Cannot advance the iterator beyond ").append(n).toString());
        }
        return this.zalj.get(++this.zalk);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove elements from a DataBufferIterator");
    }
}

