/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.util.Log;
import com.google.android.gms.common.server.response.FastJsonResponse;
import com.google.android.gms.common.server.response.PostProcessor;
import com.google.android.gms.common.server.response.zzb;
import com.google.android.gms.common.server.response.zzc;
import com.google.android.gms.common.server.response.zzd;
import com.google.android.gms.common.server.response.zze;
import com.google.android.gms.common.server.response.zzf;
import com.google.android.gms.common.server.response.zzg;
import com.google.android.gms.common.server.response.zzh;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.JsonUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class FastParser<T extends FastJsonResponse> {
    private final char[] zzwq = new char[1];
    private final char[] zzwr = new char[32];
    private final char[] zzws = new char[1024];
    private final StringBuilder zzwt = new StringBuilder(32);
    private final StringBuilder zzwu = new StringBuilder(1024);
    private static final char[] zzwv = new char[]{'u', 'l', 'l'};
    private static final char[] zzww = new char[]{'r', 'u', 'e'};
    private static final char[] zzwx = new char[]{'r', 'u', 'e', '\"'};
    private static final char[] zzwy = new char[]{'a', 'l', 's', 'e'};
    private static final char[] zzwz = new char[]{'a', 'l', 's', 'e', '\"'};
    private static final char[] zzxa = new char[]{'\n'};
    private final Stack<Integer> zzxb = new Stack();
    private static final zza<Integer> zzxc = new com.google.android.gms.common.server.response.zza();
    private static final zza<Long> zzxd = new zzb();
    private static final zza<Float> zzxe = new zzc();
    private static final zza<Double> zzxf = new zzd();
    private static final zza<Boolean> zzxg = new zze();
    private static final zza<String> zzxh = new zzf();
    private static final zza<BigInteger> zzxi = new zzg();
    private static final zza<BigDecimal> zzxj = new zzh();

    public FastParser() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(InputStream inputStream, T t) throws ParseException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream), 1024);
        try {
            this.zzxb.push(0);
            T t2 = t;
            BufferedReader bufferedReader2 = bufferedReader;
            FastParser fastParser = this;
            char c = fastParser.zzj(bufferedReader2);
            switch (c) {
                case '{': {
                    fastParser.zzxb.push(1);
                    fastParser.zza(bufferedReader2, (FastJsonResponse)t2);
                    break;
                }
                case '[': {
                    fastParser.zzxb.push(5);
                    T t3 = t2;
                    BufferedReader bufferedReader3 = bufferedReader2;
                    FastParser fastParser2 = fastParser;
                    Map<String, FastJsonResponse.Field<?, ?>> map = ((FastJsonResponse)t3).getFieldMappings();
                    if (map.size() != 1) {
                        throw new ParseException("Object array response class must have a single Field");
                    }
                    FastJsonResponse.Field<?, ?> field = map.entrySet().iterator().next().getValue();
                    ArrayList<T> arrayList = fastParser2.zza(bufferedReader3, field);
                    ((FastJsonResponse)t3).addConcreteTypeArrayInternal(field, field.getOutputFieldName(), arrayList);
                    break;
                }
                case '\u0000': {
                    throw new ParseException("No data to parse");
                }
                default: {
                    throw new ParseException(new StringBuilder(19).append("Unexpected token: ").append(c).toString());
                }
            }
            this.zzk(0);
        }
        catch (IOException iOException) {
            try {
                throw new ParseException(iOException);
            }
            catch (Throwable throwable) {
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    Log.w((String)"FastParser", (String)"Failed to close reader while parsing.");
                }
                throw throwable;
            }
        }
        try {
            bufferedReader.close();
            return;
        }
        catch (IOException iOException) {
            Log.w((String)"FastParser", (String)"Failed to close reader while parsing.");
            return;
        }
    }

    public void parse(String string2, T t) throws ParseException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        try {
            this.parse(byteArrayInputStream, t);
        }
        catch (Throwable throwable) {
            try {
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {
                Log.w((String)"FastParser", (String)"Failed to close the input stream while parsing.");
            }
            throw throwable;
        }
        try {
            byteArrayInputStream.close();
            return;
        }
        catch (IOException iOException) {
            Log.w((String)"FastParser", (String)"Failed to close the input stream while parsing.");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean zza(BufferedReader bufferedReader, FastJsonResponse fastJsonResponse) throws ParseException, IOException {
        Map<String, FastJsonResponse.Field<?, ?>> map = fastJsonResponse.getFieldMappings();
        String string2 = this.zza(bufferedReader);
        if (string2 == null) {
            this.zzk(1);
            return false;
        }
        block26: while (string2 != null) {
            char c;
            FastJsonResponse.Field<?, ?> field = map.get(string2);
            if (field == null) {
                string2 = this.zzb(bufferedReader);
                continue;
            }
            this.zzxb.push(4);
            switch (field.getTypeIn()) {
                case 0: {
                    if (field.isTypeInArray()) {
                        fastJsonResponse.setIntegers(field, this.zza(bufferedReader, zzxc));
                        break;
                    }
                    fastJsonResponse.setInteger(field, this.zzd(bufferedReader));
                    break;
                }
                case 1: {
                    if (field.isTypeInArray()) {
                        fastJsonResponse.setBigIntegers(field, this.zza(bufferedReader, zzxi));
                        break;
                    }
                    fastJsonResponse.setBigInteger(field, this.zzf(bufferedReader));
                    break;
                }
                case 2: {
                    if (field.isTypeInArray()) {
                        fastJsonResponse.setLongs(field, this.zza(bufferedReader, zzxd));
                        break;
                    }
                    fastJsonResponse.setLong(field, this.zze(bufferedReader));
                    break;
                }
                case 3: {
                    if (field.isTypeInArray()) {
                        fastJsonResponse.setFloats(field, this.zza(bufferedReader, zzxe));
                        break;
                    }
                    fastJsonResponse.setFloat(field, this.zzg(bufferedReader));
                    break;
                }
                case 4: {
                    if (field.isTypeInArray()) {
                        fastJsonResponse.setDoubles(field, this.zza(bufferedReader, zzxf));
                        break;
                    }
                    fastJsonResponse.setDouble(field, this.zzh(bufferedReader));
                    break;
                }
                case 5: {
                    if (field.isTypeInArray()) {
                        fastJsonResponse.setBigDecimals(field, this.zza(bufferedReader, zzxj));
                        break;
                    }
                    fastJsonResponse.setBigDecimal(field, this.zzi(bufferedReader));
                    break;
                }
                case 6: {
                    if (field.isTypeInArray()) {
                        fastJsonResponse.setBooleans(field, this.zza(bufferedReader, zzxg));
                        break;
                    }
                    fastJsonResponse.setBoolean(field, this.zza(bufferedReader, false));
                    break;
                }
                case 7: {
                    if (field.isTypeInArray()) {
                        fastJsonResponse.setStrings(field, this.zza(bufferedReader, zzxh));
                        break;
                    }
                    fastJsonResponse.setString(field, this.zzc(bufferedReader));
                    break;
                }
                case 8: {
                    fastJsonResponse.setDecodedBytes(field, Base64Utils.decode((String)this.zza(bufferedReader, this.zzws, this.zzwu, zzxa)));
                    break;
                }
                case 9: {
                    fastJsonResponse.setDecodedBytes(field, Base64Utils.decodeUrlSafe((String)this.zza(bufferedReader, this.zzws, this.zzwu, zzxa)));
                    break;
                }
                case 10: {
                    HashMap<String, String> hashMap;
                    BufferedReader bufferedReader2 = bufferedReader;
                    FastParser fastParser = this;
                    char c2 = fastParser.zzj(bufferedReader2);
                    if (c2 == 'n') {
                        fastParser.zzb(bufferedReader2, zzwv);
                        hashMap = null;
                    } else {
                        if (c2 != '{') {
                            throw new ParseException("Expected start of a map object");
                        }
                        fastParser.zzxb.push(1);
                        HashMap<String, String> hashMap2 = new HashMap<String, String>();
                        block27: while (true) {
                            switch (fastParser.zzj(bufferedReader2)) {
                                case '\"': {
                                    String string3 = FastParser.zzb(bufferedReader2, fastParser.zzwr, fastParser.zzwt, null);
                                    if (fastParser.zzj(bufferedReader2) != ':') {
                                        String string4;
                                        String string5 = String.valueOf(string3);
                                        if (string5.length() != 0) {
                                            string4 = "No map value found for key ".concat(string5);
                                            throw new ParseException(string4);
                                        }
                                        string4 = new String("No map value found for key ");
                                        throw new ParseException(string4);
                                    }
                                    if (fastParser.zzj(bufferedReader2) != '\"') {
                                        String string6;
                                        String string7 = String.valueOf(string3);
                                        if (string7.length() != 0) {
                                            string6 = "Expected String value for key ".concat(string7);
                                            throw new ParseException(string6);
                                        }
                                        string6 = new String("Expected String value for key ");
                                        throw new ParseException(string6);
                                    }
                                    String string8 = FastParser.zzb(bufferedReader2, fastParser.zzwr, fastParser.zzwt, null);
                                    hashMap2.put(string3, string8);
                                    c2 = fastParser.zzj(bufferedReader2);
                                    if (c2 == ',') break;
                                    if (c2 != '}') {
                                        char c3 = c2;
                                        throw new ParseException(new StringBuilder(48).append("Unexpected character while parsing string map: ").append(c3).toString());
                                    }
                                    fastParser.zzk(1);
                                    hashMap = hashMap2;
                                    break block27;
                                }
                                case '}': {
                                    fastParser.zzk(1);
                                    hashMap = hashMap2;
                                    break block27;
                                }
                                case '\u0000': {
                                    throw new ParseException("Unexpected EOF");
                                }
                            }
                        }
                    }
                    fastJsonResponse.setStringMap(field, hashMap);
                    break;
                }
                case 11: {
                    if (field.isTypeInArray()) {
                        c = this.zzj(bufferedReader);
                        if (c == 'n') {
                            this.zzb(bufferedReader, zzwv);
                            fastJsonResponse.addConcreteTypeArrayInternal(field, field.getOutputFieldName(), null);
                            break;
                        }
                        this.zzxb.push(5);
                        if (c != '[') {
                            throw new ParseException("Expected array start");
                        }
                        fastJsonResponse.addConcreteTypeArrayInternal(field, field.getOutputFieldName(), this.zza(bufferedReader, field));
                        break;
                    }
                    c = this.zzj(bufferedReader);
                    if (c == 'n') {
                        this.zzb(bufferedReader, zzwv);
                        fastJsonResponse.addConcreteTypeInternal(field, field.getOutputFieldName(), null);
                        break;
                    }
                    this.zzxb.push(1);
                    if (c != '{') {
                        throw new ParseException("Expected start of object");
                    }
                    try {
                        FastJsonResponse fastJsonResponse2 = field.newConcreteTypeInstance();
                        this.zza(bufferedReader, fastJsonResponse2);
                        fastJsonResponse.addConcreteTypeInternal(field, field.getOutputFieldName(), fastJsonResponse2);
                        break;
                    }
                    catch (InstantiationException instantiationException) {
                        throw new ParseException("Error instantiating inner object", instantiationException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new ParseException("Error instantiating inner object", illegalAccessException);
                    }
                }
                default: {
                    int n = field.getTypeIn();
                    throw new ParseException(new StringBuilder(30).append("Invalid field type ").append(n).toString());
                }
            }
            this.zzk(4);
            this.zzk(2);
            c = this.zzj(bufferedReader);
            switch (c) {
                case '}': {
                    string2 = null;
                    continue block26;
                }
                case ',': {
                    string2 = this.zza(bufferedReader);
                    continue block26;
                }
            }
            throw new ParseException(new StringBuilder(55).append("Expected end of object or field separator, but found: ").append(c).toString());
        }
        PostProcessor<? extends FastJsonResponse> postProcessor = fastJsonResponse.getPostProcessor();
        if (postProcessor != null) {
            postProcessor.postProcess(fastJsonResponse);
        }
        this.zzk(1);
        return true;
    }

    private final String zza(BufferedReader bufferedReader) throws ParseException, IOException {
        this.zzxb.push(2);
        char c = this.zzj(bufferedReader);
        switch (c) {
            case '}': {
                this.zzk(2);
                return null;
            }
            case ']': {
                this.zzk(2);
                this.zzk(1);
                this.zzk(5);
                return null;
            }
            case '\"': {
                this.zzxb.push(3);
                String string2 = FastParser.zzb(bufferedReader, this.zzwr, this.zzwt, null);
                this.zzk(3);
                if (this.zzj(bufferedReader) != ':') {
                    throw new ParseException("Expected key/value separator");
                }
                return string2;
            }
        }
        throw new ParseException(new StringBuilder(19).append("Unexpected token: ").append(c).toString());
    }

    private final String zzb(BufferedReader bufferedReader) throws ParseException, IOException {
        char c;
        char c2;
        bufferedReader.mark(1024);
        switch (this.zzj(bufferedReader)) {
            case '\"': {
                c2 = '\u0000';
                if (bufferedReader.read(this.zzwq) == -1) {
                    throw new ParseException("Unexpected EOF while parsing string");
                }
                char c3 = this.zzwq[0];
                while (c3 != '\"' || c2 != '\u0000') {
                    c2 = c3 == '\\' ? (c2 == '\u0000' ? (char)'\u0001' : '\u0000') : (char)'\u0000';
                    if (bufferedReader.read(this.zzwq) == -1) {
                        throw new ParseException("Unexpected EOF while parsing string");
                    }
                    c3 = this.zzwq[0];
                    if (!Character.isISOControl(c3)) continue;
                    throw new ParseException("Unexpected control character while reading string");
                }
                break;
            }
            case '{': {
                this.zzxb.push(1);
                bufferedReader.mark(32);
                c = this.zzj(bufferedReader);
                if (c == '}') {
                    this.zzk(1);
                    break;
                }
                if (c == '\"') {
                    bufferedReader.reset();
                    this.zza(bufferedReader);
                    while (this.zzb(bufferedReader) != null) {
                    }
                    this.zzk(1);
                    break;
                }
                char c4 = c;
                throw new ParseException(new StringBuilder(18).append("Unexpected token ").append(c4).toString());
            }
            case '[': {
                this.zzxb.push(5);
                bufferedReader.mark(32);
                if (this.zzj(bufferedReader) == ']') {
                    this.zzk(5);
                    break;
                }
                bufferedReader.reset();
                c2 = '\u0000';
                boolean bl = false;
                int n = 1;
                while (n > 0) {
                    char c5 = this.zzj(bufferedReader);
                    if (c5 == '\u0000') {
                        throw new ParseException("Unexpected EOF while parsing array");
                    }
                    if (Character.isISOControl(c5)) {
                        throw new ParseException("Unexpected control character while reading array");
                    }
                    if (c5 == '\"' && c2 == '\u0000') {
                        boolean bl2 = bl = !bl;
                    }
                    if (c5 == '[' && !bl) {
                        ++n;
                    }
                    if (c5 == ']' && !bl) {
                        --n;
                    }
                    if (c5 == '\\' && bl) {
                        c2 = c2 == '\u0000' ? (char)'\u0001' : '\u0000';
                        continue;
                    }
                    c2 = '\u0000';
                }
                this.zzk(5);
                break;
            }
            case ',': {
                throw new ParseException("Missing value");
            }
            default: {
                bufferedReader.reset();
                this.zza(bufferedReader, this.zzws);
            }
        }
        c = this.zzj(bufferedReader);
        switch (c) {
            case ',': {
                this.zzk(2);
                return this.zza(bufferedReader);
            }
            case '}': {
                this.zzk(2);
                return null;
            }
        }
        c2 = c;
        throw new ParseException(new StringBuilder(18).append("Unexpected token ").append(c2).toString());
    }

    private final String zzc(BufferedReader bufferedReader) throws ParseException, IOException {
        return this.zza(bufferedReader, this.zzwr, this.zzwt, null);
    }

    private final <O> ArrayList<O> zza(BufferedReader bufferedReader, zza<O> zza2) throws ParseException, IOException {
        char c = this.zzj(bufferedReader);
        if (c == 'n') {
            this.zzb(bufferedReader, zzwv);
            return null;
        }
        if (c != '[') {
            throw new ParseException("Expected start of array");
        }
        this.zzxb.push(5);
        ArrayList<O> arrayList = new ArrayList<O>();
        block5: while (true) {
            bufferedReader.mark(1024);
            switch (this.zzj(bufferedReader)) {
                case ',': {
                    continue block5;
                }
                case ']': {
                    this.zzk(5);
                    return arrayList;
                }
                case '\u0000': {
                    throw new ParseException("Unexpected EOF");
                }
            }
            bufferedReader.reset();
            arrayList.add(zza2.zzh(this, bufferedReader));
        }
    }

    private final String zza(BufferedReader bufferedReader, char[] cArray, StringBuilder stringBuilder, char[] cArray2) throws ParseException, IOException {
        switch (this.zzj(bufferedReader)) {
            case '\"': {
                return FastParser.zzb(bufferedReader, cArray, stringBuilder, cArray2);
            }
            case 'n': {
                this.zzb(bufferedReader, zzwv);
                return null;
            }
        }
        throw new ParseException("Expected string");
    }

    private static String zzb(BufferedReader bufferedReader, char[] cArray, StringBuilder stringBuilder, char[] cArray2) throws ParseException, IOException {
        int n;
        stringBuilder.setLength(0);
        boolean bl = false;
        boolean bl2 = false;
        bufferedReader.mark(cArray.length);
        while ((n = bufferedReader.read(cArray)) != -1) {
            for (int i = 0; i < n; ++i) {
                char c = cArray[i];
                if (Character.isISOControl(c)) {
                    boolean bl3;
                    char c2 = c;
                    char[] cArray3 = cArray2;
                    if (cArray2 != null) {
                        for (int j = 0; j < cArray3.length; ++j) {
                            if (cArray3[j] != c2) continue;
                            bl3 = true;
                            break;
                        }
                    } else {
                        bl3 = false;
                    }
                    if (!bl3) {
                        throw new ParseException("Unexpected control character while reading string");
                    }
                }
                if (c == '\"' && !bl) {
                    stringBuilder.append(cArray, 0, i);
                    bufferedReader.reset();
                    bufferedReader.skip(i + 1);
                    if (bl2) {
                        return JsonUtils.unescapeString((String)stringBuilder.toString());
                    }
                    return stringBuilder.toString();
                }
                if (c == '\\') {
                    bl = !bl;
                    bl2 = true;
                    continue;
                }
                bl = false;
            }
            stringBuilder.append(cArray, 0, n);
            bufferedReader.mark(cArray.length);
        }
        throw new ParseException("Unexpected EOF while parsing string");
    }

    private final int zzd(BufferedReader bufferedReader) throws ParseException, IOException {
        int n = this.zza(bufferedReader, this.zzws);
        if (n == 0) {
            return 0;
        }
        int n2 = n;
        char[] cArray = this.zzws;
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        if (n2 > 0) {
            int n5;
            int n6;
            if (cArray[0] == '-') {
                bl = true;
                n6 = Integer.MIN_VALUE;
                ++n4;
            } else {
                n6 = -2147483647;
            }
            if (n4 < n2) {
                if ((n5 = Character.digit(cArray[n4++], 10)) < 0) {
                    throw new ParseException("Unexpected non-digit character");
                }
                n3 = -n5;
            }
            while (n4 < n2) {
                if ((n5 = Character.digit(cArray[n4++], 10)) < 0) {
                    throw new ParseException("Unexpected non-digit character");
                }
                if (n3 < -214748364) {
                    throw new ParseException("Number too large");
                }
                if ((n3 *= 10) < n6 + n5) {
                    throw new ParseException("Number too large");
                }
                n3 -= n5;
            }
        } else {
            throw new ParseException("No number to parse");
        }
        if (bl) {
            if (n4 > 1) {
                return n3;
            }
            throw new ParseException("No digits to parse");
        }
        return -n3;
    }

    private final long zze(BufferedReader bufferedReader) throws ParseException, IOException {
        int n = this.zza(bufferedReader, this.zzws);
        if (n == 0) {
            return 0L;
        }
        int n2 = n;
        char[] cArray = this.zzws;
        long l = 0L;
        boolean bl = false;
        int n3 = 0;
        if (n2 > 0) {
            int n4;
            long l2;
            if (cArray[0] == '-') {
                bl = true;
                l2 = Long.MIN_VALUE;
                ++n3;
            } else {
                l2 = -9223372036854775807L;
            }
            if (n3 < n2) {
                if ((n4 = Character.digit(cArray[n3++], 10)) < 0) {
                    throw new ParseException("Unexpected non-digit character");
                }
                l = -n4;
            }
            while (n3 < n2) {
                if ((n4 = Character.digit(cArray[n3++], 10)) < 0) {
                    throw new ParseException("Unexpected non-digit character");
                }
                if (l < -922337203685477580L) {
                    throw new ParseException("Number too large");
                }
                if ((l *= 10L) < l2 + (long)n4) {
                    throw new ParseException("Number too large");
                }
                l -= (long)n4;
            }
        } else {
            throw new ParseException("No number to parse");
        }
        if (bl) {
            if (n3 > 1) {
                return l;
            }
            throw new ParseException("No digits to parse");
        }
        return -l;
    }

    private final BigInteger zzf(BufferedReader bufferedReader) throws ParseException, IOException {
        int n = this.zza(bufferedReader, this.zzws);
        if (n == 0) {
            return null;
        }
        return new BigInteger(new String(this.zzws, 0, n));
    }

    private final boolean zza(BufferedReader bufferedReader, boolean bl) throws ParseException, IOException {
        char c;
        block6: while (true) {
            c = this.zzj(bufferedReader);
            switch (c) {
                case 'n': {
                    this.zzb(bufferedReader, zzwv);
                    return false;
                }
                case 't': {
                    this.zzb(bufferedReader, bl ? zzwx : zzww);
                    return true;
                }
                case 'f': {
                    this.zzb(bufferedReader, bl ? zzwz : zzwy);
                    return false;
                }
                case '\"': {
                    if (bl) {
                        throw new ParseException("No boolean value found in string");
                    }
                    bl = true;
                    continue block6;
                }
            }
            break;
        }
        throw new ParseException(new StringBuilder(19).append("Unexpected token: ").append(c).toString());
    }

    private final float zzg(BufferedReader bufferedReader) throws ParseException, IOException {
        int n = this.zza(bufferedReader, this.zzws);
        if (n == 0) {
            return 0.0f;
        }
        return Float.parseFloat(new String(this.zzws, 0, n));
    }

    private final double zzh(BufferedReader bufferedReader) throws ParseException, IOException {
        int n = this.zza(bufferedReader, this.zzws);
        if (n == 0) {
            return 0.0;
        }
        return Double.parseDouble(new String(this.zzws, 0, n));
    }

    private final BigDecimal zzi(BufferedReader bufferedReader) throws ParseException, IOException {
        int n = this.zza(bufferedReader, this.zzws);
        if (n == 0) {
            return null;
        }
        return new BigDecimal(new String(this.zzws, 0, n));
    }

    private final <T extends FastJsonResponse> ArrayList<T> zza(BufferedReader bufferedReader, FastJsonResponse.Field<?, ?> field) throws ParseException, IOException {
        ArrayList<FastJsonResponse> arrayList;
        block14: {
            arrayList = new ArrayList<FastJsonResponse>();
            char c = this.zzj(bufferedReader);
            switch (c) {
                case ']': {
                    this.zzk(5);
                    return arrayList;
                }
                case '{': {
                    this.zzxb.push(1);
                    break;
                }
                case 'n': {
                    this.zzb(bufferedReader, zzwv);
                    this.zzk(5);
                    return null;
                }
                default: {
                    char c2 = c;
                    throw new ParseException(new StringBuilder(19).append("Unexpected token: ").append(c2).toString());
                }
            }
            block12: while (true) {
                try {
                    FastJsonResponse fastJsonResponse = field.newConcreteTypeInstance();
                    if (!this.zza(bufferedReader, fastJsonResponse)) break block14;
                    arrayList.add(fastJsonResponse);
                }
                catch (InstantiationException instantiationException) {
                    throw new ParseException("Error instantiating inner object", instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ParseException("Error instantiating inner object", illegalAccessException);
                }
                c = this.zzj(bufferedReader);
                switch (c) {
                    case ',': {
                        if (this.zzj(bufferedReader) != '{') {
                            throw new ParseException("Expected start of next object in array");
                        }
                        this.zzxb.push(1);
                        continue block12;
                    }
                    case ']': {
                        this.zzk(5);
                        return arrayList;
                    }
                }
                break;
            }
            char c3 = c;
            throw new ParseException(new StringBuilder(19).append("Unexpected token: ").append(c3).toString());
        }
        return arrayList;
    }

    private final char zzj(BufferedReader bufferedReader) throws ParseException, IOException {
        if (bufferedReader.read(this.zzwq) == -1) {
            return '\u0000';
        }
        while (Character.isWhitespace(this.zzwq[0])) {
            if (bufferedReader.read(this.zzwq) != -1) continue;
            return '\u0000';
        }
        return this.zzwq[0];
    }

    private final int zza(BufferedReader bufferedReader, char[] cArray) throws ParseException, IOException {
        int n;
        char c = this.zzj(bufferedReader);
        if (c == '\u0000') {
            throw new ParseException("Unexpected EOF");
        }
        if (c == ',') {
            throw new ParseException("Missing value");
        }
        if (c == 'n') {
            this.zzb(bufferedReader, zzwv);
            return 0;
        }
        bufferedReader.mark(1024);
        if (c == '\"') {
            boolean bl = false;
            for (n = 0; n < cArray.length && bufferedReader.read(cArray, n, 1) != -1; ++n) {
                char c2 = cArray[n];
                if (Character.isISOControl(c2)) {
                    throw new ParseException("Unexpected control character while reading string");
                }
                if (c2 == '\"' && !bl) {
                    bufferedReader.reset();
                    bufferedReader.skip(n + 1);
                    return n;
                }
                bl = c2 == '\\' ? !bl : false;
            }
        } else {
            cArray[0] = c;
            for (n = 1; n < cArray.length && bufferedReader.read(cArray, n, 1) != -1; ++n) {
                if (cArray[n] != '}' && cArray[n] != ',' && !Character.isWhitespace(cArray[n]) && cArray[n] != ']') continue;
                bufferedReader.reset();
                bufferedReader.skip(n - 1);
                cArray[n] = '\u0000';
                return n;
            }
        }
        if (n == cArray.length) {
            throw new ParseException("Absurdly long value");
        }
        throw new ParseException("Unexpected EOF");
    }

    private final void zzb(BufferedReader bufferedReader, char[] cArray) throws ParseException, IOException {
        int n;
        for (int i = 0; i < cArray.length; i += n) {
            n = bufferedReader.read(this.zzwr, 0, cArray.length - i);
            if (n == -1) {
                throw new ParseException("Unexpected EOF");
            }
            for (int j = 0; j < n; ++j) {
                if (cArray[j + i] == this.zzwr[j]) continue;
                throw new ParseException("Unexpected character");
            }
        }
    }

    private final void zzk(int n) throws ParseException {
        if (this.zzxb.isEmpty()) {
            throw new ParseException(new StringBuilder(46).append("Expected state ").append(n).append(" but had empty stack").toString());
        }
        int n2 = this.zzxb.pop();
        if (n2 != n) {
            throw new ParseException(new StringBuilder(46).append("Expected state ").append(n).append(" but had ").append(n2).toString());
        }
    }

    static /* synthetic */ int zza(FastParser fastParser, BufferedReader bufferedReader) throws ParseException, IOException {
        return fastParser.zzd(bufferedReader);
    }

    static /* synthetic */ long zzb(FastParser fastParser, BufferedReader bufferedReader) throws ParseException, IOException {
        return fastParser.zze(bufferedReader);
    }

    static /* synthetic */ float zzc(FastParser fastParser, BufferedReader bufferedReader) throws ParseException, IOException {
        return fastParser.zzg(bufferedReader);
    }

    static /* synthetic */ double zzd(FastParser fastParser, BufferedReader bufferedReader) throws ParseException, IOException {
        return fastParser.zzh(bufferedReader);
    }

    static /* synthetic */ boolean zza(FastParser fastParser, BufferedReader bufferedReader, boolean bl) throws ParseException, IOException {
        return fastParser.zza(bufferedReader, false);
    }

    static /* synthetic */ String zze(FastParser fastParser, BufferedReader bufferedReader) throws ParseException, IOException {
        return fastParser.zzc(bufferedReader);
    }

    static /* synthetic */ BigInteger zzf(FastParser fastParser, BufferedReader bufferedReader) throws ParseException, IOException {
        return fastParser.zzf(bufferedReader);
    }

    static /* synthetic */ BigDecimal zzg(FastParser fastParser, BufferedReader bufferedReader) throws ParseException, IOException {
        return fastParser.zzi(bufferedReader);
    }

    private static interface zza<O> {
        public O zzh(FastParser var1, BufferedReader var2) throws ParseException, IOException;
    }

    public static class ParseException
    extends Exception {
        public ParseException(String string2) {
            super(string2);
        }

        public ParseException(String string2, Throwable throwable) {
            super(string2, throwable);
        }

        public ParseException(Throwable throwable) {
            super(throwable);
        }
    }
}

