/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.common.data.FilteredDataBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ShuffleFilteredDataBuffer<T>
extends FilteredDataBuffer<T> {
    private final List<Integer> zzoh;
    private final int zzoi;

    public ShuffleFilteredDataBuffer(DataBuffer<T> dataBuffer, int n) {
        super(dataBuffer);
        this.zzoi = n;
        int n2 = this.mDataBuffer.getCount();
        int n3 = this.zzoi;
        if (n3 > n2) {
            throw new IllegalArgumentException("numIndexes must be smaller or equal to max");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(i);
        }
        Collections.shuffle(arrayList);
        this.zzoh = arrayList.subList(0, n3);
    }

    @Override
    public final int getCount() {
        return Math.min(this.zzoi, this.mDataBuffer.getCount());
    }

    @Override
    public final int computeRealPosition(int n) {
        if (n < 0 || n >= this.getCount()) {
            throw new IllegalArgumentException(new StringBuilder(53).append("Position ").append(n).append(" is out of bounds for this buffer").toString());
        }
        return this.zzoh.get(n);
    }
}

